/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.job;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;

final class TimeFrameUtils {
    private TimeFrameUtils() {
    }

    static OffsetDateTime adjustWeekDay(OffsetDateTime offsetDateTime, DayOfWeek weekDay) {
        if (weekDay != null) {
            int weekDayDifference = offsetDateTime.getDayOfWeek().getValue() - weekDay.getValue();
            if (weekDayDifference < 0) {
                offsetDateTime = offsetDateTime.plusDays(Math.abs(weekDayDifference));
            } else if (weekDayDifference > 0) {
                offsetDateTime = offsetDateTime.plusDays(7 - weekDayDifference);
            }
        }
        return offsetDateTime;
    }

    static OffsetDateTime adjustMonth(OffsetDateTime offsetDateTime, Year endYear, Month startMonth, Month endMonth, DayOfWeek weekDay) {
        if (startMonth == null) {
            if (endMonth != null) {
                throw new IllegalArgumentException("Either both, start and end month must be given, or none!");
            }
            offsetDateTime = TimeFrameUtils.adjustWeekDay(offsetDateTime, weekDay);
            if (endYear != null && offsetDateTime.getYear() > endYear.getValue()) {
                return null;
            }
        } else {
            OffsetDateTime lastOffsetDateTime;
            do {
                lastOffsetDateTime = offsetDateTime;
                if (startMonth.getValue() > offsetDateTime.getMonthValue()) {
                    offsetDateTime = offsetDateTime.withMonth(startMonth.getValue()).withDayOfMonth(1);
                    offsetDateTime = TimeFrameUtils.adjustWeekDay(offsetDateTime, weekDay);
                } else if (endMonth == null || endMonth.getValue() <= offsetDateTime.getMonthValue()) {
                    offsetDateTime = TimeFrameUtils.adjustWeekDay(offsetDateTime, weekDay);
                } else {
                    offsetDateTime = offsetDateTime.withYear(offsetDateTime.getYear() + 1).withMonth(startMonth.getValue()).withDayOfMonth(1);
                    offsetDateTime = TimeFrameUtils.adjustWeekDay(offsetDateTime, weekDay);
                }
                if (endYear == null || offsetDateTime.getYear() <= endYear.getValue()) continue;
                return null;
            } while (offsetDateTime != lastOffsetDateTime);
        }
        return offsetDateTime;
    }
}

