/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.mail;

import com.blazebit.mail.MailResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;

public class Mail {
    private static final String STREAM_MIME_TYPE = "application/octet-stream";
    private InternetAddress from;
    private InternetAddress replyTo;
    private List<InternetAddress> to;
    private List<InternetAddress> cc;
    private List<InternetAddress> bcc;
    private String subject;
    private String text;
    private String html;
    private List<MailResource> embeddedImages;
    private List<MailResource> attachments;
    private Map<String, String> headers;

    public List<InternetAddress> getBcc() {
        if (this.bcc == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.bcc);
    }

    public void setBcc(List<InternetAddress> bcc) {
        this.bcc = new ArrayList<InternetAddress>(bcc);
    }

    public void setBcc(String bcc) {
        try {
            this.bcc = Arrays.asList(InternetAddress.parse((String)bcc));
        }
        catch (AddressException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void addBcc(InternetAddress address) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<InternetAddress>();
        }
        this.bcc.add(address);
    }

    public void addBcc(String address) {
        this.addBcc(address, null);
    }

    public void addBcc(String[] addresses) {
        for (String address : addresses) {
            this.addBcc(address, null);
        }
    }

    public void addBcc(String address, String name) {
        this.addBcc(Mail.create(address, name));
    }

    public List<InternetAddress> getCc() {
        if (this.cc == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.cc);
    }

    public void setCc(List<InternetAddress> cc) {
        this.cc = new ArrayList<InternetAddress>(cc);
    }

    public void setCc(String cc) {
        try {
            this.cc = Arrays.asList(InternetAddress.parse((String)cc));
        }
        catch (AddressException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void addCc(InternetAddress address) {
        if (this.cc == null) {
            this.cc = new ArrayList<InternetAddress>();
        }
        this.cc.add(address);
    }

    public void addCc(String address) {
        this.addCc(address, null);
    }

    public void addCc(String[] addresses) {
        for (String address : addresses) {
            this.addCc(address, null);
        }
    }

    public void addCc(String address, String name) {
        this.addCc(Mail.create(address, name));
    }

    public List<InternetAddress> getTo() {
        if (this.to == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.to);
    }

    public void setTo(List<InternetAddress> to) {
        this.to = new ArrayList<InternetAddress>(to);
    }

    public void setTo(String to) {
        try {
            this.to = Arrays.asList(InternetAddress.parse((String)to));
        }
        catch (AddressException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void addTo(InternetAddress address) {
        if (this.to == null) {
            this.to = new ArrayList<InternetAddress>();
        }
        this.to.add(address);
    }

    public void addTo(String address) {
        this.addTo(address, null);
    }

    public void addTo(String[] addresses) {
        for (String address : addresses) {
            this.addTo(address, null);
        }
    }

    public void addTo(String address, String name) {
        this.addTo(Mail.create(address, name));
    }

    public InternetAddress getFrom() {
        return this.from;
    }

    public void setFrom(String address) {
        this.setFrom(address, null);
    }

    public void setFrom(String address, String name) {
        this.setFrom(Mail.create(address, name));
    }

    public void setFrom(InternetAddress from) {
        this.from = from;
    }

    public InternetAddress getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String address) {
        this.setReplyTo(address, null);
    }

    public void setReplyTo(String address, String name) {
        this.setReplyTo(Mail.create(address, name));
    }

    public void setReplyTo(InternetAddress replyTo) {
        this.replyTo = replyTo;
    }

    private static InternetAddress create(String address, String name) {
        String addressString;
        if (address == null || address.isEmpty() || (addressString = address.trim()).isEmpty()) {
            throw new IllegalArgumentException("Empty or no address");
        }
        try {
            if (name == null) {
                return new InternetAddress(address);
            }
            addressString = addressString.indexOf(60) == -1 ? new StringBuilder(addressString.length() + name.length() + 2).append(name).append('<').append(addressString).append('>').toString() : name + addressString;
            return new InternetAddress(addressString);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.headers);
    }

    public void addHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, String.valueOf(value));
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public List<MailResource> getEmbeddedImages() {
        if (this.embeddedImages == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.embeddedImages);
    }

    public void addEmbeddedImage(File f) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(f.getName(), new FileInputStream(f));
    }

    public void addEmbeddedImages(File[] files) throws FileNotFoundException, IOException {
        for (File f : files) {
            this.addEmbeddedImage(f.getName(), new FileInputStream(f));
        }
    }

    public void addEmbeddedImage(String fileName, File f) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(fileName, new FileInputStream(f));
    }

    public void addEmbeddedImage(File f, String mimeType) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(f.getName(), new FileInputStream(f), mimeType);
    }

    public void addEmbeddedImage(String fileName, File f, String mimeType) throws FileNotFoundException, IOException {
        this.addEmbeddedImage(fileName, new FileInputStream(f), mimeType);
    }

    public void addEmbeddedImage(String fileName, InputStream f) throws IOException {
        this.addEmbeddedImage(fileName, new InputStreamDataSource(fileName, STREAM_MIME_TYPE, f));
    }

    public void addEmbeddedImage(String fileName, InputStream f, String mimeType) throws IOException {
        this.addEmbeddedImage(fileName, new InputStreamDataSource(fileName, mimeType, f));
    }

    public void addEmbeddedImage(String fileName, byte[] f) {
        this.addEmbeddedImage(fileName, f, STREAM_MIME_TYPE);
    }

    public void addEmbeddedImage(String fileName, byte[] f, String mimeType) {
        ByteArrayDataSource ds = new ByteArrayDataSource(f, mimeType);
        ds.setName(fileName);
        this.addEmbeddedImage(fileName, (DataSource)ds);
    }

    private void addEmbeddedImage(String fileName, DataSource ds) {
        if (this.embeddedImages == null) {
            this.embeddedImages = new ArrayList<MailResource>();
        }
        this.embeddedImages.add(new MailResource(fileName, ds));
    }

    public List<MailResource> getAttachments() {
        if (this.attachments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.attachments);
    }

    public void addAttachment(File f) throws FileNotFoundException, IOException {
        this.addAttachment(f.getName(), new FileInputStream(f));
    }

    public void addAttachment(File[] files) throws FileNotFoundException, IOException {
        for (File f : files) {
            this.addAttachment(f.getName(), new FileInputStream(f));
        }
    }

    public void addAttachment(String fileName, File f) throws FileNotFoundException, IOException {
        this.addAttachment(fileName, new FileInputStream(f));
    }

    public void addAttachment(File f, String mimeType) throws FileNotFoundException, IOException {
        this.addAttachment(f.getName(), new FileInputStream(f), mimeType);
    }

    public void addAttachment(String fileName, File f, String mimeType) throws FileNotFoundException, IOException {
        this.addAttachment(fileName, new FileInputStream(f), mimeType);
    }

    public void addAttachment(String fileName, InputStream f) throws IOException {
        this.addAttachment(fileName, new InputStreamDataSource(fileName, STREAM_MIME_TYPE, f));
    }

    public void addAttachment(String fileName, InputStream f, String mimeType) throws IOException {
        this.addAttachment(fileName, new InputStreamDataSource(fileName, mimeType, f));
    }

    public void addAttachment(String fileName, byte[] f) {
        this.addAttachment(fileName, f, STREAM_MIME_TYPE);
    }

    public void addAttachment(String fileName, byte[] f, String mimeType) {
        ByteArrayDataSource ds = new ByteArrayDataSource(f, mimeType);
        ds.setName(fileName);
        this.addAttachment(fileName, (DataSource)ds);
    }

    private void addAttachment(String fileName, DataSource ds) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<MailResource>();
        }
        this.attachments.add(new MailResource(fileName, ds));
    }

    private static class InputStreamDataSource
    implements DataSource {
        private String name;
        private String contentType;
        private InputStream is;

        public InputStreamDataSource(String name, String contentType, InputStream is) {
            this.name = name;
            this.contentType = contentType;
            this.is = is;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.is;
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

