/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.mail.util;

import com.blazebit.mail.Mail;
import com.blazebit.mail.MailException;
import com.blazebit.mail.MailTransport;
import com.blazebit.mail.impl.SimpleMailSender;
import java.io.File;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailUtils {
    public static boolean validate(Mail email) throws MailException {
        if (email.getText() == null && email.getHtml() == null) {
            throw new MailException("Email is not valid: missing content body");
        }
        if (email.getSubject() == null || email.getSubject().equals("")) {
            throw new MailException("Email is not valid: missing subject");
        }
        if (email.getTo().isEmpty() && email.getBcc().isEmpty() && email.getCc().isEmpty()) {
            throw new MailException("Email is not valid: missing recipients");
        }
        if (email.getFrom() == null) {
            throw new MailException("Email is not valid: missing sender");
        }
        String exceptionMessage = null;
        try {
            exceptionMessage = "Invalid FROM address: %s";
            email.getFrom().validate();
            if (email.getReplyTo() != null) {
                exceptionMessage = "Invalid REPLY TO address: %s";
                email.getReplyTo().validate();
            }
            exceptionMessage = "Invalid TO address: %s";
            for (InternetAddress a : email.getTo()) {
                a.validate();
            }
            exceptionMessage = "Invalid BCC address: %s";
            for (InternetAddress a : email.getBcc()) {
                a.validate();
            }
            exceptionMessage = "Invalid CC address: %s";
            for (InternetAddress a : email.getCc()) {
                a.validate();
            }
        }
        catch (AddressException ex) {
            throw new MailException(String.format(exceptionMessage, email), (MessagingException)((Object)ex));
        }
        return true;
    }

    public static void sendMessage(String host, Integer port, boolean trustAllCertificates, boolean secure, String from, String[] to, String subject, String text) throws MessagingException {
        MailUtils.sendMessage(host, port, null, null, trustAllCertificates, secure, from, to, subject, text);
    }

    public static void sendMessage(String host, Integer port, String user, String password, boolean trustAllCertificates, boolean secure, String from, String[] to, String subject, String text) throws MessagingException {
        MailUtils.sendMessage(host, port, user, password, trustAllCertificates, secure, from, to, subject, text, null);
    }

    public static void sendMessage(String host, Integer port, String user, String password, boolean trustAllCertificates, boolean secure, String from, String[] to, String subject, String text, String html) throws MessagingException {
        MailUtils.sendMessage(host, port, user, password, trustAllCertificates, secure, MailUtils.createMessage(from, to, subject, text, html));
    }

    public static void sendMessage(String host, Integer port, String user, String password, boolean trustAllCertificates, boolean secure, String from, String[] to, String subject, String text, String html, File[] attachments) throws MessagingException, IOException {
        MailUtils.sendMessage(host, port, user, password, trustAllCertificates, secure, MailUtils.createMessage(from, to, subject, text, html, attachments));
    }

    public static void sendMessage(String host, Integer port, String user, String password, boolean trustAllCertificates, boolean secure, Mail m) throws MessagingException {
        MailTransport t = secure ? MailTransport.SMTPS : MailTransport.SMTP;
        t.setTrustAllHosts(trustAllCertificates);
        MailUtils.sendMessage(host, port, user, password, t, m);
    }

    public static void sendMessage(String host, Integer port, String user, String password, MailTransport t, Mail m) throws MessagingException {
        SimpleMailSender sender = new SimpleMailSender(host, port, user, password, t);
        sender.sendMail(m);
    }

    public static Mail createMessage(String from, String[] to, String subject, String text, String html) {
        Mail m = new Mail();
        m.setFrom(from);
        m.addTo(to);
        m.setSubject(subject);
        m.setText(text);
        m.setHtml(html);
        return m;
    }

    public static Mail createMessage(String from, String[] to, String subject, String text, String html, File[] attachments) throws IOException {
        Mail m = MailUtils.createMessage(from, to, subject, text, html);
        m.addAttachment(attachments);
        return m;
    }
}

