/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTagInfo;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTags;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.List;
import java.util.regex.Pattern;

public class JavadocSinceCheck
extends AbstractCheck {
    private Scope scope = Scope.PRIVATE;
    private Scope excludeScope;
    private Pattern sinceFormatPattern;
    private String sinceFormat;

    public int[] getDefaultTokens() {
        return new int[]{14, 15, 154, 157};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void setScope(String from) {
        this.scope = Scope.getInstance((String)from);
    }

    public void setExcludeScope(String excludeScope) {
        this.excludeScope = Scope.getInstance((String)excludeScope);
    }

    public void setSinceFormat(String sinceFormat) {
        this.sinceFormat = sinceFormat;
        this.sinceFormatPattern = CommonUtils.createPattern((String)sinceFormat);
    }

    public void visitToken(DetailAST ast) {
        if (this.shouldCheck(ast)) {
            int lineNo;
            FileContents contents = this.getFileContents();
            TextBlock textBlock = contents.getJavadocBefore(lineNo = ast.getLineNo());
            if (textBlock == null) {
                this.log(lineNo, "javadoc.missing", new Object[0]);
            } else {
                List<JavadocTag> tags = this.getJavadocTags(textBlock);
                if (ScopeUtils.isOuterMostType((DetailAST)ast)) {
                    this.checkTag(lineNo, tags, JavadocTagInfo.SINCE.getName(), this.sinceFormatPattern, this.sinceFormat);
                }
            }
        }
    }

    private boolean shouldCheck(DetailAST ast) {
        DetailAST mods = ast.findFirstToken(5);
        Scope declaredScope = ScopeUtils.getScopeFromMods((DetailAST)mods);
        Scope customScope = ScopeUtils.isInInterfaceOrAnnotationBlock((DetailAST)ast) ? Scope.PUBLIC : declaredScope;
        Scope surroundingScope = ScopeUtils.getSurroundingScope((DetailAST)ast);
        return customScope.isIn(this.scope) && (surroundingScope == null || surroundingScope.isIn(this.scope)) && (this.excludeScope == null || !customScope.isIn(this.excludeScope) || surroundingScope != null && !surroundingScope.isIn(this.excludeScope));
    }

    private List<JavadocTag> getJavadocTags(TextBlock textBlock) {
        JavadocTags tags = JavadocUtils.getJavadocTags((TextBlock)textBlock, (JavadocUtils.JavadocTagType)JavadocUtils.JavadocTagType.BLOCK);
        return tags.getValidTags();
    }

    private void checkTag(int lineNo, List<JavadocTag> tags, String tagName, Pattern formatPattern, String format) {
        if (formatPattern != null) {
            int tagCount = 0;
            String tagPrefix = "@";
            for (int i = tags.size() - 1; i >= 0; --i) {
                JavadocTag tag = tags.get(i);
                if (!tag.getTagName().equals(tagName)) continue;
                ++tagCount;
                if (formatPattern.matcher(tag.getFirstArg()).find()) continue;
                this.log(lineNo, "type.tagFormat", new Object[]{"@" + tagName, format});
            }
            if (tagCount == 0) {
                this.log(lineNo, "type.missingTag", new Object[]{"@" + tagName});
            }
        }
    }
}

