/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseCTECriteriaBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEBuilderListenerImpl;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import com.blazebit.persistence.impl.CustomSQLQuery;
import com.blazebit.persistence.impl.FinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.FullSelectCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.OngoingSetOperationCTECriteriaBuilderImpl;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.PropertyExpression;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;

public abstract class AbstractCTECriteriaBuilder<Y, X extends BaseCTECriteriaBuilder<X>, Z, W>
extends AbstractCommonQueryBuilder<Object, X, Z, W, BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?>>
implements BaseCTECriteriaBuilder<X>,
SelectBuilder<X>,
CTEInfoBuilder {
    protected static final Integer EMPTY = -1;
    protected final Y result;
    protected final CTEBuilderListener listener;
    protected final String cteName;
    protected final EntityType<?> cteType;
    protected final Map<String, Integer> bindingMap;
    protected final CTEBuilderListenerImpl subListener;

    public AbstractCTECriteriaBuilder(MainQuery mainQuery, Class<Object> clazz, Y result, CTEBuilderListener listener, BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder) {
        super(mainQuery, false, DbmsStatementType.SELECT, clazz, null, finalSetOperationBuilder);
        this.result = result;
        this.listener = listener;
        this.cteType = this.em.getMetamodel().entity(clazz);
        this.cteName = this.cteType.getName();
        this.bindingMap = new LinkedHashMap<String, Integer>();
        this.subListener = new CTEBuilderListenerImpl();
    }

    public CTEBuilderListenerImpl getSubListener() {
        return this.subListener;
    }

    @Override
    protected void getQueryString1(StringBuilder sbSelectFrom) {
        super.getQueryString1(sbSelectFrom);
        this.applyJpaLimit(sbSelectFrom);
    }

    @Override
    protected Query getQuery() {
        Query query;
        if (this.hasLimit()) {
            query = this.em.createQuery(this.getBaseQueryString());
            List<Query> participatingQueries = Arrays.asList(query);
            StringBuilder sqlSb = new StringBuilder(this.cbf.getExtendedQuerySupport().getSql(this.em, query));
            this.applyExtendedSql(sqlSb, false, true, null, null, null);
            String finalSql = sqlSb.toString();
            query = new CustomSQLQuery(participatingQueries, query, this.dbmsDialect, this.em, this.cbf.getExtendedQuerySupport(), finalSql, null);
        } else {
            query = this.em.createQuery(this.getBaseQueryString());
        }
        this.parameterizeQuery(query);
        return query;
    }

    public SelectBuilder<X> bind(String cteAttribute) {
        Attribute attribute = this.cteType.getAttribute(cteAttribute);
        if (attribute == null) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] does not exist!");
        }
        if (this.bindingMap.containsKey(cteAttribute)) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] has already been bound!");
        }
        this.bindingMap.put(cteAttribute, this.selectManager.getSelectInfos().size());
        return this;
    }

    public Y end() {
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public CTEInfo createCTEInfo() {
        List<String> attributes = this.prepareAndGetAttributes();
        CTEInfo info = new CTEInfo(this.cteName, this.cteType, attributes, false, false, this, null);
        return info;
    }

    protected List<String> prepareAndGetAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(this.bindingMap.size());
        for (Map.Entry<String, Integer> bindingEntry : this.bindingMap.entrySet()) {
            String attributeName = bindingEntry.getKey();
            Attribute attribute = this.cteType.getAttribute(attributeName);
            attributes.add(attributeName);
            if (!JpaUtils.isJoinable(attribute)) continue;
            EntityType type = this.em.getMetamodel().entity(JpaUtils.resolveFieldClass(this.cteType.getJavaType(), attribute));
            Attribute<?, ?> idAttribute = JpaUtils.getIdAttribute(type);
            PathExpression pathExpression = (PathExpression)this.selectManager.getSelectInfos().get(bindingEntry.getValue()).getExpression();
            pathExpression.getExpressions().add(new PropertyExpression(idAttribute.getName()));
        }
        return attributes;
    }

    protected BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> createFinalSetOperationBuilder(SetOperationType operator, boolean nested, boolean isSubquery) {
        FullSelectCTECriteriaBuilderImpl<?> newInitiator = this.finalSetOperationBuilder == null ? null : ((BaseFinalSetOperationCTECriteriaBuilderImpl)this.finalSetOperationBuilder).getInitiator();
        return this.createFinalSetOperationBuilder(operator, nested, isSubquery, newInitiator);
    }

    protected BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> createFinalSetOperationBuilder(SetOperationType operator, boolean nested, boolean isSubquery, FullSelectCTECriteriaBuilderImpl<?> initiator) {
        Y newResult;
        CTEBuilderListener newListener = this.finalSetOperationBuilder == null ? this.listener : ((BaseFinalSetOperationCTECriteriaBuilderImpl)this.finalSetOperationBuilder).getSubListener();
        Object object = newResult = this.finalSetOperationBuilder == null ? this.result : ((BaseFinalSetOperationCTECriteriaBuilderImpl)this.finalSetOperationBuilder).getResult();
        if (isSubquery) {
            return new OngoingFinalSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, this.resultType, newResult, operator, nested, newListener, initiator);
        }
        return new FinalSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, this.resultType, newResult, operator, nested, newListener, initiator);
    }

    protected LeafOngoingSetOperationCTECriteriaBuilderImpl<Y> createLeaf(BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder) {
        CTEBuilderListenerImpl newListener = finalSetOperationBuilder.getSubListener();
        LeafOngoingSetOperationCTECriteriaBuilderImpl<Y> next = new LeafOngoingSetOperationCTECriteriaBuilderImpl<Y>(this.mainQuery, (Class<Object>)this.resultType, this.result, (CTEBuilderListener)newListener, (FinalSetOperationCTECriteriaBuilderImpl)finalSetOperationBuilder);
        newListener.onBuilderStarted(next);
        return next;
    }

    protected <T> OngoingSetOperationCTECriteriaBuilderImpl<Y, T> createOngoing(BaseFinalSetOperationCTECriteriaBuilderImpl<Object, ?> finalSetOperationBuilder, T endSetResult) {
        finalSetOperationBuilder.setEndSetResult(endSetResult);
        CTEBuilderListenerImpl newListener = finalSetOperationBuilder.getSubListener();
        OngoingSetOperationCTECriteriaBuilderImpl<Y, T> next = new OngoingSetOperationCTECriteriaBuilderImpl<Y, T>(this.mainQuery, this.resultType, this.result, newListener, (OngoingFinalSetOperationCTECriteriaBuilderImpl)finalSetOperationBuilder, endSetResult);
        newListener.onBuilderStarted(next);
        return next;
    }
}

