/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.HavingOrBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.KeysetBuilder;
import com.blazebit.persistence.LeafOngoingSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.ReturningModificationCriteriaBuilderFactory;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.StartOngoingSetOperationCTECriteriaBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.WhereOrBuilder;
import com.blazebit.persistence.impl.AggregateDetectionVisitor;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.CriteriaBuilderFactoryImpl;
import com.blazebit.persistence.impl.CriteriaBuilderImpl;
import com.blazebit.persistence.impl.CustomSQLQuery;
import com.blazebit.persistence.impl.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.GroupByManager;
import com.blazebit.persistence.impl.HavingManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OnClauseJoinNodeVisitor;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.OrderByManager;
import com.blazebit.persistence.impl.OuterFunctionTransformer;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectManager;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.impl.SizeSelectToCountTransformer;
import com.blazebit.persistence.impl.SizeSelectToSubqueryTransformer;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryRecursiveExpressionTransformer;
import com.blazebit.persistence.impl.WhereManager;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.jpaprovider.JpaProvider;
import com.blazebit.persistence.impl.keyset.KeysetBuilderImpl;
import com.blazebit.persistence.impl.keyset.KeysetImpl;
import com.blazebit.persistence.impl.keyset.KeysetLink;
import com.blazebit.persistence.impl.keyset.KeysetManager;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.SimpleKeysetLink;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.QueryTransformer;
import com.blazebit.persistence.spi.SetOperationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public abstract class AbstractCommonQueryBuilder<QueryResultType, BuilderType, SetReturn, SubquerySetReturn, FinalSetReturn extends BaseFinalSetOperationBuilderImpl<?, ?, ?>> {
    protected static final Logger LOG = Logger.getLogger(CriteriaBuilderImpl.class.getName());
    public static final String idParamName = "ids";
    protected final MainQuery mainQuery;
    protected boolean isMainQuery;
    protected final CriteriaBuilderFactoryImpl cbf;
    protected final EntityManager em;
    protected final DbmsStatementType statementType;
    protected final Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities;
    protected final ParameterManager parameterManager;
    protected final SelectManager<QueryResultType> selectManager;
    protected final WhereManager<BuilderType> whereManager;
    protected final HavingManager<BuilderType> havingManager;
    protected final GroupByManager groupByManager;
    protected final OrderByManager orderByManager;
    protected final JoinManager joinManager;
    protected final KeysetManager keysetManager;
    protected final CTEManager cteManager;
    protected final ResolvingQueryGenerator queryGenerator;
    protected final SubqueryInitiatorFactory subqueryInitFactory;
    protected final FinalSetReturn finalSetOperationBuilder;
    protected final DbmsDialect dbmsDialect;
    protected final JpaProvider jpaProvider;
    protected final Set<String> registeredFunctions;
    protected final AliasManager aliasManager;
    protected final ExpressionFactory expressionFactory;
    private final List<ExpressionTransformer> transformers;
    private final SizeSelectToCountTransformer sizeSelectToCountTransformer;
    private final SizeSelectToSubqueryTransformer sizeSelectToSubqueryTransformer;
    protected Class<QueryResultType> resultType;
    protected int firstResult;
    protected int maxResults;
    protected boolean fromClassExplicitelySet;
    private boolean needsCheck;
    private boolean implicitJoinsApplied;
    protected String cachedQueryString;
    protected String cachedCteQueryString;
    protected boolean hasGroupBy;

    protected AbstractCommonQueryBuilder(AbstractCommonQueryBuilder<QueryResultType, ?, ?, ?, ?> builder) {
        this.explicitVersionEntities = new HashMap(0);
        this.firstResult = 0;
        this.maxResults = Integer.MAX_VALUE;
        this.fromClassExplicitelySet = false;
        this.needsCheck = true;
        this.implicitJoinsApplied = false;
        this.hasGroupBy = false;
        this.mainQuery = builder.mainQuery;
        this.isMainQuery = builder.isMainQuery;
        this.cbf = builder.cbf;
        this.statementType = builder.statementType;
        this.orderByManager = builder.orderByManager;
        this.parameterManager = builder.parameterManager;
        this.selectManager = builder.selectManager;
        this.whereManager = builder.whereManager;
        this.havingManager = builder.havingManager;
        this.groupByManager = builder.groupByManager;
        this.keysetManager = builder.keysetManager;
        this.cteManager = builder.cteManager;
        this.joinManager = builder.joinManager;
        this.queryGenerator = builder.queryGenerator;
        this.em = builder.em;
        this.finalSetOperationBuilder = builder.finalSetOperationBuilder;
        this.dbmsDialect = builder.dbmsDialect;
        this.jpaProvider = builder.jpaProvider;
        this.registeredFunctions = builder.registeredFunctions;
        this.subqueryInitFactory = builder.subqueryInitFactory;
        this.aliasManager = builder.aliasManager;
        this.expressionFactory = builder.expressionFactory;
        this.transformers = builder.transformers;
        this.resultType = builder.resultType;
        this.sizeSelectToCountTransformer = builder.sizeSelectToCountTransformer;
        this.sizeSelectToSubqueryTransformer = builder.sizeSelectToSubqueryTransformer;
    }

    protected AbstractCommonQueryBuilder(MainQuery mainQuery, boolean isMainQuery, DbmsStatementType statementType, Class<QueryResultType> resultClazz, String alias, AliasManager aliasManager, JoinManager parentJoinManager, ExpressionFactory expressionFactory, FinalSetReturn finalSetOperationBuilder) {
        block7: {
            this.explicitVersionEntities = new HashMap(0);
            this.firstResult = 0;
            this.maxResults = Integer.MAX_VALUE;
            this.fromClassExplicitelySet = false;
            this.needsCheck = true;
            this.implicitJoinsApplied = false;
            this.hasGroupBy = false;
            if (mainQuery == null) {
                throw new NullPointerException("mainQuery");
            }
            if (statementType == null) {
                throw new NullPointerException("statementType");
            }
            if (resultClazz == null) {
                throw new NullPointerException("resultClazz");
            }
            this.mainQuery = mainQuery;
            this.isMainQuery = isMainQuery;
            this.statementType = statementType;
            this.cbf = mainQuery.cbf;
            this.parameterManager = mainQuery.parameterManager;
            this.cteManager = mainQuery.cteManager;
            this.em = mainQuery.em;
            this.dbmsDialect = mainQuery.dbmsDialect;
            this.jpaProvider = mainQuery.jpaProvider;
            this.registeredFunctions = mainQuery.registeredFunctions;
            this.aliasManager = new AliasManager(aliasManager);
            this.expressionFactory = expressionFactory;
            this.queryGenerator = new ResolvingQueryGenerator(this.aliasManager, this.jpaProvider, this.registeredFunctions);
            this.joinManager = new JoinManager(mainQuery, this.queryGenerator, this.aliasManager, parentJoinManager, expressionFactory);
            if (alias == null) {
                alias = resultClazz.getSimpleName().toLowerCase();
            } else {
                this.fromClassExplicitelySet = true;
            }
            try {
                this.joinManager.addRoot(this.em.getMetamodel().entity(resultClazz), alias);
            }
            catch (IllegalArgumentException ex) {
                if (!this.fromClassExplicitelySet) break block7;
                throw new IllegalArgumentException("The class [" + resultClazz.getName() + "] is not an entity and therefore can't be aliased!");
            }
        }
        this.subqueryInitFactory = new SubqueryInitiatorFactory(mainQuery, this.aliasManager, this.joinManager);
        this.joinManager.setSubqueryInitFactory(this.subqueryInitFactory);
        this.whereManager = new WhereManager(this.queryGenerator, this.parameterManager, this.subqueryInitFactory, expressionFactory);
        this.havingManager = new HavingManager(this.queryGenerator, this.parameterManager, this.subqueryInitFactory, expressionFactory);
        this.groupByManager = new GroupByManager(this.queryGenerator, this.parameterManager);
        this.selectManager = new SelectManager(this.queryGenerator, this.parameterManager, this.joinManager, this.aliasManager, this.subqueryInitFactory, expressionFactory, this.jpaProvider, resultClazz);
        this.orderByManager = new OrderByManager(this.queryGenerator, this.parameterManager, this.aliasManager, this.jpaProvider);
        this.keysetManager = new KeysetManager(this.queryGenerator, this.parameterManager);
        this.transformers = Arrays.asList(new OuterFunctionTransformer(this.joinManager), new SubqueryRecursiveExpressionTransformer());
        this.sizeSelectToCountTransformer = new SizeSelectToCountTransformer(this.joinManager, this.groupByManager, this.orderByManager, this.em.getMetamodel());
        this.sizeSelectToSubqueryTransformer = new SizeSelectToSubqueryTransformer(this.subqueryInitFactory, this.aliasManager);
        this.resultType = resultClazz;
        this.finalSetOperationBuilder = finalSetOperationBuilder;
    }

    public AbstractCommonQueryBuilder(MainQuery mainQuery, boolean isMainQuery, DbmsStatementType statementType, Class<QueryResultType> resultClazz, String alias, FinalSetReturn finalSetOperationBuilder) {
        this(mainQuery, isMainQuery, statementType, resultClazz, alias, null, null, mainQuery.cbf.getExpressionFactory(), finalSetOperationBuilder);
    }

    public AbstractCommonQueryBuilder(MainQuery mainQuery, boolean isMainQuery, DbmsStatementType statementType, Class<QueryResultType> resultClazz, String alias) {
        this(mainQuery, isMainQuery, statementType, resultClazz, alias, null);
    }

    public CriteriaBuilderFactory getCriteriaBuilderFactory() {
        return this.cbf;
    }

    public StartOngoingSetOperationCTECriteriaBuilder<BuilderType, LeafOngoingSetOperationCTECriteriaBuilder<BuilderType>> withStartSet(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClause()) {
            throw new UnsupportedOperationException("The database does not support the with clause!");
        }
        return this.cteManager.withStartSet(cteClass, this);
    }

    public FullSelectCTECriteriaBuilder<BuilderType> with(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClause()) {
            throw new UnsupportedOperationException("The database does not support the with clause!");
        }
        return this.cteManager.with(cteClass, this);
    }

    public SelectRecursiveCTECriteriaBuilder<BuilderType> withRecursive(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClause()) {
            throw new UnsupportedOperationException("The database does not support the with clause!");
        }
        return this.cteManager.withRecursive(cteClass, this);
    }

    public ReturningModificationCriteriaBuilderFactory<BuilderType> withReturning(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClause()) {
            throw new UnsupportedOperationException("The database does not support the with clause!");
        }
        if (!this.dbmsDialect.supportsModificationQueryInWithClause()) {
            throw new UnsupportedOperationException("The database does not support modification queries in the with clause!");
        }
        return this.cteManager.withReturning(cteClass, this);
    }

    public SetReturn union() {
        return this.addSetOperation(SetOperationType.UNION);
    }

    public SetReturn unionAll() {
        return this.addSetOperation(SetOperationType.UNION_ALL);
    }

    public SetReturn intersect() {
        return this.addSetOperation(SetOperationType.INTERSECT);
    }

    public SetReturn intersectAll() {
        return this.addSetOperation(SetOperationType.INTERSECT_ALL);
    }

    public SetReturn except() {
        return this.addSetOperation(SetOperationType.EXCEPT);
    }

    public SetReturn exceptAll() {
        return this.addSetOperation(SetOperationType.EXCEPT_ALL);
    }

    public SubquerySetReturn startUnion() {
        return this.addSubquerySetOperation(SetOperationType.UNION);
    }

    public SubquerySetReturn startUnionAll() {
        return this.addSubquerySetOperation(SetOperationType.UNION_ALL);
    }

    public SubquerySetReturn startIntersect() {
        return this.addSubquerySetOperation(SetOperationType.INTERSECT);
    }

    public SubquerySetReturn startIntersectAll() {
        return this.addSubquerySetOperation(SetOperationType.INTERSECT_ALL);
    }

    public SubquerySetReturn startExcept() {
        return this.addSubquerySetOperation(SetOperationType.EXCEPT);
    }

    public SubquerySetReturn startExceptAll() {
        return this.addSubquerySetOperation(SetOperationType.EXCEPT_ALL);
    }

    public SubquerySetReturn startSet() {
        return this.addSubquerySetOperation(null);
    }

    private SetReturn addSetOperation(SetOperationType type) {
        FinalSetReturn finalSetOperationBuilder = this.finalSetOperationBuilder;
        if (finalSetOperationBuilder == null) {
            finalSetOperationBuilder = this.createFinalSetOperationBuilder(type, false);
            ((BaseFinalSetOperationBuilderImpl)finalSetOperationBuilder).setOperationManager.setStartQueryBuilder(this);
        } else {
            SetOperationManager oldOperationManager = ((BaseFinalSetOperationBuilderImpl)finalSetOperationBuilder).setOperationManager;
            if (oldOperationManager.getOperator() == null) {
                oldOperationManager.setOperator(type);
            } else if (oldOperationManager.getOperator() != type) {
                FinalSetReturn subFinalSetOperationBuilder = this.createFinalSetOperationBuilder(oldOperationManager.getOperator(), false);
                ((BaseFinalSetOperationBuilderImpl)subFinalSetOperationBuilder).setOperationManager.setStartQueryBuilder(oldOperationManager.getStartQueryBuilder());
                ((BaseFinalSetOperationBuilderImpl)subFinalSetOperationBuilder).setOperationManager.getSetOperations().addAll(oldOperationManager.getSetOperations());
                oldOperationManager.setStartQueryBuilder((AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)subFinalSetOperationBuilder);
                oldOperationManager.getSetOperations().clear();
                oldOperationManager.setOperator(type);
            }
        }
        SetReturn setOperand = this.createSetOperand(finalSetOperationBuilder);
        ((BaseFinalSetOperationBuilderImpl)finalSetOperationBuilder).setOperationManager.addSetOperation((AbstractCommonQueryBuilder)setOperand);
        return setOperand;
    }

    private SubquerySetReturn addSubquerySetOperation(SetOperationType type) {
        FinalSetReturn parentFinalSetOperationBuilder = this.finalSetOperationBuilder;
        if (parentFinalSetOperationBuilder == null) {
            parentFinalSetOperationBuilder = this.createFinalSetOperationBuilder(type, false);
            ((BaseFinalSetOperationBuilderImpl)parentFinalSetOperationBuilder).setOperationManager.setStartQueryBuilder(this);
        } else {
            SetOperationManager oldParentOperationManager = ((BaseFinalSetOperationBuilderImpl)this.finalSetOperationBuilder).setOperationManager;
            if (oldParentOperationManager.getOperator() == null) {
                oldParentOperationManager.setOperator(type);
            } else if (oldParentOperationManager.getOperator() != type) {
                FinalSetReturn subFinalSetOperationBuilder = this.createFinalSetOperationBuilder(oldParentOperationManager.getOperator(), false);
                ((BaseFinalSetOperationBuilderImpl)subFinalSetOperationBuilder).setOperationManager.setStartQueryBuilder(oldParentOperationManager.getStartQueryBuilder());
                ((BaseFinalSetOperationBuilderImpl)subFinalSetOperationBuilder).setOperationManager.getSetOperations().addAll(oldParentOperationManager.getSetOperations());
                oldParentOperationManager.setStartQueryBuilder((AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)subFinalSetOperationBuilder);
                oldParentOperationManager.getSetOperations().clear();
                oldParentOperationManager.setOperator(type);
            }
        }
        FinalSetReturn finalSetOperationBuilder = this.createFinalSetOperationBuilder(type, true);
        SubquerySetReturn subquerySetOperand = this.createSubquerySetOperand(finalSetOperationBuilder, parentFinalSetOperationBuilder);
        ((BaseFinalSetOperationBuilderImpl)finalSetOperationBuilder).setOperationManager.setStartQueryBuilder((AbstractCommonQueryBuilder)subquerySetOperand);
        if (type != null) {
            ((BaseFinalSetOperationBuilderImpl)parentFinalSetOperationBuilder).setOperationManager.addSetOperation((AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)finalSetOperationBuilder);
        } else {
            ((BaseFinalSetOperationBuilderImpl)parentFinalSetOperationBuilder).setOperationManager.setStartQueryBuilder((AbstractCommonQueryBuilder<?, ?, ?, ?, ?>)finalSetOperationBuilder);
        }
        return subquerySetOperand;
    }

    protected FinalSetReturn createFinalSetOperationBuilder(SetOperationType operator, boolean nested) {
        throw new IllegalArgumentException("Set operations aren't supported!");
    }

    protected SetReturn createSetOperand(FinalSetReturn baseQueryBuilder) {
        throw new IllegalArgumentException("Set operations aren't supported!");
    }

    protected SubquerySetReturn createSubquerySetOperand(FinalSetReturn baseQueryBuilder, FinalSetReturn resultFinalSetOperationBuilder) {
        throw new IllegalArgumentException("Set operations aren't supported!");
    }

    public BuilderType from(Class<?> clazz) {
        return this.from(clazz, clazz.getSimpleName().toLowerCase());
    }

    public BuilderType from(Class<?> clazz, String alias) {
        return this.from(clazz, alias, null);
    }

    public BuilderType fromOld(Class<?> clazz) {
        return this.fromOld(clazz, clazz.getSimpleName().toLowerCase());
    }

    public BuilderType fromOld(Class<?> clazz, String alias) {
        return this.from(clazz, alias, DbmsModificationState.OLD);
    }

    public BuilderType fromNew(Class<?> clazz) {
        return this.fromNew(clazz, clazz.getSimpleName().toLowerCase());
    }

    public BuilderType fromNew(Class<?> clazz, String alias) {
        return this.from(clazz, alias, DbmsModificationState.NEW);
    }

    private BuilderType from(Class<?> clazz, String alias, DbmsModificationState state) {
        if (!this.fromClassExplicitelySet && this.joinManager.getRoots().size() > 0) {
            this.joinManager.removeRoot();
        }
        EntityType type = this.em.getMetamodel().entity(clazz);
        String finalAlias = this.joinManager.addRoot(type, alias);
        this.fromClassExplicitelySet = true;
        if (state != null) {
            Map<String, DbmsModificationState> versionEntities = this.explicitVersionEntities.get(clazz);
            if (versionEntities == null) {
                versionEntities = new HashMap<String, DbmsModificationState>(1);
                this.explicitVersionEntities.put(clazz, versionEntities);
            }
            versionEntities.put(finalAlias, state);
        }
        return (BuilderType)this;
    }

    public BuilderType setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return (BuilderType)this;
    }

    public BuilderType setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return (BuilderType)this;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Metamodel getMetamodel() {
        return this.em.getMetamodel();
    }

    void parameterizeQuery(Query q) {
        for (Parameter p : q.getParameters()) {
            Object wrappedValue;
            Object paramValue = this.parameterManager.getParameterValue(p.getName());
            if (paramValue instanceof ParameterManager.TemporalCalendarParameterWrapper) {
                wrappedValue = (ParameterManager.TemporalCalendarParameterWrapper)paramValue;
                q.setParameter(p.getName(), ((ParameterManager.TemporalCalendarParameterWrapper)wrappedValue).getValue(), ((ParameterManager.TemporalCalendarParameterWrapper)wrappedValue).getType());
                continue;
            }
            if (paramValue instanceof ParameterManager.TemporalDateParameterWrapper) {
                wrappedValue = (ParameterManager.TemporalDateParameterWrapper)paramValue;
                q.setParameter(p.getName(), ((ParameterManager.TemporalDateParameterWrapper)wrappedValue).getValue(), ((ParameterManager.TemporalDateParameterWrapper)wrappedValue).getType());
                continue;
            }
            q.setParameter(p.getName(), paramValue);
        }
    }

    public BuilderType setParameter(String name, Object value) {
        this.parameterManager.satisfyParameter(name, value);
        return (BuilderType)this;
    }

    public BuilderType setParameter(String name, Calendar value, TemporalType temporalType) {
        this.parameterManager.satisfyParameter(name, new ParameterManager.TemporalCalendarParameterWrapper(value, temporalType));
        return (BuilderType)this;
    }

    public BuilderType setParameter(String name, Date value, TemporalType temporalType) {
        this.parameterManager.satisfyParameter(name, new ParameterManager.TemporalDateParameterWrapper(value, temporalType));
        return (BuilderType)this;
    }

    public boolean containsParameter(String name) {
        return this.parameterManager.containsParameter(name);
    }

    public boolean isParameterSet(String name) {
        return this.parameterManager.isParameterSet(name);
    }

    public Parameter<?> getParameter(String name) {
        return this.parameterManager.getParameter(name);
    }

    public Set<? extends Parameter<?>> getParameters() {
        return this.parameterManager.getParameters();
    }

    public Object getParameterValue(String name) {
        return this.parameterManager.getParameterValue(name);
    }

    public BuilderType distinct() {
        this.clearCache();
        this.selectManager.distinct();
        return (BuilderType)this;
    }

    public CaseWhenStarterBuilder<BuilderType> selectCase() {
        return this.selectCase(null);
    }

    public CaseWhenStarterBuilder<BuilderType> selectCase(String selectAlias) {
        if (selectAlias != null && selectAlias.isEmpty()) {
            throw new IllegalArgumentException("selectAlias");
        }
        return this.selectManager.selectCase(this, selectAlias);
    }

    public SimpleCaseWhenStarterBuilder<BuilderType> selectSimpleCase(String expression) {
        return this.selectSimpleCase(expression, null);
    }

    public SimpleCaseWhenStarterBuilder<BuilderType> selectSimpleCase(String caseOperandExpression, String selectAlias) {
        if (selectAlias != null && selectAlias.isEmpty()) {
            throw new IllegalArgumentException("selectAlias");
        }
        return this.selectManager.selectSimpleCase(this, selectAlias, this.expressionFactory.createCaseOperandExpression(caseOperandExpression));
    }

    public BuilderType select(String expression) {
        return this.select(expression, null);
    }

    public BuilderType select(String expression, String selectAlias) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        if (selectAlias != null && selectAlias.isEmpty()) {
            throw new IllegalArgumentException("selectAlias");
        }
        this.verifyBuilderEnded();
        this.selectManager.select(expr, selectAlias);
        if (this.selectManager.getSelectInfos().size() > 1) {
            this.resultType = Tuple.class;
        }
        return (BuilderType)this;
    }

    public SubqueryInitiator<BuilderType> selectSubquery() {
        return this.selectSubquery(null);
    }

    public SubqueryInitiator<BuilderType> selectSubquery(String selectAlias) {
        if (selectAlias != null && selectAlias.isEmpty()) {
            throw new IllegalArgumentException("selectAlias");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectSubquery(this, selectAlias);
    }

    public SubqueryInitiator<BuilderType> selectSubquery(String subqueryAlias, String expression) {
        return this.selectSubquery(subqueryAlias, expression, null);
    }

    public SubqueryInitiator<BuilderType> selectSubquery(String subqueryAlias, String expression, String selectAlias) {
        if (selectAlias != null && selectAlias.isEmpty()) {
            throw new IllegalArgumentException("selectAlias");
        }
        if (subqueryAlias == null) {
            throw new NullPointerException("subqueryAlias");
        }
        if (subqueryAlias.isEmpty()) {
            throw new IllegalArgumentException("subqueryAlias");
        }
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        if (!expression.contains(subqueryAlias)) {
            throw new IllegalArgumentException("Expression [" + expression + "] does not contain subquery alias [" + subqueryAlias + "]");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectSubquery(this, subqueryAlias, this.expressionFactory.createSimpleExpression(expression), selectAlias);
    }

    public RestrictionBuilder<BuilderType> where(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        return this.whereManager.restrict(this, expr);
    }

    public CaseWhenStarterBuilder<RestrictionBuilder<BuilderType>> whereCase() {
        return this.whereManager.restrictCase(this);
    }

    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<BuilderType>> whereSimpleCase(String expression) {
        return this.whereManager.restrictSimpleCase(this, this.expressionFactory.createCaseOperandExpression(expression));
    }

    public WhereOrBuilder<BuilderType> whereOr() {
        return this.whereManager.whereOr(this);
    }

    public SubqueryInitiator<BuilderType> whereExists() {
        return this.whereManager.restrictExists(this);
    }

    public SubqueryInitiator<BuilderType> whereNotExists() {
        return this.whereManager.restrictNotExists(this);
    }

    public SubqueryInitiator<RestrictionBuilder<BuilderType>> whereSubquery() {
        return this.whereManager.restrict(this);
    }

    public SubqueryInitiator<RestrictionBuilder<BuilderType>> whereSubquery(String subqueryAlias, String expression) {
        return this.whereManager.restrict(this, subqueryAlias, expression);
    }

    public BuilderType groupBy(String ... paths) {
        for (String path : paths) {
            this.groupBy(path);
        }
        return (BuilderType)this;
    }

    public BuilderType groupBy(String expression) {
        this.clearCache();
        Object expr = this.cbf.isCompatibleModeEnabled() ? this.expressionFactory.createPathExpression(expression) : this.expressionFactory.createSimpleExpression(expression);
        this.verifyBuilderEnded();
        this.groupByManager.groupBy((Expression)expr);
        return (BuilderType)this;
    }

    public RestrictionBuilder<BuilderType> having(String expression) {
        this.clearCache();
        if (this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Having without group by");
        }
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        return this.havingManager.restrict(this, expr);
    }

    public CaseWhenStarterBuilder<RestrictionBuilder<BuilderType>> havingCase() {
        return this.havingManager.restrictCase(this);
    }

    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<BuilderType>> havingSimpleCase(String expression) {
        return this.havingManager.restrictSimpleCase(this, this.expressionFactory.createCaseOperandExpression(expression));
    }

    public HavingOrBuilder<BuilderType> havingOr() {
        this.clearCache();
        if (this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Having without group by");
        }
        return this.havingManager.havingOr(this);
    }

    public SubqueryInitiator<BuilderType> havingExists() {
        this.clearCache();
        if (this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Having without group by");
        }
        return this.havingManager.restrictExists(this);
    }

    public SubqueryInitiator<BuilderType> havingNotExists() {
        this.clearCache();
        if (this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Having without group by");
        }
        return this.havingManager.restrictNotExists(this);
    }

    public SubqueryInitiator<RestrictionBuilder<BuilderType>> havingSubquery() {
        this.clearCache();
        return this.havingManager.restrict(this);
    }

    public SubqueryInitiator<RestrictionBuilder<BuilderType>> havingSubquery(String subqueryAlias, String expression) {
        this.clearCache();
        return this.havingManager.restrict(this, subqueryAlias, expression);
    }

    public BuilderType orderByDesc(String expression) {
        return this.orderBy(expression, false, false);
    }

    public BuilderType orderByAsc(String expression) {
        return this.orderBy(expression, true, false);
    }

    public BuilderType orderByDesc(String expression, boolean nullFirst) {
        return this.orderBy(expression, false, nullFirst);
    }

    public BuilderType orderByAsc(String expression, boolean nullFirst) {
        return this.orderBy(expression, true, nullFirst);
    }

    public BuilderType orderBy(String expression, boolean ascending, boolean nullFirst) {
        Expression expr = this.cbf.isCompatibleModeEnabled() ? this.expressionFactory.createOrderByExpression(expression) : this.expressionFactory.createSimpleExpression(expression);
        this._orderBy(expr, ascending, nullFirst);
        return (BuilderType)this;
    }

    protected void verifyBuilderEnded() {
        if (this.isMainQuery) {
            this.cteManager.verifyBuilderEnded();
        }
        this.whereManager.verifyBuilderEnded();
        this.keysetManager.verifyBuilderEnded();
        this.havingManager.verifyBuilderEnded();
        this.selectManager.verifyBuilderEnded();
        this.joinManager.verifyBuilderEnded();
    }

    public void _orderBy(Expression expression, boolean ascending, boolean nullFirst) {
        this.clearCache();
        this.verifyBuilderEnded();
        this.orderByManager.orderBy(expression, ascending, nullFirst);
    }

    public BuilderType innerJoin(String path, String alias) {
        return this.join(path, alias, JoinType.INNER);
    }

    public BuilderType innerJoinDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.INNER);
    }

    public BuilderType leftJoin(String path, String alias) {
        return this.join(path, alias, JoinType.LEFT);
    }

    public BuilderType leftJoinDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.LEFT);
    }

    public BuilderType rightJoin(String path, String alias) {
        return this.join(path, alias, JoinType.RIGHT);
    }

    public BuilderType rightJoinDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.RIGHT);
    }

    public BuilderType join(String path, String alias, JoinType type) {
        this.clearCache();
        this.checkJoinPreconditions(path, alias, type);
        this.joinManager.join(path, alias, type, false, false);
        return (BuilderType)this;
    }

    public BuilderType joinDefault(String path, String alias, JoinType type) {
        this.clearCache();
        this.checkJoinPreconditions(path, alias, type);
        this.joinManager.join(path, alias, type, false, true);
        return (BuilderType)this;
    }

    public JoinOnBuilder<BuilderType> joinOn(String path, String alias, JoinType type) {
        this.clearCache();
        this.checkJoinPreconditions(path, alias, type);
        return this.joinManager.joinOn(this, path, alias, type, false);
    }

    public JoinOnBuilder<BuilderType> joinDefaultOn(String path, String alias, JoinType type) {
        this.clearCache();
        this.checkJoinPreconditions(path, alias, type);
        return this.joinManager.joinOn(this, path, alias, type, true);
    }

    public JoinOnBuilder<BuilderType> innerJoinOn(String path, String alias) {
        return this.joinOn(path, alias, JoinType.INNER);
    }

    public JoinOnBuilder<BuilderType> innerJoinDefaultOn(String path, String alias) {
        return this.joinDefaultOn(path, alias, JoinType.INNER);
    }

    public JoinOnBuilder<BuilderType> leftJoinOn(String path, String alias) {
        return this.joinOn(path, alias, JoinType.LEFT);
    }

    public JoinOnBuilder<BuilderType> leftJoinDefaultOn(String path, String alias) {
        return this.joinDefaultOn(path, alias, JoinType.LEFT);
    }

    public JoinOnBuilder<BuilderType> rightJoinOn(String path, String alias) {
        return this.joinOn(path, alias, JoinType.RIGHT);
    }

    public JoinOnBuilder<BuilderType> rightJoinDefaultOn(String path, String alias) {
        return this.joinDefaultOn(path, alias, JoinType.RIGHT);
    }

    private void checkJoinPreconditions(String path, String alias, JoinType type) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (alias.isEmpty()) {
            throw new IllegalArgumentException("Empty alias");
        }
        this.verifyBuilderEnded();
    }

    protected boolean isJoinRequiredForSelect() {
        return true;
    }

    protected void applyImplicitJoins() {
        if (this.implicitJoinsApplied) {
            return;
        }
        JoinVisitor joinVisitor = new JoinVisitor(this.joinManager);
        OnClauseJoinNodeVisitor joinNodeVisitor = new OnClauseJoinNodeVisitor((Expression.Visitor)joinVisitor){

            @Override
            public void visit(JoinNode node) {
                super.visit(node);
                node.registerDependencies();
            }
        };
        joinVisitor.setFromClause(null);
        this.joinManager.acceptVisitor(joinNodeVisitor);
        joinVisitor.setFromClause(ClauseType.SELECT);
        joinVisitor.setJoinRequired(this.isJoinRequiredForSelect());
        this.selectManager.acceptVisitor((Expression.Visitor)joinVisitor);
        joinVisitor.setJoinRequired(true);
        joinVisitor.setFromClause(ClauseType.WHERE);
        this.whereManager.acceptVisitor((Expression.Visitor)joinVisitor);
        joinVisitor.setFromClause(ClauseType.GROUP_BY);
        this.groupByManager.acceptVisitor((Expression.Visitor)joinVisitor);
        joinVisitor.setFromClause(ClauseType.HAVING);
        this.havingManager.acceptVisitor((Expression.Visitor)joinVisitor);
        joinVisitor.setJoinWithObjectLeafAllowed(false);
        joinVisitor.setFromClause(ClauseType.ORDER_BY);
        this.orderByManager.acceptVisitor((Expression.Visitor)joinVisitor);
        joinVisitor.setJoinWithObjectLeafAllowed(true);
        this.implicitJoinsApplied = true;
    }

    protected void applyVisitor(VisitorAdapter expressionVisitor) {
        this.selectManager.acceptVisitor((Expression.Visitor)expressionVisitor);
        this.joinManager.acceptVisitor(new OnClauseJoinNodeVisitor((Expression.Visitor)expressionVisitor));
        this.whereManager.acceptVisitor((Expression.Visitor)expressionVisitor);
        this.groupByManager.acceptVisitor((Expression.Visitor)expressionVisitor);
        this.havingManager.acceptVisitor((Expression.Visitor)expressionVisitor);
        this.orderByManager.acceptVisitor((Expression.Visitor)expressionVisitor);
    }

    protected void applySizeSelectTransformer() {
        if (this.selectManager.containsSizeSelect()) {
            if (this.joinManager.hasCollections() || this.joinManager.getRoots().size() > 1) {
                this.selectManager.applySelectInfoTransformer(this.sizeSelectToSubqueryTransformer);
            } else {
                this.selectManager.applySelectInfoTransformer(this.sizeSelectToCountTransformer);
            }
        }
    }

    protected void applyExpressionTransformers() {
        for (ExpressionTransformer transformer : this.transformers) {
            this.joinManager.applyTransformer(transformer);
            this.selectManager.applyTransformer(transformer);
            this.whereManager.applyTransformer(transformer);
            this.groupByManager.applyTransformer(transformer);
            this.orderByManager.applyTransformer(transformer);
        }
        this.applySizeSelectTransformer();
        AggregateDetectionVisitor aggregateDetector = new AggregateDetectionVisitor();
        this.hasGroupBy = this.groupByManager.hasGroupBys();
        this.hasGroupBy = this.hasGroupBy || Boolean.TRUE.equals(this.selectManager.acceptVisitor(aggregateDetector, true));
        this.hasGroupBy = this.hasGroupBy || Boolean.TRUE.equals(this.joinManager.acceptVisitor(aggregateDetector, true));
        this.hasGroupBy = this.hasGroupBy || Boolean.TRUE.equals(this.whereManager.acceptVisitor(aggregateDetector));
        this.hasGroupBy = this.hasGroupBy || Boolean.TRUE.equals(this.orderByManager.acceptVisitor(aggregateDetector, true));
        this.hasGroupBy = this.hasGroupBy || Boolean.TRUE.equals(this.havingManager.acceptVisitor(aggregateDetector));
    }

    public Class<QueryResultType> getResultType() {
        return this.resultType;
    }

    public String getQueryString() {
        this.prepareAndCheck();
        return this.getCteQueryString0();
    }

    protected String getBaseQueryString() {
        this.prepareAndCheck();
        return this.getQueryString0();
    }

    protected String getCteQueryString() {
        this.prepareAndCheck();
        return this.getCteQueryString0();
    }

    protected TypedQuery<QueryResultType> getTypedQuery() {
        if (!this.isMainQuery || this.cteManager.getCtes().isEmpty()) {
            return this.getTypedQuery(this.getBaseQueryString());
        }
        TypedQuery<QueryResultType> baseQuery = this.getTypedQuery(this.getBaseQueryString());
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        String sqlQuery = this.cbf.getExtendedQuerySupport().getSql(this.em, baseQuery);
        StringBuilder sqlSb = new StringBuilder(sqlQuery);
        StringBuilder withClause = this.applyCtes(sqlSb, (Query)baseQuery, false, (List<Query>)participatingQueries);
        this.applyExtendedSql(sqlSb, false, false, withClause, null, null);
        String finalQuery = sqlSb.toString();
        participatingQueries.add((Query)baseQuery);
        CustomSQLTypedQuery<QueryResultType> query = new CustomSQLTypedQuery<QueryResultType>(participatingQueries, baseQuery, this.dbmsDialect, this.em, this.cbf.getExtendedQuerySupport(), finalQuery);
        return query;
    }

    protected Query getQuery() {
        return this.getTypedQuery();
    }

    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        return this.getQuery();
    }

    protected TypedQuery<QueryResultType> getTypedQuery(String queryString) {
        TypedQuery query = this.em.createQuery(queryString, this.selectManager.getExpectedQueryResultType());
        if (this.firstResult != 0) {
            query.setFirstResult(this.firstResult);
        }
        if (this.maxResults != Integer.MAX_VALUE) {
            query.setMaxResults(this.maxResults);
        }
        if (this.selectManager.getSelectObjectBuilder() != null) {
            query = this.transformQuery(query);
        }
        this.parameterizeQuery((Query)query);
        return query;
    }

    public KeysetBuilder<BuilderType> beforeKeyset() {
        this.clearCache();
        return this.keysetManager.startBuilder(new KeysetBuilderImpl<AbstractCommonQueryBuilder>(this, this.keysetManager, KeysetMode.PREVIOUS));
    }

    public BuilderType beforeKeyset(Serializable ... values) {
        return this.beforeKeyset(new KeysetImpl(values));
    }

    public BuilderType beforeKeyset(Keyset keyset) {
        this.clearCache();
        this.keysetManager.verifyBuilderEnded();
        this.keysetManager.setKeysetLink(new SimpleKeysetLink(keyset, KeysetMode.PREVIOUS));
        return (BuilderType)this;
    }

    public KeysetBuilder<BuilderType> afterKeyset() {
        this.clearCache();
        return this.keysetManager.startBuilder(new KeysetBuilderImpl<AbstractCommonQueryBuilder>(this, this.keysetManager, KeysetMode.NEXT));
    }

    public BuilderType afterKeyset(Serializable ... values) {
        return this.afterKeyset(new KeysetImpl(values));
    }

    public BuilderType afterKeyset(Keyset keyset) {
        this.clearCache();
        this.keysetManager.verifyBuilderEnded();
        this.keysetManager.setKeysetLink(new SimpleKeysetLink(keyset, KeysetMode.NEXT));
        return (BuilderType)this;
    }

    protected String getQueryString0() {
        if (this.cachedQueryString == null) {
            this.cachedQueryString = this.getQueryString1();
        }
        return this.cachedQueryString;
    }

    protected String getCteQueryString0() {
        if (this.cachedCteQueryString == null) {
            this.cachedCteQueryString = this.getCteQueryString1();
        }
        return this.cachedCteQueryString;
    }

    protected void clearCache() {
        this.needsCheck = true;
        this.cachedQueryString = null;
        this.cachedCteQueryString = null;
        this.implicitJoinsApplied = false;
    }

    protected void prepareAndCheck() {
        if (!this.needsCheck) {
            return;
        }
        this.verifyBuilderEnded();
        this.applyImplicitJoins();
        this.applyExpressionTransformers();
        if (this.keysetManager.hasKeyset()) {
            Metamodel m = this.em.getMetamodel();
            List<OrderByExpression> orderByExpressions = this.orderByManager.getOrderByExpressions(m);
            if (!orderByExpressions.get(orderByExpressions.size() - 1).isUnique()) {
                throw new IllegalStateException("The last order by item must be unique!");
            }
            this.keysetManager.initialize(orderByExpressions);
        }
        this.needsCheck = false;
    }

    protected String getQueryString1() {
        StringBuilder sbSelectFrom = new StringBuilder();
        this.getQueryString1(sbSelectFrom);
        return sbSelectFrom.toString();
    }

    protected void getQueryString1(StringBuilder sbSelectFrom) {
        this.appendSelectClause(sbSelectFrom);
        this.appendFromClause(sbSelectFrom);
        this.appendWhereClause(sbSelectFrom);
        this.appendGroupByClause(sbSelectFrom);
        this.appendOrderByClause(sbSelectFrom);
    }

    protected String getCteQueryString1() {
        StringBuilder sbSelectFrom = new StringBuilder();
        this.getCteQueryString1(sbSelectFrom);
        return sbSelectFrom.toString();
    }

    protected void getCteQueryString1(StringBuilder sbSelectFrom) {
        if (this.isMainQuery) {
            this.cteManager.buildClause(sbSelectFrom);
        }
        this.getQueryString1(sbSelectFrom);
    }

    protected void appendSelectClause(StringBuilder sbSelectFrom) {
        this.selectManager.buildSelect(sbSelectFrom);
    }

    protected void appendFromClause(StringBuilder sbSelectFrom) {
        this.joinManager.buildClause(sbSelectFrom, EnumSet.noneOf(ClauseType.class), null);
    }

    protected void appendWhereClause(StringBuilder sbSelectFrom) {
        KeysetLink keysetLink = this.keysetManager.getKeysetLink();
        if (keysetLink == null || keysetLink.getKeysetMode() == KeysetMode.NONE) {
            this.whereManager.buildClause(sbSelectFrom);
        } else {
            sbSelectFrom.append(" WHERE ");
            this.keysetManager.buildKeysetPredicate(sbSelectFrom);
            if (this.whereManager.hasPredicates()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom);
            }
        }
    }

    protected void appendGroupByClause(StringBuilder sbSelectFrom) {
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        this.groupByManager.buildGroupByClauses(clauses);
        if (this.hasGroupBy) {
            this.selectManager.buildGroupByClauses(this.em.getMetamodel(), clauses);
            this.havingManager.buildGroupByClauses(clauses);
            this.orderByManager.buildGroupByClauses(clauses);
        }
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.havingManager.buildClause(sbSelectFrom);
    }

    protected void appendOrderByClause(StringBuilder sbSelectFrom) {
        this.queryGenerator.setResolveSelectAliases(false);
        this.orderByManager.buildOrderBy(sbSelectFrom, false, false);
        this.queryGenerator.setResolveSelectAliases(true);
    }

    protected Map<DbmsModificationState, String> getModificationStates(Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities) {
        return null;
    }

    protected Map<String, String> getModificationStateRelatedTableNameRemappings(Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities) {
        return null;
    }

    private boolean applyAddedCtes(Query query, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, StringBuilder sb, Map<String, String> tableNameRemapping, boolean firstCte) {
        if (query instanceof CustomSQLQuery) {
            Map<String, String> cteTableNameRemappings = queryBuilder.getModificationStateRelatedTableNameRemappings(this.explicitVersionEntities);
            Map<String, String> addedCtes = ((CustomSQLQuery)query).getAddedCtes();
            if (addedCtes != null && addedCtes.size() > 0) {
                for (Map.Entry<String, String> simpleCteEntry : addedCtes.entrySet()) {
                    for (Map.Entry<String, String> cteTableNameRemapping : cteTableNameRemappings.entrySet()) {
                        if (!cteTableNameRemapping.getValue().equals(simpleCteEntry.getKey())) continue;
                        tableNameRemapping.put(cteTableNameRemapping.getKey(), cteTableNameRemapping.getValue());
                    }
                    if (firstCte) {
                        firstCte = false;
                    } else {
                        sb.append(",\n");
                    }
                    sb.append(simpleCteEntry.getKey());
                    sb.append(" AS (\n");
                    sb.append(simpleCteEntry.getValue());
                    sb.append("\n)");
                }
            }
        }
        return firstCte;
    }

    protected StringBuilder applyCtes(StringBuilder sqlSb, Query baseQuery, boolean isSubquery, List<Query> participatingQueries) {
        if (!this.isMainQuery || isSubquery || !this.cteManager.hasCtes() && this.statementType != DbmsStatementType.DELETE) {
            return null;
        }
        LinkedHashMap<String, String> tableNameRemapping = new LinkedHashMap<String, String>(0);
        StringBuilder sb = new StringBuilder(this.cteManager.getCtes().size() * 100);
        sb.append(this.dbmsDialect.getWithClause(this.cteManager.isRecursive()));
        sb.append(" ");
        boolean firstCte = true;
        for (CTEInfo cTEInfo : this.cteManager.getCtes()) {
            int i;
            Map<DbmsModificationState, String> modificationStates = cTEInfo.nonRecursiveCriteriaBuilder.getModificationStates(this.explicitVersionEntities);
            Query nonRecursiveQuery = cTEInfo.nonRecursiveCriteriaBuilder.getQuery(modificationStates);
            participatingQueries.add(nonRecursiveQuery);
            Query recursiveQuery = null;
            if (cTEInfo.recursive) {
                modificationStates = cTEInfo.nonRecursiveCriteriaBuilder.getModificationStates(this.explicitVersionEntities);
                recursiveQuery = cTEInfo.recursiveCriteriaBuilder.getQuery(modificationStates);
                participatingQueries.add(recursiveQuery);
            }
            firstCte = this.applyCascadingDelete(nonRecursiveQuery, cTEInfo.nonRecursiveCriteriaBuilder, participatingQueries, sb, cTEInfo.name, firstCte);
            firstCte = this.applyAddedCtes(nonRecursiveQuery, cTEInfo.nonRecursiveCriteriaBuilder, sb, tableNameRemapping, firstCte);
            firstCte = this.applyAddedCtes(recursiveQuery, cTEInfo.recursiveCriteriaBuilder, sb, tableNameRemapping, firstCte);
            String cteNonRecursiveSqlQuery = this.getSql(nonRecursiveQuery);
            if (firstCte) {
                firstCte = false;
            } else {
                sb.append(",\n");
            }
            sb.append(cTEInfo.name);
            sb.append('(');
            List<String> attributes = cTEInfo.attributes;
            boolean first = true;
            for (i = 0; i < attributes.size(); ++i) {
                String[] columns;
                for (String column : columns = this.cbf.getExtendedQuerySupport().getColumnNames(this.em, cTEInfo.cteType, attributes.get(i))) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(column);
                }
            }
            sb.append(')');
            sb.append(" AS(\n");
            sb.append(cteNonRecursiveSqlQuery);
            if (cTEInfo.recursive) {
                String cteRecursiveSqlQuery = this.getSql(recursiveQuery);
                if (cTEInfo.unionAll) {
                    sb.append("\nUNION ALL\n");
                } else {
                    sb.append("\nUNION\n");
                }
                sb.append(cteRecursiveSqlQuery);
            } else if (!this.dbmsDialect.supportsNonRecursiveWithClause()) {
                sb.append("\nUNION ALL\n");
                sb.append("SELECT ");
                sb.append("NULL");
                for (i = 1; i < attributes.size(); ++i) {
                    sb.append(", ");
                    sb.append("NULL");
                }
                sb.append(" FROM DUAL WHERE 1=0");
            }
            sb.append("\n)");
            String subselect = "( select * from " + cTEInfo.name + " )";
            int subselectIndex = 0;
            while ((subselectIndex = sb.indexOf(subselect, subselectIndex)) > -1) {
                sb.replace(subselectIndex, subselectIndex + subselect.length(), cTEInfo.name);
            }
            subselectIndex = 0;
            while ((subselectIndex = sqlSb.indexOf(subselect, subselectIndex)) > -1) {
                sqlSb.replace(subselectIndex, subselectIndex + subselect.length(), cTEInfo.name);
            }
        }
        if (firstCte = this.applyCascadingDelete(baseQuery, this, participatingQueries, sb, "main_query", firstCte)) {
            return null;
        }
        sb.append("\n");
        for (Map.Entry entry : tableNameRemapping.entrySet()) {
            String sqlAlias = this.cbf.getExtendedQuerySupport().getSqlAlias(this.em, baseQuery, (String)entry.getKey());
            String newCteName = (String)entry.getValue();
            this.applyTableNameRemapping(sqlSb, sqlAlias, newCteName);
        }
        return sb;
    }

    private boolean applyCascadingDelete(Query baseQuery, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, List<Query> participatingQueries, StringBuilder sb, String cteBaseName, boolean firstCte) {
        if (queryBuilder.statementType == DbmsStatementType.DELETE) {
            List cascadingDeleteSqls = this.cbf.getExtendedQuerySupport().getCascadingDeleteSql(this.em, baseQuery);
            StringBuilder cascadingDeleteSqlSb = new StringBuilder();
            int cteBaseNameCount = 0;
            for (String cascadingDeleteSql : cascadingDeleteSqls) {
                if (firstCte) {
                    firstCte = false;
                } else {
                    sb.append(",\n");
                }
                participatingQueries.add(baseQuery);
                int currentSize = sb.length();
                sb.append(cteBaseName);
                sb.append('_').append(cteBaseNameCount);
                sb.append(" AS (\n");
                cascadingDeleteSqlSb.setLength(0);
                cascadingDeleteSqlSb.append(cascadingDeleteSql);
                this.dbmsDialect.appendExtendedSql(cascadingDeleteSqlSb, DbmsStatementType.DELETE, false, true, null, null, null, null, null);
                sb.append((CharSequence)cascadingDeleteSqlSb);
                sb.append("\n)");
                for (CTEInfo cteInfo : this.cteManager.getCtes()) {
                    String subselect = "( select * from " + cteInfo.name + " )";
                    int subselectIndex = currentSize;
                    while ((subselectIndex = sb.indexOf(subselect, subselectIndex)) > -1) {
                        sb.replace(subselectIndex, subselectIndex + subselect.length(), cteInfo.name);
                    }
                }
            }
        }
        return firstCte;
    }

    private void applyTableNameRemapping(StringBuilder sb, String sqlAlias, String newCteName) {
        String searchAs = " as";
        String searchAlias = " " + sqlAlias;
        int searchIndex = 0;
        while ((searchIndex = sb.indexOf(searchAlias, searchIndex)) > -1) {
            char c = sb.charAt(searchIndex + searchAlias.length());
            if (c != '.') {
                int[] indexRange = " as".equalsIgnoreCase(sb.substring(searchIndex - " as".length(), searchIndex)) ? this.rtrimBackwardsToFirstWhitespace(sb, searchIndex - " as".length()) : this.rtrimBackwardsToFirstWhitespace(sb, searchIndex);
                int oldLength = indexRange[1] - indexRange[0];
                sb.replace(indexRange[0], indexRange[1], newCteName);
                searchIndex += newCteName.length() - oldLength;
            }
            ++searchIndex;
        }
    }

    private int[] rtrimBackwardsToFirstWhitespace(StringBuilder sb, int startIndex) {
        int tableNameStartIndex;
        int tableNameEndIndex = startIndex;
        boolean text = false;
        for (tableNameStartIndex = tableNameEndIndex; tableNameStartIndex >= 0; --tableNameStartIndex) {
            if (text) {
                char c = sb.charAt(tableNameStartIndex);
                if (!Character.isWhitespace(c) && c != ',') continue;
                break;
            }
            if (Character.isWhitespace(sb.charAt(tableNameStartIndex))) {
                --tableNameEndIndex;
                continue;
            }
            text = true;
            ++tableNameEndIndex;
        }
        return new int[]{++tableNameStartIndex, tableNameEndIndex};
    }

    private String getSql(Query query) {
        if (query instanceof CustomSQLQuery) {
            return ((CustomSQLQuery)query).getSql();
        }
        if (query instanceof CustomSQLTypedQuery) {
            return ((CustomSQLTypedQuery)query).getSql();
        }
        return this.cbf.getExtendedQuerySupport().getSql(this.em, query);
    }

    protected boolean hasLimit() {
        return this.firstResult != 0 || this.maxResults != Integer.MAX_VALUE;
    }

    protected Map<String, String> applyExtendedSql(StringBuilder sqlSb, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        String limit = null;
        String offset = null;
        if (this.firstResult != 0) {
            offset = Integer.toString(this.firstResult);
        }
        if (this.maxResults != Integer.MAX_VALUE) {
            limit = Integer.toString(this.maxResults);
        }
        return this.dbmsDialect.appendExtendedSql(sqlSb, this.statementType, isSubquery, isEmbedded, withClause, limit, offset, returningColumns, includedModificationStates);
    }

    protected void applyJpaLimit(StringBuilder sbSelectFrom) {
        if (this.hasLimit()) {
            sbSelectFrom.append(" LIMIT ");
            sbSelectFrom.append(this.maxResults);
            if (this.firstResult > 0) {
                sbSelectFrom.append(" OFFSET ");
                sbSelectFrom.append(this.firstResult);
            }
        }
    }

    protected <Y> TypedQuery<Y> transformQuery(TypedQuery<Y> query) {
        TypedQuery currentQuery = query;
        for (QueryTransformer transformer : this.cbf.getQueryTransformers()) {
            currentQuery = transformer.transformQuery(query, this.selectManager.getSelectObjectBuilder());
        }
        return currentQuery;
    }
}

