/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.impl.AbstractQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.PaginatedCriteriaBuilderImpl;
import java.lang.reflect.Constructor;
import javax.persistence.metamodel.EntityType;

public abstract class AbstractFullQueryBuilder<T, X extends FullQueryBuilder<T, X>, Z, W, FinalSetReturn extends BaseFinalSetOperationBuilderImpl<T, ?, ?>>
extends AbstractQueryBuilder<T, X, Z, W, FinalSetReturn>
implements FullQueryBuilder<T, X> {
    private boolean createdPaginatedBuilder = false;

    protected AbstractFullQueryBuilder(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> builder) {
        super(builder);
    }

    public AbstractFullQueryBuilder(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, String alias, FinalSetReturn finalSetOperationBuilder) {
        super(mainQuery, isMainQuery, clazz, alias, finalSetOperationBuilder);
    }

    public PaginatedCriteriaBuilder<T> page(int firstRow, int pageSize) {
        this.clearCache();
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a GROUP BY query");
        }
        this.createdPaginatedBuilder = true;
        return new PaginatedCriteriaBuilderImpl(this, false, null, firstRow, pageSize);
    }

    public PaginatedCriteriaBuilder<T> page(Object entityId, int pageSize) {
        this.clearCache();
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a GROUP BY query");
        }
        this.checkEntityId(entityId);
        this.createdPaginatedBuilder = true;
        return new PaginatedCriteriaBuilderImpl(this, false, null, entityId, pageSize);
    }

    public PaginatedCriteriaBuilder<T> page(KeysetPage keysetPage, int firstRow, int pageSize) {
        this.clearCache();
        if (this.selectManager.isDistinct()) {
            throw new IllegalStateException("Cannot paginate a DISTINCT query");
        }
        if (!this.groupByManager.isEmpty()) {
            throw new IllegalStateException("Cannot paginate a GROUP BY query");
        }
        this.createdPaginatedBuilder = true;
        return new PaginatedCriteriaBuilderImpl(this, true, keysetPage, firstRow, pageSize);
    }

    private void checkEntityId(Object entityId) {
        if (entityId == null) {
            throw new IllegalArgumentException("Invalid null entity id given");
        }
        EntityType entityType = this.em.getMetamodel().entity(this.joinManager.getRootNodeOrFail("Paginated queries do not support multiple from clause elements!").getPropertyClass());
        Class idType = entityType.getIdType().getJavaType();
        if (!idType.isInstance(entityId)) {
            throw new IllegalArgumentException("The type of the given entity id '" + entityId.getClass().getName() + "' is not an instance of the expected id type '" + idType.getName() + "' of the entity class '" + entityType.getJavaType().getName() + "'");
        }
    }

    public <Y> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(Class<Y> clazz) {
        this.clearCache();
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectNew(this, clazz);
    }

    public <Y> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(Constructor<Y> constructor) {
        this.clearCache();
        if (constructor == null) {
            throw new NullPointerException("constructor");
        }
        this.verifyBuilderEnded();
        return this.selectManager.selectNew(this, constructor);
    }

    public <Y> FullQueryBuilder<Y, ?> selectNew(ObjectBuilder<Y> objectBuilder) {
        this.clearCache();
        if (objectBuilder == null) {
            throw new NullPointerException("objectBuilder");
        }
        this.verifyBuilderEnded();
        this.selectManager.selectNew(this, objectBuilder);
        return this;
    }

    private void checkFetchJoinAllowed() {
        if (this.selectManager.getSelectInfos().size() > 0) {
            throw new IllegalStateException("Fetch joins are only possible if the root entity is selected");
        }
    }

    public X fetch(String path) {
        this.clearCache();
        this.checkFetchJoinAllowed();
        this.verifyBuilderEnded();
        this.joinManager.implicitJoin(this.expressionFactory.createSimpleExpression(path), true, null, false, false, true, true);
        return (X)this;
    }

    public X fetch(String ... paths) {
        this.clearCache();
        this.checkFetchJoinAllowed();
        this.verifyBuilderEnded();
        for (String path : paths) {
            this.joinManager.implicitJoin(this.expressionFactory.createSimpleExpression(path), true, null, false, false, true, true);
        }
        return (X)this;
    }

    public X innerJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.INNER, true);
    }

    public X innerJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.INNER, true);
    }

    public X leftJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.LEFT, true);
    }

    public X leftJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.LEFT, true);
    }

    public X rightJoinFetch(String path, String alias) {
        return this.join(path, alias, JoinType.RIGHT, true);
    }

    public X rightJoinFetchDefault(String path, String alias) {
        return this.joinDefault(path, alias, JoinType.RIGHT, true);
    }

    public X join(String path, String alias, JoinType type, boolean fetch) {
        return this.join(path, alias, type, fetch, false);
    }

    public X joinDefault(String path, String alias, JoinType type, boolean fetch) {
        return this.join(path, alias, type, fetch, true);
    }

    private X join(String path, String alias, JoinType type, boolean fetch, boolean defaultJoin) {
        this.clearCache();
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (alias.isEmpty()) {
            throw new IllegalArgumentException("Empty alias");
        }
        if (fetch) {
            this.checkFetchJoinAllowed();
        }
        this.verifyBuilderEnded();
        this.joinManager.join(path, alias, type, fetch, defaultJoin);
        return (X)this;
    }

    @Override
    public X groupBy(String expression) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.groupBy(expression));
    }

    @Override
    public X groupBy(String ... paths) {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.groupBy(paths));
    }

    @Override
    public X distinct() {
        if (this.createdPaginatedBuilder) {
            throw new IllegalStateException("Calling distinct() on a PaginatedCriteriaBuilder is not allowed.");
        }
        return (X)((FullQueryBuilder)super.distinct());
    }
}

