/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseModificationCriteriaBuilder;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.ReturningBuilder;
import com.blazebit.persistence.ReturningModificationCriteriaBuilderFactory;
import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.ReturningResult;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.CTEInfoBuilder;
import com.blazebit.persistence.impl.CustomSQLQuery;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.builder.object.ReturningTupleObjectBuilder;
import com.blazebit.persistence.impl.dialect.DB2DbmsDialect;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;

public abstract class AbstractModificationCriteriaBuilder<T, X extends BaseModificationCriteriaBuilder<X>, Y>
extends AbstractCommonQueryBuilder<T, X, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, BaseFinalSetOperationBuilderImpl<T, ?, ?>>
implements BaseModificationCriteriaBuilder<X>,
CTEInfoBuilder {
    protected final EntityType<T> entityType;
    protected final String entityAlias;
    protected final EntityType<?> cteType;
    protected final String cteName;
    protected final Y result;
    protected final CTEBuilderListener listener;
    protected final boolean isReturningEntityAliasAllowed;
    protected final Map<String, String> returningAttributeBindingMap;

    public AbstractModificationCriteriaBuilder(MainQuery mainQuery, boolean isMainQuery, DbmsStatementType statementType, Class<T> clazz, String alias, Class<?> cteClass, Y result, CTEBuilderListener listener) {
        super(mainQuery, isMainQuery, statementType, Tuple.class, null);
        if (alias == null) {
            alias = clazz.getSimpleName().toLowerCase();
        } else {
            this.fromClassExplicitelySet = true;
        }
        this.entityType = this.em.getMetamodel().entity(clazz);
        this.entityAlias = this.joinManager.addRoot(this.entityType, alias);
        this.result = result;
        this.listener = listener;
        if (cteClass == null) {
            this.cteType = null;
            this.cteName = null;
            this.isReturningEntityAliasAllowed = false;
            this.returningAttributeBindingMap = new LinkedHashMap<String, String>(0);
        } else {
            this.cteType = this.em.getMetamodel().entity(cteClass);
            this.cteName = this.cteType.getName();
            this.isReturningEntityAliasAllowed = true;
            this.returningAttributeBindingMap = new LinkedHashMap<String, String>(this.cteType.getAttributes().size());
        }
    }

    @Override
    public FullSelectCTECriteriaBuilder<X> with(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClauseInModificationQuery()) {
            throw new UnsupportedOperationException("The database does not support a with clause in modification queries!");
        }
        return super.with(cteClass);
    }

    @Override
    public SelectRecursiveCTECriteriaBuilder<X> withRecursive(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClauseInModificationQuery()) {
            throw new UnsupportedOperationException("The database does not support a with clause in modification queries!");
        }
        return super.withRecursive(cteClass);
    }

    @Override
    public ReturningModificationCriteriaBuilderFactory<X> withReturning(Class<?> cteClass) {
        if (!this.dbmsDialect.supportsWithClauseInModificationQuery()) {
            throw new UnsupportedOperationException("The database does not support a with clause in modification queries!");
        }
        return super.withReturning(cteClass);
    }

    protected void applyJpaReturning(StringBuilder sbSelectFrom) {
        sbSelectFrom.append(" RETURNING ");
        boolean first = true;
        for (String attribute : this.returningAttributeBindingMap.values()) {
            if (first) {
                first = false;
            } else {
                sbSelectFrom.append(", ");
            }
            sbSelectFrom.append(attribute);
        }
    }

    @Override
    public Query getQuery() {
        return this.getQuery(null);
    }

    @Override
    protected Query getQuery(Map<DbmsModificationState, String> includedModificationStates) {
        Query query;
        if (this.hasLimit() || this.cteManager.hasCtes() || this.returningAttributeBindingMap.size() > 0) {
            ArrayList<Query> participatingQueries = new ArrayList<Query>();
            query = this.em.createQuery(this.getBaseQueryString());
            StringBuilder sqlSb = new StringBuilder(this.cbf.getExtendedQuerySupport().getSql(this.em, query));
            boolean isEmbedded = this instanceof ReturningBuilder;
            StringBuilder withClause = this.applyCtes(sqlSb, query, isEmbedded, participatingQueries);
            String[] returningColumns = this.getReturningColumns();
            Map<String, String> addedCtes = this.applyExtendedSql(sqlSb, false, isEmbedded, withClause, returningColumns, includedModificationStates);
            String finalSql = sqlSb.toString();
            participatingQueries.add(query);
            if (this.cteManager.hasCtes() && this.returningAttributeBindingMap.isEmpty() && !this.dbmsDialect.usesExecuteUpdateWhenWithClauseInModificationQuery()) {
                query = this.getCountExampleQuery();
            }
            query = new CustomSQLQuery(participatingQueries, query, this.dbmsDialect, this.em, this.cbf.getExtendedQuerySupport(), finalSql, addedCtes);
        } else {
            query = this.em.createQuery(this.getBaseQueryString());
        }
        this.parameterizeQuery(query);
        return query;
    }

    protected Query getBaseQuery() {
        Query query = this.em.createQuery(this.getBaseQueryString());
        this.parameterizeQuery(query);
        return query;
    }

    public int executeUpdate() {
        return this.getQuery().executeUpdate();
    }

    @Override
    protected Map<DbmsModificationState, String> getModificationStates(Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities) {
        boolean defaultOld;
        Map<String, DbmsModificationState> versionEntities = explicitVersionEntities.get(this.entityType.getJavaType());
        if (versionEntities == null) {
            return null;
        }
        HashMap<DbmsModificationState, String> includedModificationStates = new HashMap<DbmsModificationState, String>();
        boolean bl = defaultOld = !(this.dbmsDialect instanceof DB2DbmsDialect);
        if (defaultOld) {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.NEW) continue;
                includedModificationStates.put(DbmsModificationState.NEW, "new_" + this.entityType.getName());
                break;
            }
        } else {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.OLD) continue;
                includedModificationStates.put(DbmsModificationState.OLD, "old_" + this.entityType.getName());
                break;
            }
        }
        return includedModificationStates;
    }

    @Override
    protected Map<String, String> getModificationStateRelatedTableNameRemappings(Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities) {
        boolean defaultOld;
        Map<String, DbmsModificationState> versionEntities = explicitVersionEntities.get(this.entityType.getJavaType());
        if (versionEntities == null) {
            return null;
        }
        HashMap<String, String> tableNameRemappings = new HashMap<String, String>();
        boolean bl = defaultOld = !(this.dbmsDialect instanceof DB2DbmsDialect);
        if (defaultOld) {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.NEW) continue;
                tableNameRemappings.put(entry.getKey(), "new_" + this.entityType.getName());
            }
        } else {
            for (Map.Entry<String, DbmsModificationState> entry : versionEntities.entrySet()) {
                if (entry.getValue() != DbmsModificationState.OLD) continue;
                tableNameRemappings.put(entry.getKey(), "old_" + this.entityType.getName());
            }
        }
        return tableNameRemappings;
    }

    public ReturningResult<Tuple> executeWithReturning(String ... attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        if (attributes.length == 0) {
            throw new IllegalArgumentException("Invalid empty attributes");
        }
        List<Attribute<?, ?>> attributeList = this.getAndCheckAttributes(attributes);
        Query exampleQuery = this.getExampleQuery(attributeList);
        Query baseQuery = this.getBaseQuery();
        String[] returningColumns = this.getReturningColumns(attributeList);
        ReturningResult<Object[]> result = this.executeWithReturning(exampleQuery, baseQuery, returningColumns);
        List originalResultList = result.getResultList();
        int updateCount = result.getUpdateCount();
        return new DefaultReturningResult<Tuple>(originalResultList, updateCount, this.dbmsDialect, new ReturningTupleObjectBuilder());
    }

    public <Z> ReturningResult<Z> executeWithReturning(String attribute, Class<Z> type) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (attribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty attribute");
        }
        Attribute<T, ?> attr = JpaUtils.getAttribute(this.entityType, attribute);
        if (!type.isAssignableFrom(attr.getJavaType())) {
            throw new IllegalArgumentException("The given expected field type is not of the expected type: " + attr.getJavaType().getName());
        }
        ArrayList attributes = new ArrayList();
        attributes.add(attr);
        Query exampleQuery = this.getExampleQuery(attributes);
        Query baseQuery = this.getBaseQuery();
        String[] returningColumns = this.getReturningColumns(attributes);
        ReturningResult<Object[]> result = this.executeWithReturning(exampleQuery, baseQuery, returningColumns);
        List originalResultList = result.getResultList();
        int updateCount = result.getUpdateCount();
        return new DefaultReturningResult(originalResultList, updateCount, this.dbmsDialect);
    }

    public <Z> ReturningResult<Z> executeWithReturning(ReturningObjectBuilder<Z> objectBuilder) {
        objectBuilder.applyReturning((ReturningBuilder)this);
        List<Attribute<?, ?>> attributes = this.getAndCheckReturningAttributes();
        this.returningAttributeBindingMap.clear();
        Query exampleQuery = this.getExampleQuery(attributes);
        Query baseQuery = this.getBaseQuery();
        String[] returningColumns = this.getReturningColumns(attributes);
        ReturningResult<Object[]> result = this.executeWithReturning(exampleQuery, baseQuery, returningColumns);
        List originalResultList = result.getResultList();
        int updateCount = result.getUpdateCount();
        return new DefaultReturningResult<Z>(originalResultList, updateCount, this.dbmsDialect, objectBuilder);
    }

    private ReturningResult<Object[]> executeWithReturning(Query exampleQuery, Query baseQuery, String[] returningColumns) {
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        StringBuilder sqlSb = new StringBuilder(this.cbf.getExtendedQuerySupport().getSql(this.em, baseQuery));
        StringBuilder withClause = this.applyCtes(sqlSb, baseQuery, false, participatingQueries);
        this.applyExtendedSql(sqlSb, false, false, withClause, returningColumns, null);
        String finalSql = sqlSb.toString();
        participatingQueries.add(baseQuery);
        ReturningResult result = this.cbf.getExtendedQuerySupport().executeReturning(this.dbmsDialect, this.em, participatingQueries, exampleQuery, finalSql);
        return result;
    }

    private List<Attribute<?, ?>> getAndCheckReturningAttributes() {
        this.validateReturningAttributes();
        return this.getAndCheckAttributes(this.returningAttributeBindingMap.keySet().toArray(new String[this.returningAttributeBindingMap.size()]));
    }

    private void validateReturningAttributes() {
        Set availableAttributes;
        int attributeCount = this.returningAttributeBindingMap.size();
        if (attributeCount == 0) {
            throw new IllegalArgumentException("Invalid empty attributes");
        }
        if (this.cteType == null || (availableAttributes = this.cteType.getAttributes()).size() == this.returningAttributeBindingMap.size()) {
            return;
        }
        TreeSet<String> attributeNames = new TreeSet<String>();
        for (Attribute attr : availableAttributes) {
            String attributeName = attr.getName();
            if (this.returningAttributeBindingMap.containsKey(attributeName)) continue;
            attributeNames.add(attributeName);
        }
        throw new IllegalArgumentException("The following required CTE attributes are not bound: " + attributeNames);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public X returning(String cteAttribute, String modificationQueryAttribute) {
        Class queryAttrType;
        if (cteAttribute == null) {
            throw new NullPointerException("cteAttribute");
        }
        if (modificationQueryAttribute == null) {
            throw new NullPointerException("modificationQueryAttribute");
        }
        if (cteAttribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty cteAttribute");
        }
        if (modificationQueryAttribute.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty modificationQueryAttribute");
        }
        Attribute<?, ?> cteAttr = JpaUtils.getAttribute(this.cteType, cteAttribute);
        if (cteAttr == null) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] does not exist!");
        }
        Attribute<T, ?> queryAttr = JpaUtils.getAttribute(this.entityType, modificationQueryAttribute);
        if (queryAttr == null) {
            if (!this.isReturningEntityAliasAllowed || !modificationQueryAttribute.equals(this.entityAlias)) throw new IllegalArgumentException("The query attribute [" + modificationQueryAttribute + "] does not exist!");
            queryAttrType = this.entityType.getJavaType();
            Attribute<?, ?> idAttribute = JpaUtils.getIdAttribute(this.entityType);
            modificationQueryAttribute = idAttribute.getName();
        } else {
            queryAttrType = queryAttr.getJavaType();
        }
        if (!cteAttr.getJavaType().isAssignableFrom(queryAttrType)) {
            throw new IllegalArgumentException("The given cte attribute '" + cteAttribute + "' with the type '" + cteAttr.getJavaType().getName() + "'" + " can not be assigned with a value of the type '" + queryAttr.getJavaType().getName() + "' of the query attribute '" + modificationQueryAttribute + "'!");
        }
        String bindingEntry = this.returningAttributeBindingMap.get(cteAttribute);
        if (bindingEntry != null) {
            throw new IllegalArgumentException("The cte attribute [" + cteAttribute + "] has already been bound!");
        }
        this.returningAttributeBindingMap.put(cteAttribute, modificationQueryAttribute);
        return (X)this;
    }

    public Y end() {
        this.validateReturningAttributes();
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public CTEInfo createCTEInfo() {
        List<String> attributes = this.prepareAndGetAttributes();
        CTEInfo info = new CTEInfo(this.cteName, this.cteType, attributes, false, false, this, null);
        return info;
    }

    private List<Attribute<?, ?>> getAndCheckAttributes(String[] attributes) {
        ArrayList attrs = new ArrayList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i] == null) {
                throw new NullPointerException("attribute at position " + i);
            }
            if (attributes[i].isEmpty()) {
                throw new IllegalArgumentException("empty attribute at position " + i);
            }
            Attribute<T, ?> attribute = JpaUtils.getAttribute(this.entityType, attributes[i]);
            if (attribute == null) {
                throw new IllegalArgumentException("The query attribute [" + attributes[i] + "] does not exist!");
            }
            attrs.add(attribute);
        }
        return attrs;
    }

    private String[] getReturningColumns(List<Attribute<?, ?>> attributes) {
        ArrayList<String> columns = new ArrayList<String>(attributes.size());
        for (Attribute<?, ?> returningAttribute : attributes) {
            for (String column : this.cbf.getExtendedQuerySupport().getColumnNames(this.em, this.entityType, returningAttribute.getName())) {
                columns.add(column);
            }
        }
        return columns.toArray(new String[columns.size()]);
    }

    private String[] getReturningColumns() {
        if (this.returningAttributeBindingMap.isEmpty()) {
            return null;
        }
        Collection<String> returningAttributeNames = this.returningAttributeBindingMap.values();
        ArrayList<String> columns = new ArrayList<String>(returningAttributeNames.size());
        for (String returningAttributeName : this.returningAttributeBindingMap.values()) {
            for (String column : this.cbf.getExtendedQuerySupport().getColumnNames(this.em, this.entityType, returningAttributeName)) {
                columns.add(column);
            }
        }
        return columns.toArray(new String[columns.size()]);
    }

    private Query getCountExampleQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(e) FROM ");
        sb.append(this.entityType.getName());
        sb.append(" e");
        String exampleQueryString = sb.toString();
        return this.em.createQuery(exampleQueryString);
    }

    private Query getExampleQuery(List<Attribute<?, ?>> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        boolean first = true;
        for (Attribute<?, ?> attribute : attributes) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (!this.dbmsDialect.supportsReturningColumns() && !JpaUtils.getIdAttribute(this.entityType).equals(attribute)) {
                throw new IllegalArgumentException("Returning the query attribute [" + attribute.getName() + "] is not supported by the dbms, only generated keys can be returned!");
            }
            if (JpaUtils.isJoinable(attribute)) {
                EntityType type = this.em.getMetamodel().entity(JpaUtils.resolveFieldClass(this.entityType.getJavaType(), attribute));
                Attribute<?, ?> idAttribute = JpaUtils.getIdAttribute(type);
                sb.append(attribute.getName()).append('.').append(idAttribute.getName());
                continue;
            }
            sb.append(attribute.getName());
        }
        sb.append(" FROM ");
        sb.append(this.entityType.getName());
        String exampleQueryString = sb.toString();
        return this.em.createQuery(exampleQueryString);
    }

    protected List<String> prepareAndGetAttributes() {
        return new ArrayList<String>(this.returningAttributeBindingMap.keySet());
    }

    protected static class DefaultReturningResult<Z>
    implements ReturningResult<Z> {
        private final List<Z> resultList;
        private final int updateCount;
        private final DbmsDialect dbmsDialect;

        public DefaultReturningResult(List<Z> resultList, int updateCount, DbmsDialect dbmsDialect) {
            this.resultList = resultList;
            this.updateCount = updateCount;
            this.dbmsDialect = dbmsDialect;
        }

        public DefaultReturningResult(List<Object[]> originalResultList, int updateCount, DbmsDialect dbmsDialect, ReturningObjectBuilder<Z> objectBuilder) {
            this.updateCount = updateCount;
            this.dbmsDialect = dbmsDialect;
            ArrayList<Object> resultList = new ArrayList<Object>(originalResultList.size());
            for (Object[] element : originalResultList) {
                resultList.add(objectBuilder.build(element));
            }
            this.resultList = objectBuilder.buildList(resultList);
        }

        public Z getLastResult() {
            return this.resultList.get(this.resultList.size() - 1);
        }

        public List<Z> getResultList() {
            if (this.dbmsDialect.supportsReturningAllGeneratedKeys()) {
                return this.resultList;
            }
            throw new UnsupportedOperationException("The database does not support returning all generated keys!");
        }

        public int getUpdateCount() {
            return this.updateCount;
        }
    }
}

