/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.SelectInfo;
import java.util.HashMap;
import java.util.Map;

public class AliasManager {
    private final AliasManager parent;
    private final Map<String, AliasInfo> aliasMap = new HashMap<String, AliasInfo>();
    private final Map<String, Integer> aliasCounterMap = new HashMap<String, Integer>();

    public AliasManager() {
        this.parent = null;
    }

    public AliasManager(AliasManager parent) {
        this.parent = parent;
    }

    public AliasInfo getAliasInfo(String alias) {
        return this.getHierarchical(alias);
    }

    public AliasInfo getAliasInfoForBottomLevel(String alias) {
        return this.aliasMap.get(alias);
    }

    public String registerAliasInfo(AliasInfo aliasInfo) {
        String alias = aliasInfo.getAlias();
        if (this.getHierarchical(alias) != null) {
            throw new IllegalArgumentException("Alias '" + alias + "' already exsits");
        }
        this.aliasMap.put(alias, aliasInfo);
        this.aliasCounterMap.put(alias, 0);
        return alias;
    }

    public String generatePostfixedAlias(String alias) {
        String nonPostfixed = alias;
        Integer counter = this.getCounterHierarchical(alias);
        if (counter != null) {
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        } else {
            counter = 1;
        }
        alias = alias + "_" + counter;
        this.aliasCounterMap.put(nonPostfixed, counter);
        return alias;
    }

    private AliasInfo getHierarchical(String alias) {
        AliasInfo info = null;
        if (this.parent != null) {
            info = this.parent.getHierarchical(alias);
        }
        if (info == null) {
            info = this.aliasMap.get(alias);
        }
        return info;
    }

    private Integer getCounterHierarchical(String alias) {
        Integer counter = null;
        if (this.parent != null) {
            counter = this.parent.getCounterHierarchical(alias);
        }
        if (counter == null) {
            counter = this.aliasCounterMap.get(alias);
        }
        return counter;
    }

    public void unregisterAliasInfoForBottomLevel(AliasInfo aliasInfo) {
        String alias = aliasInfo.getAlias();
        this.aliasMap.remove(alias);
        int counter = this.aliasCounterMap.get(alias);
        if (alias.endsWith("_" + counter)) {
            if (counter == 1) {
                this.aliasCounterMap.remove(alias);
            } else {
                this.aliasCounterMap.put(alias, counter - 1);
            }
        }
    }

    public Map<String, AliasInfo> getAliasMapForBottomLevel() {
        return this.aliasMap;
    }

    public boolean isSelectAlias(String alias) {
        AliasInfo info = this.aliasMap.get(alias);
        if (info != null) {
            return info instanceof SelectInfo;
        }
        return false;
    }
}

