/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.BaseOngoingFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.CustomSQLQuery;
import com.blazebit.persistence.impl.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.DefaultOrderByElement;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class BaseFinalSetOperationBuilderImpl<T, X extends BaseFinalSetOperationBuilder<T, X>, Y extends BaseFinalSetOperationBuilderImpl<T, X, Y>>
extends AbstractCommonQueryBuilder<T, X, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, AbstractCommonQueryBuilder<?, ?, ?, ?, ?>, Y>
implements BaseFinalSetOperationBuilder<T, X>,
BaseOngoingFinalSetOperationBuilder<T, X> {
    protected T endSetResult;
    protected final SetOperationManager setOperationManager;
    protected final List<DefaultOrderByElement> orderByElements;

    public BaseFinalSetOperationBuilderImpl(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, SetOperationType operator, boolean nested, T endSetResult) {
        super(mainQuery, isMainQuery, DbmsStatementType.SELECT, clazz, null);
        this.endSetResult = endSetResult;
        this.setOperationManager = new SetOperationManager(operator, nested);
        this.orderByElements = new ArrayList<DefaultOrderByElement>(0);
    }

    private static boolean isNested(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            return ((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager.isNested();
        }
        return false;
    }

    @Override
    public X orderBy(String expression, boolean ascending, boolean nullFirst) {
        this.prepareAndCheck();
        AbstractCommonQueryBuilder<?, ?, ?, ?, ?> leftMostQuery = this.getLeftMost(this.setOperationManager.getStartQueryBuilder());
        AliasInfo aliasInfo = leftMostQuery.aliasManager.getAliasInfo(expression);
        if (aliasInfo != null) {
            int position = this.cbf.getExtendedQuerySupport().getSqlSelectAliasPosition(this.em, leftMostQuery.getTypedQuery(), expression);
            this.orderByElements.add(new DefaultOrderByElement(expression, position, ascending, nullFirst));
            return (X)this;
        }
        int position = this.cbf.getExtendedQuerySupport().getSqlSelectAttributePosition(this.em, leftMostQuery.getTypedQuery(), expression);
        this.orderByElements.add(new DefaultOrderByElement(expression, position, ascending, nullFirst));
        return (X)this;
    }

    private AbstractCommonQueryBuilder<?, ?, ?, ?, ?> getLeftMost(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            return this.getLeftMost(((BaseFinalSetOperationBuilderImpl)queryBuilder).setOperationManager.getStartQueryBuilder());
        }
        return queryBuilder;
    }

    protected List<? extends OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public T getEndSetResult() {
        return this.endSetResult;
    }

    public void setEndSetResult(T endSetResult) {
        this.endSetResult = endSetResult;
    }

    public T endSet() {
        return this.endSetResult;
    }

    @Override
    protected void prepareAndCheck() {
    }

    @Override
    protected void getQueryString1(StringBuilder sbSelectFrom) {
        boolean nested = BaseFinalSetOperationBuilderImpl.isNested(this.setOperationManager.getStartQueryBuilder());
        if (nested) {
            sbSelectFrom.append('(');
        }
        this.setOperationManager.getStartQueryBuilder().getQueryString1(sbSelectFrom);
        if (nested) {
            sbSelectFrom.append(')');
        }
        if (this.setOperationManager.hasSetOperations()) {
            String operator = this.getOperator(this.setOperationManager.getOperator());
            for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
                sbSelectFrom.append("\n");
                sbSelectFrom.append(operator);
                sbSelectFrom.append("\n");
                nested = BaseFinalSetOperationBuilderImpl.isNested(setOperand);
                if (nested) {
                    sbSelectFrom.append('(');
                }
                setOperand.getQueryString1(sbSelectFrom);
                if (!nested) continue;
                sbSelectFrom.append(')');
            }
            this.applySetOrderBy(sbSelectFrom);
            this.applyJpaLimit(sbSelectFrom);
        }
    }

    protected void applySetOrderBy(StringBuilder sbSelectFrom) {
        if (this.orderByElements.isEmpty()) {
            return;
        }
        sbSelectFrom.append("\nORDER BY ");
        for (int i = 0; i < this.orderByElements.size(); ++i) {
            if (i != 0) {
                sbSelectFrom.append(", ");
            }
            DefaultOrderByElement elem = this.orderByElements.get(i);
            sbSelectFrom.append(elem.getName());
            if (elem.isAscending()) {
                sbSelectFrom.append(" ASC");
            } else {
                sbSelectFrom.append(" DESC");
            }
            if (elem.isNullsFirst()) {
                sbSelectFrom.append(" NULLS FIRST");
                continue;
            }
            sbSelectFrom.append(" NULLS LAST");
        }
    }

    @Override
    protected TypedQuery<T> getTypedQuery() {
        String sqlQuery;
        TypedQuery baseQuery;
        List<Query> customQueryParticipants;
        Object customQuery;
        TypedQuery leftMostQuery = this.setOperationManager.getStartQueryBuilder().getTypedQuery();
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        if (leftMostQuery instanceof CustomSQLQuery) {
            customQuery = (CustomSQLQuery)leftMostQuery;
            customQueryParticipants = ((CustomSQLQuery)customQuery).getParticipatingQueries();
            participatingQueries.addAll(customQueryParticipants);
            baseQuery = (TypedQuery)customQueryParticipants.get(0);
            sqlQuery = ((CustomSQLQuery)customQuery).getSql();
        } else if (leftMostQuery instanceof CustomSQLTypedQuery) {
            customQuery = (CustomSQLTypedQuery)leftMostQuery;
            customQueryParticipants = ((CustomSQLTypedQuery)customQuery).getParticipatingQueries();
            participatingQueries.addAll(customQueryParticipants);
            baseQuery = (TypedQuery)customQueryParticipants.get(0);
            sqlQuery = ((CustomSQLTypedQuery)customQuery).getSql();
        } else {
            baseQuery = leftMostQuery;
            participatingQueries.add((Query)baseQuery);
            sqlQuery = this.cbf.getExtendedQuerySupport().getSql(this.em, (Query)baseQuery);
        }
        int size = sqlQuery.length() + 10;
        ArrayList<String> setOperands = new ArrayList<String>();
        setOperands.add(sqlQuery);
        for (AbstractCommonQueryBuilder<?, ?, ?, ?, ?> setOperand : this.setOperationManager.getSetOperations()) {
            String setOperandSql;
            List<Query> customQueryParticipants2;
            Object customQuery2;
            Query q = setOperand.getQuery();
            if (q instanceof CustomSQLQuery) {
                customQuery2 = (CustomSQLQuery)q;
                customQueryParticipants2 = ((CustomSQLQuery)customQuery2).getParticipatingQueries();
                participatingQueries.addAll(customQueryParticipants2);
                setOperandSql = ((CustomSQLQuery)customQuery2).getSql();
            } else if (q instanceof CustomSQLTypedQuery) {
                customQuery2 = (CustomSQLTypedQuery)q;
                customQueryParticipants2 = ((CustomSQLTypedQuery)customQuery2).getParticipatingQueries();
                participatingQueries.addAll(customQueryParticipants2);
                setOperandSql = ((CustomSQLTypedQuery)customQuery2).getSql();
            } else {
                setOperandSql = this.cbf.getExtendedQuerySupport().getSql(this.em, q);
                participatingQueries.add(q);
            }
            setOperands.add(setOperandSql);
            size += setOperandSql.length() + 30;
        }
        StringBuilder sqlSb = new StringBuilder(size);
        String limit = null;
        String offset = null;
        if (this.firstResult != 0) {
            offset = Integer.toString(this.firstResult);
        }
        if (this.maxResults != Integer.MAX_VALUE) {
            limit = Integer.toString(this.maxResults);
        }
        this.dbmsDialect.appendSet(sqlSb, this.setOperationManager.getOperator(), this.setOperationManager.isNested(), setOperands, this.getOrderByElements(), limit, offset);
        StringBuilder withClause = this.applyCtes(sqlSb, (Query)baseQuery, false, participatingQueries);
        this.applyExtendedSql(sqlSb, false, false, withClause, null, null);
        String finalQuery = sqlSb.toString();
        CustomSQLTypedQuery query = new CustomSQLTypedQuery(participatingQueries, baseQuery, this.dbmsDialect, this.em, this.cbf.getExtendedQuerySupport(), finalQuery);
        return query;
    }

    @Override
    protected Map<String, String> applyExtendedSql(StringBuilder sqlSb, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        return this.dbmsDialect.appendExtendedSql(sqlSb, this.statementType, isSubquery, isEmbedded, withClause, null, null, returningColumns, includedModificationStates);
    }

    protected String getOperator(SetOperationType type) {
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT ALL";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT ALL";
            }
        }
        return null;
    }

    public TypedQuery<T> getQuery() {
        return this.getTypedQuery();
    }

    public List<T> getResultList() {
        return this.getTypedQuery().getResultList();
    }

    public T getSingleResult() {
        return (T)this.getTypedQuery().getSingleResult();
    }
}

