/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseInsertCriteriaBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.impl.AbstractModificationCriteriaBuilder;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.spi.DbmsStatementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Query;

public class BaseInsertCriteriaBuilderImpl<T, X extends BaseInsertCriteriaBuilder<T, X>, Y>
extends AbstractModificationCriteriaBuilder<T, X, Y>
implements BaseInsertCriteriaBuilder<T, X>,
SelectBuilder<X> {
    private final Map<String, Integer> bindingMap = new TreeMap<String, Integer>();

    public BaseInsertCriteriaBuilderImpl(MainQuery mainQuery, boolean isMainQuery, Class<T> clazz, Class<?> cteClass, Y result, CTEBuilderListener listener) {
        super(mainQuery, isMainQuery, DbmsStatementType.INSERT, clazz, null, cteClass, result, listener);
        if (!this.jpaProvider.supportsInsertStatement()) {
            throw new IllegalStateException("JPA provider does not support insert statements!");
        }
    }

    public X bind(String attributeName, Object value) {
        this.entityType.getAttribute(attributeName);
        Integer attributeBindIndex = this.bindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.bindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
        this.selectManager.select((Expression)this.parameterManager.addParameterExpression(value), null);
        return (X)this;
    }

    public SelectBuilder<X> bind(String attributeName) {
        this.entityType.getAttribute(attributeName);
        Integer attributeBindIndex = this.bindingMap.get(attributeName);
        if (attributeBindIndex != null) {
            throw new IllegalArgumentException("The attribute [" + attributeName + "] has already been bound!");
        }
        this.bindingMap.put(attributeName, this.selectManager.getSelectInfos().size());
        return this;
    }

    @Override
    protected void prepareAndCheck() {
        ArrayList<String> attributes = new ArrayList<String>(this.bindingMap.size());
        ArrayList<SelectInfo> originalSelectInfos = new ArrayList<SelectInfo>(this.selectManager.getSelectInfos());
        List<SelectInfo> newSelectInfos = this.selectManager.getSelectInfos();
        newSelectInfos.clear();
        for (Map.Entry<String, Integer> attributeEntry : this.bindingMap.entrySet()) {
            Integer newPosition = attributes.size();
            attributes.add(attributeEntry.getKey());
            SelectInfo selectInfo = (SelectInfo)originalSelectInfos.get(attributeEntry.getValue());
            newSelectInfos.add(selectInfo);
            attributeEntry.setValue(newPosition);
        }
        super.prepareAndCheck();
    }

    @Override
    protected boolean isJoinRequiredForSelect() {
        return false;
    }

    @Override
    protected void getQueryString1(StringBuilder sbSelectFrom) {
        sbSelectFrom.append("INSERT INTO ");
        sbSelectFrom.append(this.entityType.getName()).append('(');
        boolean first = true;
        for (Map.Entry<String, Integer> attributeEntry : this.bindingMap.entrySet()) {
            if (first) {
                first = false;
            } else {
                sbSelectFrom.append(", ");
            }
            sbSelectFrom.append(attributeEntry.getKey());
        }
        sbSelectFrom.append(")\n");
        super.getQueryString1(sbSelectFrom);
    }

    @Override
    public Query getQuery() {
        if (this.jpaProvider.supportsInsertStatement()) {
            return super.getQuery();
        }
        throw new UnsupportedOperationException("Not yet implemented!");
    }
}

