/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.CTEBuilderListener;
import com.blazebit.persistence.impl.CTEInfoBuilder;

public class CTEBuilderListenerImpl
implements CTEBuilderListener {
    private CTEInfoBuilder currentCteBuilder;

    @Override
    public void onReplaceBuilder(CTEInfoBuilder oldBuilder, CTEInfoBuilder newBuilder) {
        if (this.currentCteBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        if (this.currentCteBuilder != oldBuilder) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentCteBuilder = newBuilder;
    }

    public void verifyBuilderEnded() {
        if (this.currentCteBuilder != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    @Override
    public void onBuilderEnded(CTEInfoBuilder builder) {
        if (this.currentCteBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentCteBuilder = null;
    }

    @Override
    public void onBuilderStarted(CTEInfoBuilder builder) {
        if (this.currentCteBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentCteBuilder = builder;
    }
}

