/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.impl.CriteriaBuilderFactoryImpl;
import com.blazebit.persistence.impl.dialect.DB2DbmsDialect;
import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.dialect.H2DbmsDialect;
import com.blazebit.persistence.impl.dialect.MySQLDbmsDialect;
import com.blazebit.persistence.impl.dialect.OracleDbmsDialect;
import com.blazebit.persistence.impl.dialect.PostgreSQLDbmsDialect;
import com.blazebit.persistence.impl.function.datediff.day.AccessDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.DB2DayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.DefaultDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.MySQLDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.day.PostgreSQLDayDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.AccessHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.DB2HourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.DefaultHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.MySQLHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.hour.PostgreSQLHourDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.AccessMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.DB2MinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.DefaultMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.MySQLMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.minute.PostgreSQLMinuteDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.AccessMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.DB2MonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.DefaultMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.MySQLMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.month.PostgreSQLMonthDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.AccessSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.DB2SecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.DefaultSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.MySQLSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.second.PostgreSQLSecondDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.AccessYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.DB2YearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.DefaultYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.MySQLYearDiffFunction;
import com.blazebit.persistence.impl.function.datediff.year.PostgreSQLYearDiffFunction;
import com.blazebit.persistence.impl.function.datetime.day.AccessDayFunction;
import com.blazebit.persistence.impl.function.datetime.day.DB2DayFunction;
import com.blazebit.persistence.impl.function.datetime.day.DayFunction;
import com.blazebit.persistence.impl.function.datetime.day.DerbyDayFunction;
import com.blazebit.persistence.impl.function.datetime.day.SQLServerDayFunction;
import com.blazebit.persistence.impl.function.datetime.day.SybaseDayFunction;
import com.blazebit.persistence.impl.function.datetime.hour.AccessHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.DB2HourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.DerbyHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.HourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.SQLServerHourFunction;
import com.blazebit.persistence.impl.function.datetime.hour.SybaseHourFunction;
import com.blazebit.persistence.impl.function.datetime.minute.AccessMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.DB2MinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.DerbyMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.MinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.SQLServerMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.minute.SybaseMinuteFunction;
import com.blazebit.persistence.impl.function.datetime.month.AccessMonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.DB2MonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.DerbyMonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.MonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.SQLServerMonthFunction;
import com.blazebit.persistence.impl.function.datetime.month.SybaseMonthFunction;
import com.blazebit.persistence.impl.function.datetime.second.AccessSecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.DB2SecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.DerbySecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.SQLServerSecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.SecondFunction;
import com.blazebit.persistence.impl.function.datetime.second.SybaseSecondFunction;
import com.blazebit.persistence.impl.function.datetime.year.AccessYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.DB2YearFunction;
import com.blazebit.persistence.impl.function.datetime.year.DerbyYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.SQLServerYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.SybaseYearFunction;
import com.blazebit.persistence.impl.function.datetime.year.YearFunction;
import com.blazebit.persistence.impl.function.groupconcat.DB2GroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.H2GroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.MySQLGroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.OracleGroupConcatFunction;
import com.blazebit.persistence.impl.function.groupconcat.PostgreSQLGroupConcatFunction;
import com.blazebit.persistence.impl.function.limit.LimitFunction;
import com.blazebit.persistence.impl.function.pageposition.MySQLPagePositionFunction;
import com.blazebit.persistence.impl.function.pageposition.OraclePagePositionFunction;
import com.blazebit.persistence.impl.function.pageposition.PagePositionFunction;
import com.blazebit.persistence.impl.function.pageposition.TransactSQLPagePositionFunction;
import com.blazebit.persistence.impl.function.set.SetFunction;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.EntityManagerIntegrator;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import com.blazebit.persistence.spi.QueryTransformer;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;

public class CriteriaBuilderConfigurationImpl
implements CriteriaBuilderConfiguration {
    private final List<QueryTransformer> queryTransformers = new ArrayList<QueryTransformer>();
    private final Map<String, DbmsDialect> dbmsDialects = new HashMap<String, DbmsDialect>();
    private final Map<String, JpqlFunctionGroup> functions = new HashMap<String, JpqlFunctionGroup>();
    private final List<EntityManagerIntegrator> entityManagerIntegrators = new ArrayList<EntityManagerIntegrator>();
    private Properties properties = new Properties();
    private ExtendedQuerySupport extendedQuerySupport;

    public CriteriaBuilderConfigurationImpl() {
        this.loadDefaultProperties();
        this.loadQueryTransformers();
        this.loadExtendedQuerySupport();
        this.loadEntityManagerIntegrator();
        this.loadDbmsDialects();
        this.loadFunctions();
    }

    private void loadFunctions() {
        JpqlFunctionGroup jpqlFunctionGroup = new JpqlFunctionGroup("limit", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new LimitFunction(this.dbmsDialects.get(null)));
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("mysql")));
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("oracle")));
        jpqlFunctionGroup.add("db2", (JpqlFunction)new LimitFunction(this.dbmsDialects.get("db2")));
        jpqlFunctionGroup.add("sybase", null);
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("page_position", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new PagePositionFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLPagePositionFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OraclePagePositionFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new TransactSQLPagePositionFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new TransactSQLPagePositionFunction());
        this.registerFunction(jpqlFunctionGroup);
        for (SetOperationType setType : SetOperationType.values()) {
            jpqlFunctionGroup = new JpqlFunctionGroup("set_" + setType.name().toLowerCase(), false);
            for (Map.Entry<String, DbmsDialect> dbmsDialectEntry : this.dbmsDialects.entrySet()) {
                jpqlFunctionGroup.add(dbmsDialectEntry.getKey(), (JpqlFunction)new SetFunction(setType, dbmsDialectEntry.getValue()));
            }
            this.registerFunction(jpqlFunctionGroup);
        }
        jpqlFunctionGroup = new JpqlFunctionGroup("group_concat", true);
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2GroupConcatFunction());
        jpqlFunctionGroup.add("oracle", (JpqlFunction)new OracleGroupConcatFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new H2GroupConcatFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLGroupConcatFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLGroupConcatFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("year", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new YearFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessYearFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2YearFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyYearFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerYearFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseYearFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("month", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new MonthFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMonthFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MonthFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyMonthFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerMonthFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseMonthFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("day", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new DayFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessDayFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2DayFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyDayFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerDayFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseDayFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("hour", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new HourFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessHourFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2HourFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyHourFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerHourFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseHourFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("minute", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new MinuteFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMinuteFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MinuteFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbyMinuteFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerMinuteFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseMinuteFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("second", false);
        jpqlFunctionGroup.add(null, (JpqlFunction)new SecondFunction());
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessSecondFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2SecondFunction());
        jpqlFunctionGroup.add("derby", (JpqlFunction)new DerbySecondFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new SQLServerSecondFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new SybaseSecondFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("year_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessYearDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2YearDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultYearDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultYearDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLYearDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultYearDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLYearDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("month_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMonthDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MonthDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultMonthDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultMonthDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLMonthDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultMonthDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLMonthDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("day_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessDayDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2DayDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultDayDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultDayDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLDayDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultDayDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLDayDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("hour_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessHourDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2HourDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultHourDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultHourDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLHourDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultHourDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLHourDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("minute_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessMinuteDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2MinuteDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultMinuteDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultMinuteDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLMinuteDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultMinuteDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLMinuteDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
        jpqlFunctionGroup = new JpqlFunctionGroup("second_diff", false);
        jpqlFunctionGroup.add("access", (JpqlFunction)new AccessSecondDiffFunction());
        jpqlFunctionGroup.add("db2", (JpqlFunction)new DB2SecondDiffFunction());
        jpqlFunctionGroup.add("h2", (JpqlFunction)new DefaultSecondDiffFunction());
        jpqlFunctionGroup.add("microsoft", (JpqlFunction)new DefaultSecondDiffFunction());
        jpqlFunctionGroup.add("mysql", (JpqlFunction)new MySQLSecondDiffFunction());
        jpqlFunctionGroup.add("sybase", (JpqlFunction)new DefaultSecondDiffFunction());
        jpqlFunctionGroup.add("postgresql", (JpqlFunction)new PostgreSQLSecondDiffFunction());
        this.registerFunction(jpqlFunctionGroup);
    }

    private void loadDbmsDialects() {
        this.registerDialect(null, new DefaultDbmsDialect());
        this.registerDialect("mysql", new MySQLDbmsDialect());
        this.registerDialect("h2", new H2DbmsDialect());
        this.registerDialect("db2", new DB2DbmsDialect());
        this.registerDialect("postgresql", new PostgreSQLDbmsDialect());
        this.registerDialect("oracle", new OracleDbmsDialect());
    }

    private void loadDefaultProperties() {
        this.properties.put("com.blazebit.persistence.compatible_mode", "false");
    }

    private void loadQueryTransformers() {
        ServiceLoader<QueryTransformer> serviceLoader = ServiceLoader.load(QueryTransformer.class);
        Iterator<QueryTransformer> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            QueryTransformer transformer = iterator.next();
            this.queryTransformers.add(transformer);
        }
    }

    private void loadExtendedQuerySupport() {
        ServiceLoader<ExtendedQuerySupport> serviceLoader = ServiceLoader.load(ExtendedQuerySupport.class);
        Iterator<ExtendedQuerySupport> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            this.extendedQuerySupport = iterator.next();
        }
    }

    private void loadEntityManagerIntegrator() {
        ServiceLoader<EntityManagerIntegrator> serviceLoader = ServiceLoader.load(EntityManagerIntegrator.class);
        Iterator<EntityManagerIntegrator> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            EntityManagerIntegrator enricher = iterator.next();
            this.entityManagerIntegrators.add(enricher);
        }
    }

    public CriteriaBuilderConfiguration registerFunction(JpqlFunctionGroup jpqlFunctionGroup) {
        String functionName = jpqlFunctionGroup.getName().toLowerCase();
        this.functions.put(functionName, jpqlFunctionGroup);
        return this;
    }

    public Map<String, JpqlFunctionGroup> getFunctions() {
        return this.functions;
    }

    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    public CriteriaBuilderConfiguration registerDialect(String dbms, DbmsDialect dialect) {
        this.dbmsDialects.put(dbms, dialect);
        return this;
    }

    public Map<String, DbmsDialect> getDbmsDialects() {
        return this.dbmsDialects;
    }

    public CriteriaBuilderConfiguration registerQueryTransformer(QueryTransformer transformer) {
        this.queryTransformers.add(transformer);
        return this;
    }

    public List<QueryTransformer> getQueryTransformers() {
        return this.queryTransformers;
    }

    public ExtendedQuerySupport getExtendedQuerySupport() {
        return this.extendedQuerySupport;
    }

    public CriteriaBuilderConfiguration registerEntityManagerIntegrator(EntityManagerIntegrator entityManagerEnricher) {
        this.entityManagerIntegrators.add(entityManagerEnricher);
        return this;
    }

    public List<EntityManagerIntegrator> getEntityManagerIntegrators() {
        return this.entityManagerIntegrators;
    }

    public CriteriaBuilderFactory createCriteriaBuilderFactory() {
        return new CriteriaBuilderFactoryImpl(this);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public CriteriaBuilderConfiguration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public CriteriaBuilderConfiguration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public CriteriaBuilderConfiguration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public CriteriaBuilderConfiguration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }
}

