/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.InsertCriteriaBuilder;
import com.blazebit.persistence.LeafOngoingSetOperationCriteriaBuilder;
import com.blazebit.persistence.StartOngoingSetOperationCriteriaBuilder;
import com.blazebit.persistence.UpdateCriteriaBuilder;
import com.blazebit.persistence.impl.CriteriaBuilderConfigurationImpl;
import com.blazebit.persistence.impl.CriteriaBuilderImpl;
import com.blazebit.persistence.impl.DeleteCriteriaBuilderImpl;
import com.blazebit.persistence.impl.FinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.InsertCriteriaBuilderImpl;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.OngoingSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.UpdateCriteriaBuilderImpl;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.ExpressionFactoryImpl;
import com.blazebit.persistence.impl.expression.SimpleCachingExpressionFactory;
import com.blazebit.persistence.impl.expression.SubqueryExpressionFactory;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.EntityManagerIntegrator;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import com.blazebit.persistence.spi.QueryTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManager;

public class CriteriaBuilderFactoryImpl
implements CriteriaBuilderFactory {
    private final List<QueryTransformer> queryTransformers;
    private final ExtendedQuerySupport extendedQuerySupport;
    private final Map<String, DbmsDialect> dbmsDialects;
    private final Map<String, JpqlFunctionGroup> functions;
    private final Set<String> aggregateFunctions;
    private final List<EntityManagerIntegrator> entityManagerIntegrators;
    private final ExpressionFactory expressionFactory;
    private final ExpressionFactory subqueryExpressionFactory;
    private final Map<String, Object> properties;
    private final boolean compatibleModeEnabled;

    public CriteriaBuilderFactoryImpl(CriteriaBuilderConfigurationImpl config) {
        this.queryTransformers = new ArrayList<QueryTransformer>(config.getQueryTransformers());
        this.extendedQuerySupport = config.getExtendedQuerySupport();
        this.dbmsDialects = new HashMap<String, DbmsDialect>(config.getDbmsDialects());
        this.functions = new HashMap<String, JpqlFunctionGroup>(config.getFunctions());
        this.aggregateFunctions = CriteriaBuilderFactoryImpl.resolveAggregateFunctions(this.functions);
        this.entityManagerIntegrators = new ArrayList<EntityManagerIntegrator>(config.getEntityManagerIntegrators());
        this.expressionFactory = new SimpleCachingExpressionFactory((ExpressionFactory)new ExpressionFactoryImpl(this.aggregateFunctions));
        this.subqueryExpressionFactory = new SubqueryExpressionFactory(this.aggregateFunctions, this.expressionFactory);
        this.properties = this.copyProperties(config.getProperties());
        this.compatibleModeEnabled = Boolean.valueOf(String.valueOf(this.properties.get("com.blazebit.persistence.compatible_mode")));
    }

    private static Set<String> resolveAggregateFunctions(Map<String, JpqlFunctionGroup> functions) {
        HashSet<String> aggregateFunctions = new HashSet<String>();
        for (Map.Entry<String, JpqlFunctionGroup> entry : functions.entrySet()) {
            if (!entry.getValue().isAggregate()) continue;
            aggregateFunctions.add(entry.getKey().toLowerCase());
        }
        return aggregateFunctions;
    }

    public List<QueryTransformer> getQueryTransformers() {
        return this.queryTransformers;
    }

    public ExtendedQuerySupport getExtendedQuerySupport() {
        return this.extendedQuerySupport;
    }

    public Set<String> getAggregateFunctions() {
        return this.aggregateFunctions;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public ExpressionFactory getSubqueryExpressionFactory() {
        return this.subqueryExpressionFactory;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean isCompatibleModeEnabled() {
        return this.compatibleModeEnabled;
    }

    private MainQuery createMainQuery(EntityManager entityManager) {
        HashSet<String> registeredFunctions = new HashSet<String>();
        EntityManager em = entityManager;
        String dbms = null;
        for (int i = 0; i < this.entityManagerIntegrators.size(); ++i) {
            EntityManagerIntegrator integrator = this.entityManagerIntegrators.get(i);
            em = integrator.registerFunctions(em, this.functions);
            registeredFunctions.addAll(integrator.getRegisteredFunctions(em));
            dbms = integrator.getDbms(em);
        }
        DbmsDialect dialect = this.dbmsDialects.get(dbms);
        if (dialect == null) {
            dialect = this.dbmsDialects.get(null);
        }
        return MainQuery.create(this, em, dbms, dialect, registeredFunctions);
    }

    public <T> StartOngoingSetOperationCriteriaBuilder<T, LeafOngoingSetOperationCriteriaBuilder<T>> startSet(EntityManager entityManager, Class<T> resultClass) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        FinalSetOperationCriteriaBuilderImpl<T> parentFinalSetOperationBuilder = new FinalSetOperationCriteriaBuilderImpl<T>(mainQuery, true, resultClass, null, false, null);
        OngoingFinalSetOperationCriteriaBuilderImpl<LeafOngoingSetOperationCriteriaBuilderImpl<T>> subFinalSetOperationBuilder = new OngoingFinalSetOperationCriteriaBuilderImpl<LeafOngoingSetOperationCriteriaBuilderImpl<T>>(mainQuery, false, resultClass, null, true, parentFinalSetOperationBuilder.getSubListener());
        LeafOngoingSetOperationCriteriaBuilderImpl<T> leafCb = new LeafOngoingSetOperationCriteriaBuilderImpl<T>(mainQuery, false, resultClass, parentFinalSetOperationBuilder.getSubListener(), parentFinalSetOperationBuilder);
        OngoingSetOperationCriteriaBuilderImpl<T, LeafOngoingSetOperationCriteriaBuilderImpl<T>> cb = new OngoingSetOperationCriteriaBuilderImpl<T, LeafOngoingSetOperationCriteriaBuilderImpl<T>>(mainQuery, false, resultClass, subFinalSetOperationBuilder.getSubListener(), subFinalSetOperationBuilder, leafCb);
        subFinalSetOperationBuilder.setEndSetResult(leafCb);
        subFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(cb);
        parentFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(subFinalSetOperationBuilder);
        subFinalSetOperationBuilder.getSubListener().onBuilderStarted(cb);
        parentFinalSetOperationBuilder.getSubListener().onBuilderStarted(leafCb);
        return cb;
    }

    public <T> CriteriaBuilder<T> create(EntityManager entityManager, Class<T> resultClass) {
        return this.create(entityManager, resultClass, null);
    }

    public <T> CriteriaBuilder<T> create(EntityManager entityManager, Class<T> resultClass, String alias) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        CriteriaBuilderImpl<T> cb = new CriteriaBuilderImpl<T>(mainQuery, true, resultClass, alias);
        return cb;
    }

    public <T> DeleteCriteriaBuilder<T> delete(EntityManager entityManager, Class<T> deleteClass) {
        return this.delete(entityManager, deleteClass, null);
    }

    public <T> DeleteCriteriaBuilder<T> delete(EntityManager entityManager, Class<T> deleteClass, String alias) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        DeleteCriteriaBuilderImpl<T> cb = new DeleteCriteriaBuilderImpl<T>(mainQuery, deleteClass, alias);
        return cb;
    }

    public <T> UpdateCriteriaBuilder<T> update(EntityManager entityManager, Class<T> updateClass) {
        return this.update(entityManager, updateClass, null);
    }

    public <T> UpdateCriteriaBuilder<T> update(EntityManager entityManager, Class<T> updateClass, String alias) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        UpdateCriteriaBuilderImpl<T> cb = new UpdateCriteriaBuilderImpl<T>(mainQuery, updateClass, alias);
        return cb;
    }

    public <T> InsertCriteriaBuilder<T> insert(EntityManager entityManager, Class<T> insertClass) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        InsertCriteriaBuilderImpl<T> cb = new InsertCriteriaBuilderImpl<T>(mainQuery, insertClass);
        return cb;
    }

    public <T> T getService(Class<T> serviceClass) {
        if (ExpressionFactory.class.isAssignableFrom(serviceClass)) {
            return (T)this.expressionFactory;
        }
        return null;
    }

    private Map<String, Object> copyProperties(Properties properties) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            newProperties.put(key, value);
        }
        return newProperties;
    }
}

