/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.spi.CteQueryWrapper;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;

public class CustomSQLQuery
implements Query,
CteQueryWrapper {
    private final List<Query> participatingQueries;
    private final Query delegate;
    private final DbmsDialect dbmsDialect;
    private final EntityManager em;
    private final ExtendedQuerySupport extendedQuerySupport;
    private final String sql;
    private final Map<String, String> addedCtes;

    public CustomSQLQuery(List<Query> participatingQueries, Query delegate, DbmsDialect dbmsDialect, EntityManager em, ExtendedQuerySupport extendedQuerySupport, String sql, Map<String, String> addedCtes) {
        this.participatingQueries = participatingQueries;
        this.delegate = delegate;
        this.dbmsDialect = dbmsDialect;
        this.em = em;
        this.extendedQuerySupport = extendedQuerySupport;
        this.sql = sql;
        this.addedCtes = addedCtes;
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, String> getAddedCtes() {
        return this.addedCtes;
    }

    public List<Query> getParticipatingQueries() {
        return this.participatingQueries;
    }

    private Query wrapOrReturn(Query q) {
        if (q == this.delegate) {
            return this;
        }
        return new CustomSQLQuery(this.participatingQueries, q, this.dbmsDialect, this.em, this.extendedQuerySupport, this.sql, this.addedCtes);
    }

    public List getResultList() {
        throw new IllegalArgumentException("Can not call getResultList on a modification query!");
    }

    public Object getSingleResult() {
        throw new IllegalArgumentException("Can not call getSingleResult on a modification query!");
    }

    public int executeUpdate() {
        return this.extendedQuerySupport.executeUpdate(this.dbmsDialect, this.em, this.participatingQueries, this.delegate, this.sql);
    }

    public Query setMaxResults(int maxResult) {
        return this.wrapOrReturn(this.delegate.setMaxResults(maxResult));
    }

    public int getMaxResults() {
        return this.delegate.getMaxResults();
    }

    public Query setFirstResult(int startPosition) {
        return this.wrapOrReturn(this.delegate.setFirstResult(startPosition));
    }

    public int getFirstResult() {
        return this.delegate.getFirstResult();
    }

    public Query setHint(String hintName, Object value) {
        return this.wrapOrReturn(this.delegate.setHint(hintName, value));
    }

    public Map<String, Object> getHints() {
        return this.delegate.getHints();
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        return this.wrapOrReturn(this.delegate.setParameter(param, value));
    }

    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        return this.wrapOrReturn(this.delegate.setParameter(param, value, temporalType));
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        return this.wrapOrReturn(this.delegate.setParameter(param, value, temporalType));
    }

    public Query setParameter(String name, Object value) {
        return this.wrapOrReturn(this.delegate.setParameter(name, value));
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        return this.wrapOrReturn(this.delegate.setParameter(name, value, temporalType));
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        return this.wrapOrReturn(this.delegate.setParameter(name, value, temporalType));
    }

    public Query setParameter(int position, Object value) {
        return this.wrapOrReturn(this.delegate.setParameter(position, value));
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        return this.wrapOrReturn(this.delegate.setParameter(position, value, temporalType));
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        return this.wrapOrReturn(this.delegate.setParameter(position, value, temporalType));
    }

    public Set<Parameter<?>> getParameters() {
        return this.delegate.getParameters();
    }

    public Parameter<?> getParameter(String name) {
        return this.delegate.getParameter(name);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.delegate.getParameter(name, type);
    }

    public Parameter<?> getParameter(int position) {
        return this.delegate.getParameter(position);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this.delegate.getParameter(position, type);
    }

    public boolean isBound(Parameter<?> param) {
        return this.delegate.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.delegate.getParameterValue(param);
    }

    public Object getParameterValue(String name) {
        return this.delegate.getParameterValue(name);
    }

    public Object getParameterValue(int position) {
        return this.delegate.getParameterValue(position);
    }

    public Query setFlushMode(FlushModeType flushMode) {
        return this.wrapOrReturn(this.delegate.setFlushMode(flushMode));
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public Query setLockMode(LockModeType lockMode) {
        return this.wrapOrReturn(this.delegate.setLockMode(lockMode));
    }

    public LockModeType getLockMode() {
        return this.delegate.getLockMode();
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.delegate.unwrap(cls);
    }
}

