/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.expression.AggregateExpression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.FetchType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;

public class EntitySelectResolveVisitor
extends VisitorAdapter {
    private final Metamodel m;
    private final Set<PathExpression> pathExpressions;

    public EntitySelectResolveVisitor(Metamodel m) {
        this(m, new LinkedHashSet<PathExpression>());
    }

    public EntitySelectResolveVisitor(Metamodel m, Set<PathExpression> pathExpressions) {
        this.m = m;
        this.pathExpressions = pathExpressions;
    }

    public Set<PathExpression> getPathExpressions() {
        return this.pathExpressions;
    }

    public void visit(FunctionExpression expression) {
        if (!(expression instanceof AggregateExpression)) {
            super.visit(expression);
        }
    }

    public void visit(PathExpression expression) {
        if (expression.getField() == null) {
            EntityType entityType;
            JoinNode baseNode = (JoinNode)expression.getBaseNode();
            try {
                entityType = this.m.entity(baseNode.getPropertyClass());
            }
            catch (IllegalArgumentException e) {
                return;
            }
            TreeSet sortedAttributes = new TreeSet(new Comparator<Attribute<?, ?>>(){

                @Override
                public int compare(Attribute<?, ?> o1, Attribute<?, ?> o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            sortedAttributes.addAll(entityType.getAttributes());
            for (Attribute attr : sortedAttributes) {
                boolean resolve = false;
                if (ExpressionUtils.isAssociation(attr) && !attr.isCollection()) {
                    resolve = true;
                } else if (ExpressionUtils.getFetchType(attr) == FetchType.EAGER) {
                    if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ELEMENT_COLLECTION) {
                        throw new UnsupportedOperationException("Eager element collections are not supported");
                    }
                    resolve = true;
                }
                if (!resolve) continue;
                PathExpression attrPath = new PathExpression(new ArrayList(expression.getExpressions()));
                attrPath.setBaseNode((Object)baseNode);
                attrPath.setField(attr.getName());
                this.pathExpressions.add(attrPath);
            }
        }
    }

    public void resolve(JoinNode baseNode) {
    }
}

