/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.impl.AliasReplacementTransformer;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.expression.AbortableVisitorAdapter;
import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FooExpression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.impl.expression.LiteralExpression;
import com.blazebit.persistence.impl.expression.NullExpression;
import com.blazebit.persistence.impl.expression.ParameterExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;

public class ExpressionUtils {
    private static final AbortableVisitorAdapter subqueryExpressionDetector = new AbortableVisitorAdapter(){

        public Boolean visit(SubqueryExpression expression) {
            return true;
        }
    };
    private static final AbortableVisitorAdapter sizeExpressionDetector = new AbortableVisitorAdapter(){

        public Boolean visit(FunctionExpression expression) {
            return ExpressionUtils.isSizeFunction(expression);
        }
    };

    public static boolean isUnique(Metamodel metamodel, Expression expr) {
        if (expr instanceof CompositeExpression) {
            return ExpressionUtils.isUnique(metamodel, (CompositeExpression)expr);
        }
        if (expr instanceof FunctionExpression) {
            return ExpressionUtils.isUnique(metamodel, (FunctionExpression)expr);
        }
        if (expr instanceof PathExpression) {
            return ExpressionUtils.isUnique(metamodel, (PathExpression)expr);
        }
        if (expr instanceof SubqueryExpression) {
            return ExpressionUtils.isUnique(metamodel, (SubqueryExpression)expr);
        }
        if (expr instanceof ParameterExpression) {
            return false;
        }
        if (expr instanceof GeneralCaseExpression) {
            return ExpressionUtils.isUnique(metamodel, (GeneralCaseExpression)expr);
        }
        if (expr instanceof FooExpression) {
            return false;
        }
        if (expr instanceof LiteralExpression) {
            return false;
        }
        if (expr instanceof NullExpression) {
            return true;
        }
        throw new IllegalArgumentException("The expression of type '" + expr.getClass().getName() + "' can not be analyzed for uniqueness!");
    }

    private static boolean isUnique(Metamodel metamodel, CompositeExpression expr) {
        if (expr.getExpressions().size() > 1) {
            return false;
        }
        return ExpressionUtils.isUnique(metamodel, (Expression)expr.getExpressions().get(0));
    }

    private static boolean isUnique(Metamodel metamodel, FunctionExpression expr) {
        return false;
    }

    private static boolean isUnique(Metamodel metamodel, SubqueryExpression expr) {
        List<Expression> expressions = ((SubqueryInternalBuilder)expr.getSubquery()).getSelectExpressions();
        if (expressions.size() != 1) {
            throw new IllegalArgumentException("Can't perform nullability analysis on a subquery with more than one result column!");
        }
        return ExpressionUtils.isUnique(metamodel, expressions.get(0));
    }

    private static boolean isUnique(Metamodel metamodel, GeneralCaseExpression expr) {
        if (!ExpressionUtils.isUnique(metamodel, expr.getDefaultExpr())) {
            return false;
        }
        List expressions = expr.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (ExpressionUtils.isUnique(metamodel, ((WhenClauseExpression)expressions.get(i)).getResult())) continue;
            return false;
        }
        return true;
    }

    private static boolean isUnique(Metamodel metamodel, PathExpression expr) {
        ManagedType t;
        Attribute attr;
        JoinNode baseNode = (JoinNode)expr.getBaseNode();
        if (expr.getField() != null && !ExpressionUtils.isUnique(attr = (t = metamodel.managedType(baseNode.getPropertyClass())).getAttribute(expr.getField()))) {
            return false;
        }
        while (baseNode.getParent() != null) {
            attr = baseNode.getParentTreeNode().getAttribute();
            if (!ExpressionUtils.isUnique(attr)) {
                return false;
            }
            baseNode = baseNode.getParent();
        }
        return true;
    }

    private static boolean isUnique(Attribute<?, ?> attr) {
        if (attr.isCollection()) {
            return false;
        }
        return ((SingularAttribute)attr).isId();
    }

    public static String unwrapStringLiteral(String stringLiteral) {
        if (stringLiteral.length() >= 2 && stringLiteral.startsWith("'") && stringLiteral.endsWith("'")) {
            return stringLiteral.substring(1, stringLiteral.length() - 1);
        }
        return stringLiteral;
    }

    public static boolean isFunctionFunctionExpression(FunctionExpression func) {
        return "FUNCTION".equalsIgnoreCase(func.getFunctionName());
    }

    public static boolean isNullable(Metamodel metamodel, Expression expr) {
        if (expr instanceof CompositeExpression) {
            return ExpressionUtils.isNullable(metamodel, (CompositeExpression)expr);
        }
        if (expr instanceof FunctionExpression) {
            return ExpressionUtils.isNullable(metamodel, (FunctionExpression)expr);
        }
        if (expr instanceof PathExpression) {
            return ExpressionUtils.isNullable(metamodel, (PathExpression)expr);
        }
        if (expr instanceof SubqueryExpression) {
            return ExpressionUtils.isNullable(metamodel, (SubqueryExpression)expr);
        }
        if (expr instanceof ParameterExpression) {
            return true;
        }
        if (expr instanceof GeneralCaseExpression) {
            return ExpressionUtils.isNullable(metamodel, (GeneralCaseExpression)expr);
        }
        if (expr instanceof FooExpression) {
            return false;
        }
        if (expr instanceof LiteralExpression) {
            return false;
        }
        if (expr instanceof NullExpression) {
            return true;
        }
        throw new IllegalArgumentException("The expression of type '" + expr.getClass().getName() + "' can not be analyzed for nullability!");
    }

    private static boolean isNullable(Metamodel metamodel, CompositeExpression expr) {
        List expressions = expr.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            boolean nullable = ExpressionUtils.isNullable(metamodel, (Expression)expressions.get(i));
            if (!nullable) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(Metamodel metamodel, GeneralCaseExpression expr) {
        if (ExpressionUtils.isNullable(metamodel, expr.getDefaultExpr())) {
            return true;
        }
        List expressions = expr.getWhenClauses();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            if (!ExpressionUtils.isNullable(metamodel, ((WhenClauseExpression)expressions.get(i)).getResult())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(Metamodel metamodel, FunctionExpression expr) {
        if ("NULLIF".equalsIgnoreCase(expr.getFunctionName())) {
            return true;
        }
        if ("COALESCE".equalsIgnoreCase(expr.getFunctionName())) {
            List expressions = expr.getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                boolean nullable = ExpressionUtils.isNullable(metamodel, (Expression)expressions.get(i));
                if (nullable) continue;
                return false;
            }
            return true;
        }
        List expressions = expr.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            boolean nullable = ExpressionUtils.isNullable(metamodel, (Expression)expressions.get(i));
            if (!nullable) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullable(Metamodel metamodel, SubqueryExpression expr) {
        List<Expression> expressions = ((SubqueryInternalBuilder)expr.getSubquery()).getSelectExpressions();
        if (expressions.size() != 1) {
            throw new IllegalArgumentException("Can't perform nullability analysis on a subquery with more than one result column!");
        }
        return ExpressionUtils.isNullable(metamodel, expressions.get(0));
    }

    private static boolean isNullable(Metamodel metamodel, PathExpression expr) {
        ManagedType t;
        Attribute attr;
        JoinNode baseNode = (JoinNode)expr.getBaseNode();
        if (expr.getField() != null && ExpressionUtils.isNullable(attr = (t = metamodel.managedType(baseNode.getPropertyClass())).getAttribute(expr.getField()))) {
            return true;
        }
        while (baseNode.getParent() != null) {
            attr = baseNode.getParentTreeNode().getAttribute();
            if (ExpressionUtils.isNullable(attr)) {
                return true;
            }
            baseNode = baseNode.getParent();
        }
        return false;
    }

    private static boolean isNullable(Attribute<?, ?> attr) {
        if (attr.isCollection()) {
            return true;
        }
        return ((SingularAttribute)attr).isOptional();
    }

    public static FetchType getFetchType(Attribute<?, ?> attr) {
        Class<Basic> annotationType;
        HashSet annotations;
        Member m = attr.getJavaMember();
        if (m instanceof Method) {
            annotations = AnnotationUtils.getAllAnnotations((Method)((Method)m));
        } else if (m instanceof Field) {
            annotations = new HashSet();
            Collections.addAll(annotations, ((Field)m).getAnnotations());
        } else {
            throw new IllegalStateException("Attribute member [" + attr.getName() + "] is neither field nor method");
        }
        switch (attr.getPersistentAttributeType()) {
            case BASIC: {
                annotationType = Basic.class;
                break;
            }
            case ELEMENT_COLLECTION: {
                annotationType = ElementCollection.class;
                break;
            }
            case EMBEDDED: {
                return FetchType.EAGER;
            }
            case MANY_TO_MANY: {
                annotationType = ManyToMany.class;
                break;
            }
            case MANY_TO_ONE: {
                annotationType = ManyToOne.class;
                break;
            }
            case ONE_TO_MANY: {
                annotationType = OneToMany.class;
                break;
            }
            case ONE_TO_ONE: {
                annotationType = OneToOne.class;
                break;
            }
            default: {
                return FetchType.EAGER;
            }
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAssignableFrom(annotationType)) continue;
            try {
                return (FetchType)annotation.annotationType().getMethod("fetch", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return FetchType.EAGER;
    }

    public static boolean isAssociation(Attribute<?, ?> attr) {
        return attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public static boolean containsSubqueryExpression(Expression e) {
        return (Boolean)e.accept((Expression.ResultVisitor)subqueryExpressionDetector);
    }

    public static boolean containsSizeExpression(Expression e) {
        return (Boolean)e.accept((Expression.ResultVisitor)sizeExpressionDetector);
    }

    public static void replaceSubexpression(Expression superExpression, String placeholder, Expression substitute) {
        final AliasReplacementTransformer replacementTransformer = new AliasReplacementTransformer(substitute, placeholder);
        VisitorAdapter transformationVisitor = new VisitorAdapter(){

            public void visit(CompositeExpression expression) {
                super.visit(expression);
                ArrayList<Expression> transformed = new ArrayList<Expression>();
                List expressions = expression.getExpressions();
                int size = expressions.size();
                for (int i = 0; i < size; ++i) {
                    transformed.add(replacementTransformer.transform((Expression)expressions.get(i), null, false));
                }
                expression.getExpressions().clear();
                expression.getExpressions().addAll(transformed);
            }

            public void visit(FunctionExpression expression) {
                super.visit(expression);
                ArrayList<Expression> transformed = new ArrayList<Expression>();
                List expressions = expression.getExpressions();
                int size = expressions.size();
                for (int i = 0; i < size; ++i) {
                    transformed.add(replacementTransformer.transform((Expression)expressions.get(i), null, false));
                }
                expression.setExpressions(transformed);
            }
        };
        superExpression.accept((Expression.Visitor)transformationVisitor);
    }

    public static boolean isSizeFunction(Expression expression) {
        if (expression instanceof FunctionExpression) {
            return ExpressionUtils.isSizeFunction((FunctionExpression)expression);
        }
        return false;
    }

    public static boolean isSizeFunction(FunctionExpression expression) {
        return "SIZE".equalsIgnoreCase(expression.getFunctionName());
    }

    public static boolean isOuterFunction(FunctionExpression e) {
        return "OUTER".equalsIgnoreCase(e.getFunctionName());
    }
}

