/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.GroupByUsableDetectionVisitor;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.expression.AggregateExpression;
import com.blazebit.persistence.impl.expression.ArrayExpression;
import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FooExpression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.impl.expression.LiteralExpression;
import com.blazebit.persistence.impl.expression.NullExpression;
import com.blazebit.persistence.impl.expression.ParameterExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.PropertyExpression;
import com.blazebit.persistence.impl.expression.SimpleCaseExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import java.util.Set;

class GroupByExpressionGatheringVisitor
extends VisitorAdapter {
    private final GroupByUsableDetectionVisitor groupByExpressionGatheringVisitor = new GroupByUsableDetectionVisitor();
    private final ResolvingQueryGenerator queryGenerator;
    private final StringBuilder sb = new StringBuilder();
    private Set<String> expressions;

    public GroupByExpressionGatheringVisitor(Set<String> expressions, ResolvingQueryGenerator queryGenerator) {
        this.expressions = expressions;
        this.queryGenerator = queryGenerator;
        this.queryGenerator.setQueryBuffer(this.sb);
        this.queryGenerator.setConditionalContext(true);
    }

    public Set<String> getExpressions() {
        return this.expressions;
    }

    private boolean handleExpression(Expression expression) {
        if (Boolean.TRUE.equals(expression.accept((Expression.ResultVisitor)this.groupByExpressionGatheringVisitor))) {
            return true;
        }
        this.sb.setLength(0);
        expression.accept((Expression.Visitor)this.queryGenerator);
        this.expressions.add(this.sb.toString());
        return false;
    }

    public void visit(PathExpression expression) {
        this.handleExpression((Expression)expression);
    }

    public void visit(ArrayExpression expression) {
        throw new IllegalArgumentException("At this point array expressions are not allowed anymore!");
    }

    public void visit(PropertyExpression expression) {
        this.handleExpression((Expression)expression);
    }

    public void visit(ParameterExpression expression) {
    }

    public void visit(CompositeExpression expression) {
        if (this.handleExpression((Expression)expression)) {
            // empty if block
        }
    }

    public void visit(FooExpression expression) {
    }

    public void visit(LiteralExpression expression) {
        this.handleExpression((Expression)expression);
    }

    public void visit(NullExpression expression) {
    }

    public void visit(SubqueryExpression expression) {
    }

    public void visit(FunctionExpression expression) {
        if (!(expression instanceof AggregateExpression)) {
            this.handleExpression((Expression)expression);
        }
    }

    public void visit(GeneralCaseExpression expression) {
        super.visit(expression);
        this.handleExpression((Expression)expression);
    }

    public void visit(SimpleCaseExpression expression) {
        super.visit(expression);
        this.handleExpression((Expression)expression);
    }
}

