/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.NodeInfo;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.expression.Expression;
import java.util.LinkedHashSet;
import java.util.Set;

public class GroupByManager
extends AbstractManager {
    private final Set<NodeInfo> groupByInfos = new LinkedHashSet<NodeInfo>();

    GroupByManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager) {
        super(queryGenerator, parameterManager);
    }

    void groupBy(Expression expr) {
        this.groupByInfos.add(new NodeInfo(expr));
        this.registerParameterExpressions(expr);
    }

    void buildGroupByClauses(Set<String> clauses) {
        if (this.groupByInfos.isEmpty()) {
            return;
        }
        boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
        StringBuilder sb = new StringBuilder();
        for (NodeInfo info : this.groupByInfos) {
            sb.setLength(0);
            this.queryGenerator.setQueryBuffer(sb);
            info.getExpression().accept((Expression.Visitor)this.queryGenerator);
            clauses.add(sb.toString());
        }
        this.queryGenerator.setConditionalContext(conditionalContext);
    }

    void buildGroupBy(StringBuilder sb, Set<String> clauses) {
        if (!clauses.isEmpty()) {
            sb.append(" GROUP BY ");
            this.build(sb, clauses);
        }
    }

    void applyTransformer(ExpressionTransformer transformer) {
        for (NodeInfo groupBy : this.groupByInfos) {
            groupBy.setExpression(transformer.transform(groupBy.getExpression(), ClauseType.GROUP_BY, true));
        }
    }

    void acceptVisitor(Expression.Visitor v) {
        for (NodeInfo groupBy : this.groupByInfos) {
            groupBy.getExpression().accept(v);
        }
    }

    boolean hasGroupBys() {
        return this.groupByInfos.size() > 0;
    }

    boolean isEmpty() {
        return this.groupByInfos.isEmpty();
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.groupByInfos != null ? this.groupByInfos.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupByManager other = (GroupByManager)obj;
        return this.groupByInfos == other.groupByInfos || this.groupByInfos != null && this.groupByInfos.equals(other.groupByInfos);
    }
}

