/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.AbortableOnClauseJoinNodeVisitor;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AggregateDetectionVisitor;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.ExternalAliasDereferencingException;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OnClauseJoinNodeVisitor;
import com.blazebit.persistence.impl.PredicateManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.predicate.JoinOnBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.expression.ArrayExpression;
import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.ParameterExpression;
import com.blazebit.persistence.impl.expression.PathElementExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.PropertyExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.predicate.AndPredicate;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;

public class JoinManager
extends AbstractManager {
    private static final Logger LOG = Logger.getLogger(JoinManager.class.getName());
    private List<JoinNode> rootNodes = new ArrayList<JoinNode>(1);
    private final String joinRestrictionKeyword;
    private final AliasManager aliasManager;
    private final Metamodel metamodel;
    private final JoinManager parent;
    private final JoinOnBuilderEndedListener joinOnBuilderListener;
    private SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final Set<JoinNode> renderedJoins = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<JoinNode> markedJoinNodes = Collections.newSetFromMap(new IdentityHashMap());

    JoinManager(MainQuery mainQuery, ResolvingQueryGenerator queryGenerator, AliasManager aliasManager, JoinManager parent, ExpressionFactory expressionFactory) {
        super(queryGenerator, mainQuery.parameterManager);
        this.aliasManager = aliasManager;
        this.metamodel = mainQuery.em.getMetamodel();
        this.parent = parent;
        this.joinRestrictionKeyword = " " + mainQuery.jpaProvider.getOnClause() + " ";
        this.joinOnBuilderListener = new JoinOnBuilderEndedListener();
        this.expressionFactory = expressionFactory;
    }

    String addRoot(EntityType<?> clazz, String rootAlias) {
        if (rootAlias == null) {
            StringBuilder sb = new StringBuilder(clazz.getName());
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String alias = sb.toString();
            rootAlias = this.aliasManager.getAliasInfo(alias) == null ? alias : this.aliasManager.generatePostfixedAlias(alias);
        }
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, true, this.aliasManager);
        JoinNode rootNode = new JoinNode(null, null, rootAliasInfo, null, clazz.getJavaType());
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        return rootAlias;
    }

    void removeRoot() {
        JoinNode rootNode = this.rootNodes.remove(0);
        this.aliasManager.unregisterAliasInfoForBottomLevel(rootNode.getAliasInfo());
    }

    JoinNode getRootNodeOrFail(String string) {
        if (this.rootNodes.size() > 1) {
            throw new IllegalArgumentException(string);
        }
        return this.rootNodes.get(0);
    }

    private JoinNode getRootNode(String alias) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode node = nodes.get(i);
            if (!alias.equals(node.getAliasInfo().getAlias())) continue;
            return node;
        }
        return null;
    }

    List<JoinNode> getRoots() {
        return this.rootNodes;
    }

    boolean hasCollections() {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (!nodes.get(i).hasCollections()) continue;
            return true;
        }
        return false;
    }

    JoinManager getParent() {
        return this.parent;
    }

    void setSubqueryInitFactory(SubqueryInitiatorFactory subqueryInitFactory) {
        this.subqueryInitFactory = subqueryInitFactory;
    }

    void buildClause(StringBuilder sb, Set<ClauseType> clauseExclusions, String aliasPrefix) {
        this.renderedJoins.clear();
        sb.append(" FROM ");
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            JoinNode rootNode = nodes.get(i);
            EntityType type = this.metamodel.entity(rootNode.getPropertyClass());
            sb.append(type.getName()).append(' ');
            if (aliasPrefix != null) {
                sb.append(aliasPrefix);
            }
            sb.append(rootNode.getAliasInfo().getAlias());
            rootNode.registerDependencies();
            this.applyJoins(sb, rootNode.getAliasInfo(), rootNode.getNodes(), clauseExclusions, aliasPrefix);
        }
    }

    void verifyBuilderEnded() {
        this.joinOnBuilderListener.verifyBuilderEnded();
    }

    void acceptVisitor(JoinNodeVisitor v) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            nodes.get(i).accept(v);
        }
    }

    public boolean acceptVisitor(AggregateDetectionVisitor aggregateDetector, boolean stopValue) {
        Boolean stop = stopValue;
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (!stop.equals(nodes.get(i).accept(new AbortableOnClauseJoinNodeVisitor((Expression.ResultVisitor<Boolean>)aggregateDetector, stopValue)))) continue;
            return true;
        }
        return false;
    }

    void applyTransformer(ExpressionTransformer transformer) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            nodes.get(i).accept(new OnClauseJoinNodeVisitor((Expression.Visitor)new PredicateManager.TransformationVisitor(transformer, null)));
        }
    }

    private void renderJoinNode(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node, String aliasPrefix) {
        if (!this.renderedJoins.contains(node)) {
            switch (node.getType()) {
                case INNER: {
                    sb.append(" JOIN ");
                    break;
                }
                case LEFT: {
                    sb.append(" LEFT JOIN ");
                    break;
                }
                case RIGHT: {
                    sb.append(" RIGHT JOIN ");
                }
            }
            if (node.isFetch()) {
                sb.append("FETCH ");
            }
            if (aliasPrefix != null) {
                sb.append(aliasPrefix);
            }
            sb.append(joinBase.getAlias()).append('.').append(node.getParentTreeNode().getRelationName()).append(' ');
            if (aliasPrefix != null) {
                sb.append(aliasPrefix);
            }
            sb.append(node.getAliasInfo().getAlias());
            if (node.getOnPredicate() != null && !node.getOnPredicate().getChildren().isEmpty()) {
                sb.append(this.joinRestrictionKeyword);
                this.queryGenerator.setQueryBuffer(sb);
                boolean conditionalContext = this.queryGenerator.setConditionalContext(true);
                node.getOnPredicate().accept((Expression.Visitor)this.queryGenerator);
                this.queryGenerator.setConditionalContext(conditionalContext);
            }
            this.renderedJoins.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderReverseDependency(StringBuilder sb, JoinNode dependency, String aliasPrefix) {
        if (dependency.getParent() != null) {
            this.renderReverseDependency(sb, dependency.getParent(), aliasPrefix);
            if (!dependency.getDependencies().isEmpty()) {
                this.markedJoinNodes.add(dependency);
                try {
                    for (JoinNode dep : dependency.getDependencies()) {
                        if (this.markedJoinNodes.contains(dep)) {
                            throw new IllegalStateException("Cyclic join dependency detected at absolute path [" + dep.getAliasInfo().getAbsolutePath() + "] with alias [" + dep.getAliasInfo().getAlias() + "]");
                        }
                        this.renderReverseDependency(sb, dep, aliasPrefix);
                    }
                }
                finally {
                    this.markedJoinNodes.remove(dependency);
                }
            }
            this.renderJoinNode(sb, dependency.getParent().getAliasInfo(), dependency, aliasPrefix);
        }
    }

    private void applyJoins(StringBuilder sb, JoinAliasInfo joinBase, Map<String, JoinTreeNode> nodes, Set<ClauseType> clauseExclusions, String aliasPrefix) {
        for (Map.Entry<String, JoinTreeNode> nodeEntry : nodes.entrySet()) {
            JoinTreeNode treeNode = nodeEntry.getValue();
            for (JoinNode node : treeNode.getJoinNodes().values()) {
                if (!clauseExclusions.isEmpty() && clauseExclusions.containsAll(node.getClauseDependencies()) && !node.isCardinalityMandatory()) continue;
                if (!node.getDependencies().isEmpty()) {
                    this.renderReverseDependency(sb, node, aliasPrefix);
                }
                this.renderJoinNode(sb, joinBase, node, aliasPrefix);
                if (node.getNodes().isEmpty()) continue;
                this.applyJoins(sb, node.getAliasInfo(), node.getNodes(), clauseExclusions, aliasPrefix);
            }
        }
    }

    private boolean isExternal(PathExpression path) {
        PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
        String startAlias = firstElem instanceof ArrayExpression ? ((ArrayExpression)firstElem).getBase().toString() : firstElem.toString();
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(startAlias);
        if (aliasInfo == null) {
            return false;
        }
        if (this.parent != null && aliasInfo.getAliasOwner() == this.parent.aliasManager) {
            if (aliasInfo instanceof SelectInfo) {
                throw new ExternalAliasDereferencingException("Start alias [" + startAlias + "] of path [" + path.toString() + "] is external and must not be dereferenced");
            }
            return true;
        }
        if (aliasInfo.getAliasOwner() == this.aliasManager) {
            return false;
        }
        throw new IllegalStateException("Alias [" + aliasInfo.getAlias() + "] originates from an unknown query");
    }

    private boolean isJoinableSelectAlias(PathExpression pathExpr, boolean fromSelect, boolean fromSubquery) {
        boolean singlePathElement = pathExpr.getExpressions().size() == 1;
        String startAlias = ((PathElementExpression)pathExpr.getExpressions().get(0)).toString();
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(startAlias);
        if (aliasInfo == null) {
            return false;
        }
        if (aliasInfo instanceof SelectInfo && !fromSelect && !fromSubquery) {
            if (!singlePathElement) {
                throw new IllegalStateException("Path starting with select alias not allowed");
            }
            return true;
        }
        return false;
    }

    <X> JoinOnBuilder<X> joinOn(X result, String path, String alias, JoinType type, boolean defaultJoin) {
        this.joinOnBuilderListener.joinNode = this.join(path, alias, type, false, defaultJoin);
        return this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }

    JoinNode join(String path, String alias, JoinType type, boolean fetch, boolean defaultJoin) {
        PathExpression expr = this.expressionFactory.createPathExpression(path);
        if (!(expr instanceof PathExpression)) {
            throw new IllegalArgumentException("Join path [" + path + "] is not a path");
        }
        PathExpression pathExpression = expr;
        if (this.isExternal(pathExpression) || this.isJoinableSelectAlias(pathExpression, false, false)) {
            throw new IllegalArgumentException("No external path or select alias allowed in join path");
        }
        List pathElements = pathExpression.getExpressions();
        PathElementExpression elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
        JoinResult result = this.implicitJoin(null, pathExpression, 0, pathElements.size() - 1);
        JoinNode current = result.baseNode;
        if (result.hasField()) {
            throw new IllegalArgumentException("The join path [" + path + "] has a non joinable part [" + result.field + "]");
        }
        if (elementExpr instanceof ArrayExpression) {
            throw new IllegalArgumentException("Array expressions are not allowed!");
        }
        result = this.createOrUpdateNode(current = current == null ? this.getRootNodeOrFail("Could not join path [" + path + "] because it did not use an absolute path but multiple root nodes are available!") : current, elementExpr.toString(), alias, type, false, defaultJoin);
        if (result.hasField()) {
            throw new IllegalArgumentException("The join path [" + path + "] has a non joinable part [" + result.field + "]");
        }
        if (fetch) {
            this.fetchPath(result.baseNode);
        }
        return result.baseNode;
    }

    void implicitJoin(Expression expression, boolean objectLeafAllowed, ClauseType fromClause, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired) {
        this.implicitJoin(expression, objectLeafAllowed, fromClause, fromSubquery, fromSelectAlias, joinRequired, false);
    }

    void implicitJoin(Expression expression, boolean objectLeafAllowed, ClauseType fromClause, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch) {
        block47: {
            block48: {
                block46: {
                    AliasInfo aliasInfo;
                    JoinResult result;
                    JoinResult currentResult;
                    if (!(expression instanceof PathExpression)) break block46;
                    PathExpression pathExpression = (PathExpression)expression;
                    if (this.isJoinableSelectAlias(pathExpression, fromClause == ClauseType.SELECT, fromSubquery)) {
                        String alias = ((PathElementExpression)pathExpression.getExpressions().get(0)).toString();
                        Expression expr = ((SelectInfo)this.aliasManager.getAliasInfo(alias)).getExpression();
                        if (!fromSelectAlias) {
                            this.implicitJoin(expr, true, fromClause, fromSubquery, true, joinRequired);
                        }
                        return;
                    }
                    if (this.isExternal(pathExpression)) {
                        this.parent.implicitJoin((Expression)pathExpression, true, fromClause, true, fromSelectAlias, joinRequired);
                        return;
                    }
                    List pathElements = pathExpression.getExpressions();
                    int pathElementSize = pathElements.size();
                    for (int i = 0; i < pathElementSize; ++i) {
                        PathElementExpression pathElem = (PathElementExpression)pathElements.get(i);
                        if (!(pathElem instanceof ArrayExpression)) continue;
                        this.implicitJoin(((ArrayExpression)pathElem).getIndex(), false, fromClause, fromSubquery, fromSelectAlias, joinRequired);
                    }
                    PathElementExpression elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
                    boolean singleValuedAssociationIdExpression = false;
                    JoinNode current = null;
                    ArrayList<String> resultFields = new ArrayList<String>();
                    JoinNode possibleRoot = this.getRootNode(((PathElementExpression)pathElements.get(0)).toString());
                    int startIndex = 0;
                    if (possibleRoot != null) {
                        startIndex = 1;
                        current = possibleRoot;
                    }
                    if (pathElements.size() > startIndex + 1) {
                        int maybeSingularAssociationIndex = pathElements.size() - 2;
                        int maybeSingularAssociationIdIndex = pathElements.size() - 1;
                        currentResult = this.implicitJoin(current, pathExpression, startIndex, maybeSingularAssociationIndex);
                        current = currentResult.baseNode;
                        if (currentResult.hasField()) {
                            resultFields.addAll(Arrays.asList(currentResult.field.split("\\.")));
                        }
                        if (!(singleValuedAssociationIdExpression = this.isSingleValuedAssociationId(currentResult, pathElements))) {
                            if (currentResult.hasField()) {
                                currentResult = this.createOrUpdateNode(current, currentResult.field + "." + pathElements.get(maybeSingularAssociationIndex), null, null, true, true);
                                current = currentResult.baseNode;
                                currentResult = currentResult.hasField() ? this.implicitJoin(current, pathExpression, startIndex, maybeSingularAssociationIdIndex) : this.implicitJoin(current, pathExpression, maybeSingularAssociationIndex + 1, maybeSingularAssociationIdIndex);
                                resultFields.clear();
                            } else {
                                currentResult = this.implicitJoin(current, pathExpression, maybeSingularAssociationIndex, maybeSingularAssociationIdIndex);
                            }
                            current = currentResult.baseNode;
                            if (currentResult.hasField()) {
                                resultFields.addAll(Arrays.asList(currentResult.field.split("\\.")));
                            }
                        }
                    } else {
                        currentResult = this.implicitJoin(current, pathExpression, startIndex, pathElements.size() - 1);
                        current = currentResult.baseNode;
                        if (currentResult.hasField()) {
                            resultFields.addAll(Arrays.asList(currentResult.field.split("\\.")));
                        }
                    }
                    if (current == null) {
                        if (this.rootNodes.size() > 1) {
                            throw new IllegalArgumentException("Could not join path [" + expression + "] because it did not use an absolute path but multiple root nodes are available!");
                        }
                        current = this.rootNodes.get(0);
                    }
                    if (singleValuedAssociationIdExpression) {
                        JoinTreeNode treeNode;
                        String associationName = ((PathElementExpression)pathElements.get(pathElements.size() - 2)).toString();
                        AliasInfo a = null;
                        if (currentResult.hasField()) {
                            associationName = currentResult.field + "." + associationName;
                        } else {
                            a = this.aliasManager.getAliasInfoForBottomLevel(associationName);
                        }
                        result = a != null ? new JoinResult(((JoinAliasInfo)a).getJoinNode(), elementExpr.toString()) : ((treeNode = current.getNodes().get(associationName)) != null && treeNode.getDefaultNode() != null ? new JoinResult(treeNode.getDefaultNode(), elementExpr.toString()) : new JoinResult(current, associationName + "." + elementExpr.toString()));
                    } else if (elementExpr instanceof ArrayExpression) {
                        AliasInfo aliasInfo2;
                        if (!resultFields.isEmpty()) {
                            throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + StringUtils.join((CharSequence)".", resultFields) + "]");
                        }
                        ArrayExpression arrayExpr = (ArrayExpression)elementExpr;
                        String joinRelationName = arrayExpr.getBase().toString();
                        if (pathElements.size() == 1 && (aliasInfo2 = this.aliasManager.getAliasInfoForBottomLevel(joinRelationName)) != null) {
                            if (aliasInfo2 instanceof SelectInfo) {
                                throw new IllegalArgumentException("Illegal reference to the select alias '" + joinRelationName + "'");
                            }
                            current = ((JoinAliasInfo)aliasInfo2).getJoinNode();
                            this.generateAndApplyOnPredicate(current, arrayExpr);
                        } else {
                            JoinNode matchingNode = this.findNode(current, joinRelationName, arrayExpr);
                            if (matchingNode != null) {
                                current = matchingNode;
                            } else {
                                String joinAlias = this.getJoinAlias(arrayExpr);
                                currentResult = this.createOrUpdateNode(current, joinRelationName, joinAlias, null, true, false);
                                current = currentResult.baseNode;
                                if (currentResult.hasField()) {
                                    throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + currentResult.field + "]");
                                }
                                this.generateAndApplyOnPredicate(current, arrayExpr);
                            }
                        }
                        result = new JoinResult(current, null);
                    } else if (pathElements.size() == 1 && !fromSelectAlias && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(elementExpr.toString())) != null) {
                        if (aliasInfo instanceof SelectInfo) {
                            Expression selectExpr = ((SelectInfo)aliasInfo).getExpression();
                            if (!(selectExpr instanceof PathExpression)) {
                                throw new RuntimeException("The select expression '" + selectExpr.toString() + "' is not a simple path expression! No idea how to implicit join that.");
                            }
                            if (((PathExpression)selectExpr).getBaseNode() == null) {
                                this.implicitJoin(selectExpr, objectLeafAllowed, fromClause, fromSubquery, true, joinRequired);
                            }
                            PathExpression selectPathExpr = (PathExpression)selectExpr;
                            result = new JoinResult((JoinNode)selectPathExpr.getBaseNode(), selectPathExpr.getField());
                        } else {
                            result = new JoinResult(((JoinAliasInfo)aliasInfo).getJoinNode(), null);
                        }
                    } else if (!pathExpression.isUsedInCollectionFunction()) {
                        if (resultFields.isEmpty()) {
                            result = this.implicitJoinSingle(current, elementExpr.toString(), objectLeafAllowed, joinRequired);
                        } else {
                            resultFields.add(elementExpr.toString());
                            if (!this.validPath(current.getPropertyClass(), resultFields)) {
                                throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + StringUtils.join((CharSequence)".", resultFields) + "]");
                            }
                            result = this.implicitJoinSingle(current, StringUtils.join((CharSequence)".", resultFields), objectLeafAllowed, joinRequired);
                        }
                    } else if (resultFields.isEmpty()) {
                        result = new JoinResult(current, elementExpr.toString());
                    } else {
                        resultFields.add(elementExpr.toString());
                        if (!this.validPath(current.getPropertyClass(), resultFields)) {
                            throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + StringUtils.join((CharSequence)".", resultFields) + "]");
                        }
                        result = new JoinResult(current, StringUtils.join((CharSequence)".", resultFields));
                    }
                    if (fetch) {
                        this.fetchPath(result.baseNode);
                    }
                    if (fromClause != null) {
                        this.updateClauseDependencies(result.baseNode, fromClause);
                    }
                    pathExpression.setBaseNode((Object)result.baseNode);
                    pathExpression.setField(result.field);
                    break block47;
                }
                if (!(expression instanceof CompositeExpression)) break block48;
                List expressions = ((CompositeExpression)expression).getExpressions();
                int size = expressions.size();
                for (int i = 0; i < size; ++i) {
                    this.implicitJoin((Expression)expressions.get(i), objectLeafAllowed, fromClause, fromSubquery, fromSelectAlias, joinRequired);
                }
                break block47;
            }
            if (!(expression instanceof FunctionExpression)) break block47;
            List expressions = ((FunctionExpression)expression).getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                this.implicitJoin((Expression)expressions.get(i), objectLeafAllowed, fromClause, fromSubquery, fromSelectAlias, joinRequired);
            }
        }
    }

    private boolean validPath(Class<?> currentClass, List<String> pathElements) {
        for (int i = 0; i < pathElements.size(); ++i) {
            String element = pathElements.get(i);
            ManagedType t = this.metamodel.managedType(currentClass);
            Set<Attribute<?, ?>> attributes = JpaUtils.getAttributesPolymorphic(this.metamodel, t, element);
            if (attributes.isEmpty()) {
                return false;
            }
            if (attributes.size() != 1) {
                for (Attribute<?, ?> attr : attributes) {
                    if (this.validPath(attr.getJavaType(), pathElements.subList(i, pathElements.size() - 1))) continue;
                    return false;
                }
                return true;
            }
            currentClass = attributes.iterator().next().getJavaType();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSingleValuedAssociationId(JoinResult joinResult, List<PathElementExpression> pathElements) {
        Set<Attribute<?, ?>> maybeSingularAssociationAttributes;
        ManagedType baseType;
        int maybeSingularAssociationIdIndex;
        block11: {
            JoinNode parent = joinResult.baseNode;
            int maybeSingularAssociationIndex = pathElements.size() - 2;
            maybeSingularAssociationIdIndex = pathElements.size() - 1;
            String maybeSingularAssociationName = this.getSimpleName(pathElements.get(maybeSingularAssociationIndex));
            if (parent == null) {
                AliasInfo a = this.aliasManager.getAliasInfo(maybeSingularAssociationName);
                if (a == null) {
                    baseType = this.metamodel.managedType(this.getRootNodeOrFail("Ambiguous join path [" + maybeSingularAssociationName + "] because of multiple root nodes!").getPropertyClass());
                    maybeSingularAssociationAttributes = JpaUtils.getAttributesPolymorphic(this.metamodel, baseType, maybeSingularAssociationName);
                    break block11;
                } else {
                    if (!(a instanceof JoinAliasInfo)) {
                        throw new IllegalArgumentException("Can't dereference select alias in the expression!");
                    }
                    return false;
                }
            }
            Class<?> parentClass = parent.getPropertyClass();
            baseType = this.metamodel.managedType(parentClass);
            if (joinResult.hasField()) {
                Attribute fieldAttribute = JpaUtils.getAttribute(baseType, joinResult.field);
                baseType = this.metamodel.managedType(fieldAttribute.getJavaType());
            }
            maybeSingularAssociationAttributes = JpaUtils.getAttributesPolymorphic(this.metamodel, baseType, maybeSingularAssociationName);
        }
        if (maybeSingularAssociationAttributes.isEmpty()) {
            return false;
        }
        Iterator<Attribute<?, ?>> i$ = maybeSingularAssociationAttributes.iterator();
        block0: while (true) {
            Attribute<?, ?> maybeSingularAssociationId;
            String maybeSingularAssociationIdName;
            if (!i$.hasNext()) {
                return true;
            }
            Attribute<?, ?> maybeSingularAssociation = i$.next();
            if (maybeSingularAssociation.getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE) {
                return false;
            }
            Class<?> maybeSingularAssociationClass = JpaUtils.resolveFieldClass(baseType.getJavaType(), maybeSingularAssociation);
            ManagedType maybeSingularAssociationType = this.metamodel.managedType(maybeSingularAssociationClass);
            Set<Attribute<?, ?>> maybeSingularAssociationIdAttributes = JpaUtils.getAttributesPolymorphic(this.metamodel, maybeSingularAssociationType, maybeSingularAssociationIdName = this.getSimpleName(pathElements.get(maybeSingularAssociationIdIndex)));
            if (maybeSingularAssociationIdAttributes.isEmpty()) {
                return false;
            }
            Iterator<Attribute<?, ?>> i$2 = maybeSingularAssociationIdAttributes.iterator();
            do {
                if (!i$2.hasNext()) continue block0;
                maybeSingularAssociationId = i$2.next();
                if (maybeSingularAssociationId instanceof SingularAttribute) continue;
                return false;
            } while (((SingularAttribute)maybeSingularAssociationId).isId());
            break;
        }
        return false;
    }

    private String getSimpleName(PathElementExpression element) {
        if (element == null) {
            return null;
        }
        if (element instanceof ArrayExpression) {
            return ((ArrayExpression)element).getBase().getProperty();
        }
        return element.toString();
    }

    private String getJoinAlias(ArrayExpression expr) {
        StringBuilder sb = new StringBuilder(expr.getBase().toString());
        Expression indexExpr = expr.getIndex();
        if (indexExpr instanceof ParameterExpression) {
            ParameterExpression indexParamExpr = (ParameterExpression)indexExpr;
            sb.append('_');
            sb.append(indexParamExpr.getName());
        } else if (indexExpr instanceof PathExpression) {
            PathExpression indexPathExpr = (PathExpression)indexExpr;
            sb.append('_');
            sb.append(((JoinNode)indexPathExpr.getBaseNode()).getAliasInfo().getAlias());
            if (indexPathExpr.getField() != null) {
                sb.append('_');
                sb.append(indexPathExpr.getField().replaceAll("\\.", "_"));
            }
        } else {
            sb.append('_');
            sb.append(indexExpr.toString().replaceAll("\\.", "_"));
        }
        return sb.toString();
    }

    private EqPredicate getArrayExpressionPredicate(JoinNode joinNode, ArrayExpression arrayExpr) {
        PathExpression keyPath = new PathExpression(new ArrayList(), true);
        keyPath.getExpressions().add(new PropertyExpression(joinNode.getAliasInfo().getAlias()));
        keyPath.setBaseNode((Object)joinNode);
        FunctionExpression keyExpression = new FunctionExpression("KEY", Arrays.asList(keyPath));
        return new EqPredicate((Expression)keyExpression, arrayExpr.getIndex());
    }

    private void registerDependencies(final JoinNode joinNode, Predicate onPredicate) {
        onPredicate.accept((Expression.Visitor)new VisitorAdapter(){

            public void visit(PathExpression pathExpr) {
                if (pathExpr.getBaseNode() != joinNode) {
                    joinNode.getDependencies().add((JoinNode)pathExpr.getBaseNode());
                }
            }
        });
    }

    private void generateAndApplyOnPredicate(JoinNode joinNode, ArrayExpression arrayExpr) {
        EqPredicate valueKeyFilterPredicate = this.getArrayExpressionPredicate(joinNode, arrayExpr);
        if (joinNode.getOnPredicate() != null) {
            AndPredicate currentPred = joinNode.getOnPredicate();
            if (!this.findPredicate(currentPred, (Predicate)valueKeyFilterPredicate)) {
                currentPred.getChildren().add(valueKeyFilterPredicate);
                this.registerDependencies(joinNode, (Predicate)currentPred);
            }
        } else {
            AndPredicate onAndPredicate = new AndPredicate();
            onAndPredicate.getChildren().add(valueKeyFilterPredicate);
            joinNode.setOnPredicate(onAndPredicate);
            this.registerDependencies(joinNode, (Predicate)onAndPredicate);
        }
    }

    private JoinResult implicitJoin(JoinNode current, PathExpression pathExpression, int start, int end) {
        List pathElements = pathExpression.getExpressions();
        ArrayList<String> resultFields = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            AliasInfo aliasInfo;
            PathElementExpression elementExpr = (PathElementExpression)pathElements.get(i);
            if (elementExpr instanceof ArrayExpression) {
                ArrayExpression arrayExpr;
                String joinRelationName;
                JoinNode matchingNode = this.findNode(current = current == null ? this.getRootNodeOrFail("Ambiguous join path [" + joinRelationName + "] because of multiple root nodes!") : current, joinRelationName = (arrayExpr = (ArrayExpression)elementExpr).getBase().toString(), arrayExpr);
                if (matchingNode != null) {
                    current = matchingNode;
                    continue;
                }
                if (i == 0 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(joinRelationName)) != null) {
                    if (aliasInfo instanceof SelectInfo) {
                        throw new IllegalArgumentException("Illegal reference to the select alias '" + joinRelationName + "'");
                    }
                    current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    this.generateAndApplyOnPredicate(current, arrayExpr);
                    continue;
                }
                String joinAlias = this.getJoinAlias(arrayExpr);
                JoinResult result = this.createOrUpdateNode(current, joinRelationName, joinAlias, null, true, false);
                current = result.baseNode;
                if (result.hasField()) {
                    resultFields.add(result.field);
                }
                this.generateAndApplyOnPredicate(current, arrayExpr);
                continue;
            }
            if (pathElements.size() == 1 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(elementExpr.toString())) != null) {
                if (aliasInfo instanceof SelectInfo) {
                    throw new IllegalArgumentException("Can't dereference a select alias");
                }
                current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                continue;
            }
            if (!resultFields.isEmpty()) {
                resultFields.add(elementExpr.toString());
                JoinResult currentResult = this.createOrUpdateNode(current, StringUtils.join((CharSequence)".", resultFields), null, null, true, true);
                current = currentResult.baseNode;
                resultFields.clear();
                if (!currentResult.hasField()) continue;
                resultFields.add(currentResult.field);
                continue;
            }
            JoinResult result = this.implicitJoinSingle(current, elementExpr.toString());
            current = result.baseNode;
            if (!result.hasField()) continue;
            resultFields.add(result.field);
        }
        if (resultFields.isEmpty()) {
            return new JoinResult(current, null);
        }
        return new JoinResult(current, StringUtils.join((CharSequence)".", resultFields));
    }

    private JoinResult implicitJoinSingle(JoinNode baseNode, String attributeName) {
        AliasInfo aliasInfo;
        if (baseNode == null && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(attributeName)) != null && aliasInfo instanceof JoinAliasInfo) {
            return new JoinResult(((JoinAliasInfo)aliasInfo).getJoinNode(), null);
        }
        if (baseNode == null) {
            baseNode = this.getRootNodeOrFail("Ambiguous join path [" + attributeName + "] because of multiple root nodes!");
        }
        return this.createOrUpdateNode(baseNode, attributeName, null, null, true, true);
    }

    private JoinResult implicitJoinSingle(JoinNode baseNode, String attributeName, boolean objectLeafAllowed, boolean joinRequired) {
        String field;
        JoinNode newBaseNode;
        if (objectLeafAllowed) {
            Class<?> baseNodeType = baseNode.getPropertyClass();
            Attribute<?, ?> attr = this.getSimpleAttributeForImplicitJoining(this.metamodel.managedType(baseNodeType), attributeName);
            if (attr == null) {
                throw new IllegalArgumentException("Field with name " + attributeName + " was not found within class " + baseNodeType.getName());
            }
            if (joinRequired || attr.isCollection()) {
                JoinResult newBaseNodeResult = this.implicitJoinSingle(baseNode, attributeName);
                newBaseNode = newBaseNodeResult.baseNode;
                field = newBaseNode != baseNode ? null : attributeName;
            } else {
                newBaseNode = baseNode;
                field = attributeName;
            }
        } else {
            Class<?> baseNodeType = baseNode.getPropertyClass();
            Attribute<?, ?> attr = this.getSimpleAttributeForImplicitJoining(this.metamodel.managedType(baseNodeType), attributeName);
            if (attr == null) {
                throw new IllegalArgumentException("Field with name " + attributeName + " was not found within class " + baseNodeType.getName());
            }
            if (JpaUtils.isJoinable(attr)) {
                throw new IllegalArgumentException("No object leaf allowed but " + attributeName + " is an object leaf");
            }
            newBaseNode = baseNode;
            field = attributeName;
        }
        return new JoinResult(newBaseNode, field);
    }

    private Attribute<?, ?> getSimpleAttributeForImplicitJoining(ManagedType<?> type, String attributeName) {
        if (attributeName.indexOf(46) < 0) {
            Attribute<?, ?> attr = this.getPolymorphicSimpleAttributeForImplicitJoining(type, attributeName);
            return attr;
        }
        String[] attributeParts = attributeName.split("\\.");
        Attribute<?, ?> attr = this.getPolymorphicSimpleAttributeForImplicitJoining(type, attributeParts[0]);
        for (int i = 1; i < attributeParts.length; ++i) {
            type = this.metamodel.managedType(JpaUtils.resolveFieldClass(type.getJavaType(), attr));
            attr = this.getPolymorphicAttributeForJoining(type, attributeParts[i]);
        }
        return attr;
    }

    private Attribute<?, ?> getPolymorphicSimpleAttributeForImplicitJoining(ManagedType<?> type, String attributeName) {
        Set<Attribute<?, ?>> resolvedAttributes = JpaUtils.getAttributesPolymorphic(this.metamodel, type, attributeName);
        Iterator<Attribute<?, ?>> iter = resolvedAttributes.iterator();
        if (resolvedAttributes.size() > 1) {
            Attribute<?, ?> simpleAttribute = null;
            HashSet amiguousAttributes = new HashSet();
            for (Attribute<?, ?> attribute : resolvedAttributes) {
                if (JpaUtils.isJoinable(attribute)) {
                    amiguousAttributes.add(attribute);
                    continue;
                }
                simpleAttribute = attribute;
            }
            if (simpleAttribute == null) {
                return null;
            }
            for (Attribute attribute : amiguousAttributes) {
                LOG.warning("The attribute [" + attributeName + "] of the class [" + attribute.getDeclaringType().getJavaType().getName() + "] is ambiguous for polymorphic implicit joining on the type [" + type.getJavaType().getName() + "]");
            }
            return simpleAttribute;
        }
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    private void updateClauseDependencies(JoinNode baseNode, ClauseType clauseDependency) {
        for (JoinNode current = baseNode; current != null; current = current.getParent()) {
            for (JoinNode dependency : current.getDependencies()) {
                this.updateClauseDependencies(dependency, clauseDependency);
            }
            current.getClauseDependencies().add(clauseDependency);
        }
    }

    private JoinType getModelAwareType(JoinNode baseNode, Attribute<?, ?> attr) {
        if (baseNode.getType() == JoinType.LEFT) {
            return JoinType.LEFT;
        }
        if (!(attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE && attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE || ((SingularAttribute)attr).isOptional())) {
            return JoinType.INNER;
        }
        return JoinType.LEFT;
    }

    private AttributeJoinResult getAttributeForJoining(ManagedType<?> type, String attributeName) {
        if (attributeName.indexOf(46) < 0) {
            Attribute<?, ?> attr = this.getPolymorphicAttributeForJoining(type, attributeName);
            return new AttributeJoinResult(attr, type.getJavaType());
        }
        String[] attributeParts = attributeName.split("\\.");
        Attribute<?, ?> attr = this.getPolymorphicAttributeForJoining(type, attributeParts[0]);
        for (int i = 1; i < attributeParts.length; ++i) {
            type = this.metamodel.managedType(JpaUtils.resolveFieldClass(type.getJavaType(), attr));
            attr = this.getPolymorphicAttributeForJoining(type, attributeParts[i]);
        }
        return new AttributeJoinResult(attr, type.getJavaType());
    }

    private Attribute<?, ?> getPolymorphicAttributeForJoining(ManagedType<?> type, String attributeName) {
        Set<Attribute<?, ?>> resolvedAttributes = JpaUtils.getAttributesPolymorphic(this.metamodel, type, attributeName);
        Iterator<Attribute<?, ?>> iter = resolvedAttributes.iterator();
        if (resolvedAttributes.size() > 1) {
            Attribute<?, ?> joinableAttribute = null;
            Attribute<?, ?> attr = null;
            while (iter.hasNext()) {
                attr = iter.next();
                if (!JpaUtils.isJoinable(attr)) continue;
                if (joinableAttribute != null && !joinableAttribute.getJavaType().equals(attr.getJavaType())) {
                    throw new IllegalArgumentException("Multiple joinable attributes with the name [" + attributeName + "] but different java types in the types [" + joinableAttribute.getDeclaringType().getJavaType().getName() + "] and [" + attr.getDeclaringType().getJavaType().getName() + "] found!");
                }
                joinableAttribute = attr;
            }
            if (joinableAttribute != null) {
                return joinableAttribute;
            }
            return attr;
        }
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    private JoinResult createOrUpdateNode(JoinNode baseNode, String joinRelationName, String alias, JoinType joinType, boolean implicit, boolean defaultJoin) {
        Class<?> baseNodeType = baseNode.getPropertyClass();
        ManagedType type = this.metamodel.managedType(baseNodeType);
        AttributeJoinResult attrJoinResult = this.getAttributeForJoining(type, joinRelationName);
        Attribute attr = attrJoinResult.attribute;
        if (attr == null) {
            throw new IllegalArgumentException("Field with name " + joinRelationName + " was not found within class " + baseNodeType.getName());
        }
        Class<?> resolvedFieldClass = JpaUtils.resolveFieldClass(attrJoinResult.containingClass, attr);
        if (!JpaUtils.isJoinable(attr)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Field with name " + joinRelationName + " of class " + baseNodeType.getName() + " is parseable and therefore it has not to be fetched explicitly.");
            }
            return new JoinResult(baseNode, joinRelationName);
        }
        if (implicit) {
            String aliasToUse = alias == null ? attr.getName() : alias;
            alias = this.aliasManager.generatePostfixedAlias(aliasToUse);
        }
        if (joinType == null) {
            joinType = this.getModelAwareType(baseNode, attr);
        }
        JoinNode newNode = this.getOrCreate(baseNode, joinRelationName, resolvedFieldClass, alias, joinType, "Ambiguous implicit join", implicit, defaultJoin, attr);
        return new JoinResult(newNode, null);
    }

    private void checkAliasIsAvailable(String alias, String currentJoinPath, String errorMessage) {
        AliasInfo oldAliasInfo = this.aliasManager.getAliasInfoForBottomLevel(alias);
        if (oldAliasInfo instanceof SelectInfo) {
            throw new IllegalStateException("Alias [" + oldAliasInfo.getAlias() + "] already used as select alias");
        }
        JoinAliasInfo oldJoinAliasInfo = (JoinAliasInfo)oldAliasInfo;
        if (oldJoinAliasInfo != null) {
            if (!oldJoinAliasInfo.getAbsolutePath().equals(currentJoinPath)) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new RuntimeException("Probably a programming error if this happens. An alias[" + alias + "] for the same join path[" + currentJoinPath + "] is available but the join node is not!");
        }
    }

    private JoinNode getOrCreate(JoinNode baseNode, String joinRelationName, Class<?> joinRelationClass, String alias, JoinType type, String errorMessage, boolean implicit, boolean defaultJoin, Attribute<?, ?> attribute) {
        JoinTreeNode treeNode = baseNode.getOrCreateTreeNode(joinRelationName, attribute);
        JoinNode node = treeNode.getJoinNode(alias, defaultJoin);
        String currentJoinPath = baseNode.getAliasInfo().getAbsolutePath() + "." + joinRelationName;
        if (node == null) {
            this.checkAliasIsAvailable(alias, currentJoinPath, errorMessage);
            if (implicit && this.aliasManager.getAliasInfo(alias) != null) {
                alias = this.aliasManager.generatePostfixedAlias(alias);
            }
            JoinAliasInfo newAliasInfo = new JoinAliasInfo(alias, currentJoinPath, implicit, this.aliasManager);
            this.aliasManager.registerAliasInfo(newAliasInfo);
            node = new JoinNode(baseNode, treeNode, newAliasInfo, type, joinRelationClass);
            newAliasInfo.setJoinNode(node);
            treeNode.addJoinNode(node, defaultJoin);
        } else {
            JoinAliasInfo nodeAliasInfo = node.getAliasInfo();
            if (!alias.equals(nodeAliasInfo.getAlias())) {
                if (nodeAliasInfo.isImplicit() && !implicit) {
                    this.aliasManager.unregisterAliasInfoForBottomLevel(nodeAliasInfo);
                    nodeAliasInfo.setAlias(alias);
                    nodeAliasInfo.setImplicit(false);
                    node.setType(type);
                    this.aliasManager.registerAliasInfo(nodeAliasInfo);
                } else if (!nodeAliasInfo.isImplicit() && !implicit) {
                    throw new IllegalArgumentException("Alias conflict [" + nodeAliasInfo.getAlias() + "=" + nodeAliasInfo.getAbsolutePath() + ", " + alias + "=" + currentJoinPath + "]");
                }
            }
        }
        return node;
    }

    private JoinNode findNode(JoinNode baseNode, String joinRelationName, ArrayExpression arrayExpression) {
        JoinTreeNode treeNode = baseNode.getNodes().get(joinRelationName);
        if (treeNode == null) {
            return null;
        }
        for (JoinNode node : treeNode.getJoinNodes().values()) {
            EqPredicate pred = this.getArrayExpressionPredicate(node, arrayExpression);
            AndPredicate andPredicate = node.getOnPredicate();
            if (!this.findPredicate(andPredicate, (Predicate)pred)) continue;
            return node;
        }
        return null;
    }

    private boolean findPredicate(AndPredicate andPredicate, Predicate pred) {
        if (andPredicate != null) {
            List children = andPredicate.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (!pred.equals(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void fetchPath(JoinNode node) {
        for (JoinNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            currentNode.setFetch(true);
            currentNode.getClauseDependencies().add(ClauseType.SELECT);
        }
    }

    private class JoinOnBuilderEndedListener
    extends PredicateBuilderEndedListenerImpl {
        private JoinNode joinNode;

        private JoinOnBuilderEndedListener() {
        }

        @Override
        public void onBuilderEnded(PredicateBuilder builder) {
            super.onBuilderEnded(builder);
            Predicate predicate = builder.getPredicate();
            predicate.accept((Expression.Visitor)new VisitorAdapter(){
                private boolean isKeyFunction;

                public void visit(FunctionExpression expression) {
                    boolean old = this.isKeyFunction;
                    this.isKeyFunction = "KEY".equalsIgnoreCase(expression.getFunctionName());
                    super.visit(expression);
                    this.isKeyFunction = old;
                }

                public void visit(PathExpression expression) {
                    expression.setCollectionKeyPath(this.isKeyFunction);
                    super.visit(expression);
                }
            });
            this.joinNode.setOnPredicate((AndPredicate)predicate);
        }
    }

    private static class JoinResult {
        final JoinNode baseNode;
        final String field;

        public JoinResult(JoinNode baseNode, String field) {
            this.baseNode = baseNode;
            this.field = field;
        }

        private boolean hasField() {
            return this.field != null && !this.field.isEmpty();
        }
    }

    private static class AttributeJoinResult {
        private final Attribute<?, ?> attribute;
        private final Class<?> containingClass;

        public AttributeJoinResult(Attribute<?, ?> attribute, Class<?> containingClass) {
            this.attribute = attribute;
            this.containingClass = containingClass;
        }
    }
}

