/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.impl.AbortableResultJoinNodeVisitor;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.predicate.AndPredicate;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.persistence.metamodel.Attribute;

public class JoinNode {
    private JoinAliasInfo aliasInfo;
    private JoinType type = JoinType.LEFT;
    private boolean fetch = false;
    private final EnumSet<ClauseType> clauseDependencies = EnumSet.noneOf(ClauseType.class);
    private final JoinNode parent;
    private final JoinTreeNode parentTreeNode;
    private final Class<?> propertyClass;
    private final Map<String, JoinTreeNode> nodes = new TreeMap<String, JoinTreeNode>();
    private final Set<JoinNode> dependencies = new HashSet<JoinNode>();
    private AndPredicate onPredicate;
    private boolean dirty = true;
    private boolean cardinalityMandatory;

    public JoinNode(JoinNode parent, JoinTreeNode parentTreeNode, JoinAliasInfo aliasInfo, JoinType type, Class<?> propertyClass) {
        this.parent = parent;
        this.parentTreeNode = parentTreeNode;
        this.aliasInfo = aliasInfo;
        this.type = type;
        this.propertyClass = propertyClass;
        this.onUpdate(null);
    }

    private void onUpdate(StateChange stateChange) {
        if (this.cardinalityMandatory && stateChange != StateChange.JOIN_TYPE) {
            return;
        }
        this.dirty = true;
        if (this.parent != null) {
            this.parent.onUpdate(StateChange.CHILD);
        }
    }

    public boolean isCardinalityMandatory() {
        if (this.dirty) {
            this.updateCardinalityMandatory();
            this.dirty = false;
        }
        return this.cardinalityMandatory;
    }

    private void updateCardinalityMandatory() {
        boolean computedMandatory = false;
        if (this.type == JoinType.INNER) {
            if (this.parentTreeNode.isOptional() || !this.isEmptyCondition()) {
                computedMandatory = true;
            }
        } else if (this.type == JoinType.LEFT) {
            if (!this.isEmptyCondition() && !this.isArrayExpressionCondition()) {
                computedMandatory = true;
            }
            block0: for (Map.Entry<String, JoinTreeNode> nodeEntry : this.nodes.entrySet()) {
                JoinTreeNode treeNode = nodeEntry.getValue();
                for (JoinNode childNode : treeNode.getJoinNodes().values()) {
                    if (!childNode.isCardinalityMandatory()) continue;
                    computedMandatory = true;
                    break block0;
                }
            }
        }
        if (computedMandatory != this.cardinalityMandatory) {
            this.cardinalityMandatory = computedMandatory;
        }
    }

    private boolean isEmptyCondition() {
        return this.onPredicate == null || this.onPredicate.getChildren().isEmpty();
    }

    private boolean isArrayExpressionCondition() {
        if (this.onPredicate == null || this.onPredicate.getChildren().size() != 1) {
            return false;
        }
        Predicate predicate = (Predicate)this.onPredicate.getChildren().get(0);
        if (!(predicate instanceof EqPredicate)) {
            return false;
        }
        EqPredicate eqPredicate = (EqPredicate)predicate;
        Expression left = eqPredicate.getLeft();
        if (!(left instanceof FunctionExpression)) {
            return false;
        }
        FunctionExpression keyExpression = (FunctionExpression)left;
        if (!"KEY".equalsIgnoreCase(keyExpression.getFunctionName())) {
            return false;
        }
        Expression keyContentExpression = (Expression)keyExpression.getExpressions().get(0);
        if (!(keyContentExpression instanceof PathExpression)) {
            return false;
        }
        PathExpression keyPath = (PathExpression)keyContentExpression;
        return this.equals(keyPath.getBaseNode());
    }

    public void registerDependencies() {
        if (this.onPredicate != null) {
            this.onPredicate.accept((Expression.Visitor)new VisitorAdapter(){

                public void visit(PathExpression pathExpr) {
                    if (pathExpr.getBaseNode() != JoinNode.this && pathExpr.getBaseNode() != null) {
                        JoinNode.this.dependencies.add((JoinNode)pathExpr.getBaseNode());
                    }
                }
            });
        }
    }

    public void accept(JoinNodeVisitor visitor) {
        visitor.visit(this);
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                joinNode.accept(visitor);
            }
        }
    }

    public <T> T accept(AbortableResultJoinNodeVisitor<T> visitor) {
        Object result = visitor.visit(this);
        if (visitor.getStopValue().equals(result)) {
            return result;
        }
        for (JoinTreeNode treeNode : this.nodes.values()) {
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                result = joinNode.accept(visitor);
                if (!visitor.getStopValue().equals(result)) continue;
                return result;
            }
        }
        return null;
    }

    public EnumSet<ClauseType> getClauseDependencies() {
        return this.clauseDependencies;
    }

    public JoinTreeNode getParentTreeNode() {
        return this.parentTreeNode;
    }

    public JoinNode getParent() {
        return this.parent;
    }

    public JoinAliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public void setAliasInfo(JoinAliasInfo aliasInfo) {
        this.aliasInfo = aliasInfo;
    }

    public JoinType getType() {
        return this.type;
    }

    public void setType(JoinType type) {
        this.type = type;
        this.onUpdate(StateChange.JOIN_TYPE);
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public Map<String, JoinTreeNode> getNodes() {
        return this.nodes;
    }

    public JoinTreeNode getOrCreateTreeNode(String joinRelationName, Attribute<?, ?> attribute) {
        JoinTreeNode node = this.nodes.get(joinRelationName);
        if (node == null) {
            node = new JoinTreeNode(joinRelationName, attribute);
            this.nodes.put(joinRelationName, node);
        }
        return node;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public AndPredicate getOnPredicate() {
        return this.onPredicate;
    }

    public void setOnPredicate(AndPredicate onPredicate) {
        this.onPredicate = onPredicate;
        this.onUpdate(StateChange.ON_PREDICATE);
    }

    public Set<JoinNode> getDependencies() {
        return this.dependencies;
    }

    public boolean hasCollections() {
        Stack<JoinTreeNode> stack = new Stack<JoinTreeNode>();
        stack.addAll(this.nodes.values());
        while (!stack.isEmpty()) {
            JoinTreeNode treeNode = (JoinTreeNode)stack.pop();
            if (treeNode.isCollection()) {
                return true;
            }
            for (JoinNode joinNode : treeNode.getJoinNodes().values()) {
                stack.addAll(joinNode.nodes.values());
            }
        }
        return false;
    }

    private static enum StateChange {
        JOIN_TYPE,
        ON_PREDICATE,
        CHILD;

    }
}

