/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.InPredicate;
import com.blazebit.persistence.impl.predicate.IsEmptyPredicate;
import com.blazebit.persistence.impl.predicate.IsNullPredicate;
import com.blazebit.persistence.impl.predicate.MemberOfPredicate;

public class JoinVisitor
extends VisitorAdapter {
    private final JoinManager joinManager;
    private boolean joinRequired;
    private boolean joinWithObjectLeafAllowed = true;
    private ClauseType fromClause;

    public JoinVisitor(JoinManager joinManager) {
        this.joinManager = joinManager;
        this.joinRequired = true;
    }

    public ClauseType getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(ClauseType fromClause) {
        this.fromClause = fromClause;
    }

    public void visit(PathExpression expression) {
        this.joinManager.implicitJoin((Expression)expression, this.joinWithObjectLeafAllowed, this.fromClause, false, false, this.joinRequired);
    }

    public boolean isJoinRequired() {
        return this.joinRequired;
    }

    public void setJoinRequired(boolean joinRequired) {
        this.joinRequired = joinRequired;
    }

    public void visit(FunctionExpression expression) {
        if (!ExpressionUtils.isOuterFunction(expression)) {
            super.visit(expression);
        }
    }

    public void visit(SubqueryExpression expression) {
        ((AbstractCommonQueryBuilder)expression.getSubquery()).applyImplicitJoins();
    }

    public boolean isJoinWithObjectLeafAllowed() {
        return this.joinWithObjectLeafAllowed;
    }

    public void setJoinWithObjectLeafAllowed(boolean joinWithObjectLeafAllowed) {
        this.joinWithObjectLeafAllowed = joinWithObjectLeafAllowed;
    }

    public void visit(EqPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getLeft().accept((Expression.Visitor)this);
        predicate.getRight().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    public void visit(IsNullPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getExpression().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    public void visit(IsEmptyPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getExpression().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    public void visit(MemberOfPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getLeft().accept((Expression.Visitor)this);
        predicate.getRight().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }

    public void visit(InPredicate predicate) {
        boolean original = this.joinRequired;
        this.joinRequired = false;
        predicate.getLeft().accept((Expression.Visitor)this);
        predicate.getRight().accept((Expression.Visitor)this);
        this.joinRequired = original;
    }
}

