/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;

public final class JpaUtils {
    public static <T> Attribute<? super T, ?> getAttribute(ManagedType<T> type, String attributeName) {
        try {
            return type.getAttribute(attributeName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Set<Attribute<?, ?>> getAttributesPolymorphic(Metamodel metamodel, ManagedType<?> type, String attributeName) {
        Object attr = JpaUtils.getAttribute(type, attributeName);
        if (attr != null) {
            HashSet set = new HashSet(1);
            set.add((Attribute<?, ?>)attr);
            return set;
        }
        Class javaType = type.getJavaType();
        HashSet resolvedAttributes = new HashSet();
        for (ManagedType subType : metamodel.getManagedTypes()) {
            if (!javaType.isAssignableFrom(subType.getJavaType()) || javaType == subType.getJavaType() || (attr = JpaUtils.getAttribute(subType, attributeName)) == null) continue;
            resolvedAttributes.add((Attribute<?, ?>)attr);
        }
        return resolvedAttributes;
    }

    public static boolean isMap(Attribute<?, ?> attr) {
        return attr instanceof MapAttribute;
    }

    public static boolean isOptional(Attribute<?, ?> attribute) {
        if (attribute instanceof SingularAttribute) {
            return ((SingularAttribute)attribute).isOptional();
        }
        return true;
    }

    public static Attribute<?, ?> getIdAttribute(EntityType<?> entityType) {
        return entityType.getId(entityType.getIdType().getJavaType());
    }

    public static boolean isJoinable(Attribute<?, ?> attr) {
        return attr.isCollection() || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public static Class<?> resolveType(Class<?> concreteClass, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return JpaUtils.resolveType(concreteClass, ((TypeVariable)type).getBounds()[0]);
        }
        throw new IllegalArgumentException("Unsupported type for resolving: " + type);
    }

    private static Class<?> getConcreterClass(Class<?> class1, Class<?> class2) {
        if (class1.isAssignableFrom(class2)) {
            return class2;
        }
        if (class2.isAssignableFrom(class1)) {
            return class1;
        }
        throw new IllegalArgumentException("The classes [" + class1.getName() + ", " + class2.getName() + "] are not in a inheritance relationship, so there is no concreter class!");
    }

    public static Class<?> resolveFieldClass(Class<?> baseClass, Attribute<?, ?> attr) {
        Class fieldClass;
        Class<?> resolverBaseClass = JpaUtils.getConcreterClass(baseClass, attr.getDeclaringType().getJavaType());
        if (attr.isCollection()) {
            PluralAttribute collectionAttr = (PluralAttribute)attr;
            if (collectionAttr.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                if (attr.getJavaMember() instanceof Method) {
                    Method method = (Method)attr.getJavaMember();
                    fieldClass = ReflectionUtils.getResolvedMethodReturnTypeArguments(resolverBaseClass, (Method)method)[1];
                    if (fieldClass == null) {
                        fieldClass = JpaUtils.resolveType(resolverBaseClass, ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[1]);
                    }
                } else {
                    Field field = (Field)attr.getJavaMember();
                    fieldClass = ReflectionUtils.getResolvedFieldTypeArguments(resolverBaseClass, (Field)field)[1];
                    if (fieldClass == null) {
                        fieldClass = JpaUtils.resolveType(resolverBaseClass, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1]);
                    }
                }
            } else if (attr.getJavaMember() instanceof Method) {
                Method method = (Method)attr.getJavaMember();
                fieldClass = ReflectionUtils.getResolvedMethodReturnTypeArguments(resolverBaseClass, (Method)method)[0];
                if (fieldClass == null) {
                    fieldClass = JpaUtils.resolveType(resolverBaseClass, ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]);
                }
            } else {
                Field field = (Field)attr.getJavaMember();
                fieldClass = ReflectionUtils.getResolvedFieldTypeArguments(resolverBaseClass, (Field)field)[0];
                if (fieldClass == null) {
                    fieldClass = JpaUtils.resolveType(resolverBaseClass, ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
                }
            }
        } else if (attr.getJavaMember() instanceof Method) {
            Method method = (Method)attr.getJavaMember();
            fieldClass = ReflectionUtils.getResolvedMethodReturnType(resolverBaseClass, (Method)method);
            if (fieldClass == null) {
                fieldClass = JpaUtils.resolveType(resolverBaseClass, method.getGenericReturnType());
            }
        } else {
            Field field = (Field)attr.getJavaMember();
            fieldClass = ReflectionUtils.getResolvedFieldType(resolverBaseClass, (Field)field);
            if (fieldClass == null) {
                fieldClass = JpaUtils.resolveType(resolverBaseClass, field.getGenericType());
            }
        }
        return fieldClass;
    }
}

