/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.expression.Expression;

public final class OrderByExpression {
    private final boolean ascending;
    private final boolean nullFirst;
    private final Expression expression;
    private final boolean nullable;
    private final boolean unique;

    public OrderByExpression(boolean ascending, boolean nullFirst, Expression expression, boolean nullable, boolean unique) {
        this.ascending = ascending;
        this.nullFirst = nullFirst;
        this.expression = expression;
        this.nullable = nullable;
        this.unique = unique;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    public boolean isNullFirst() {
        return this.nullFirst;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.ascending ? 1 : 0);
        hash = 37 * hash + (this.nullFirst ? 1 : 0);
        hash = 37 * hash + (this.expression != null ? this.expression.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrderByExpression other = (OrderByExpression)obj;
        if (this.ascending != other.ascending) {
            return false;
        }
        if (this.nullFirst != other.nullFirst) {
            return false;
        }
        return this.expression == other.expression || this.expression != null && this.expression.equals(other.expression);
    }
}

