/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.GroupByUsableDetectionVisitor;
import com.blazebit.persistence.impl.NodeInfo;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.jpaprovider.JpaProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.metamodel.Metamodel;

public class OrderByManager
extends AbstractManager {
    private final List<OrderByInfo> orderByInfos = new ArrayList<OrderByInfo>();
    private final AliasManager aliasManager;
    private final JpaProvider jpaProvider;

    OrderByManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, AliasManager aliasManager, JpaProvider jpaProvider) {
        super(queryGenerator, parameterManager);
        this.aliasManager = aliasManager;
        this.jpaProvider = jpaProvider;
    }

    Set<String> getOrderBySelectAliases() {
        if (this.orderByInfos.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> orderBySelectAliases = new HashSet<String>();
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpression().toString();
            if (!this.aliasManager.isSelectAlias(potentialSelectAlias)) continue;
            orderBySelectAliases.add(potentialSelectAlias);
        }
        return orderBySelectAliases;
    }

    List<OrderByExpression> getOrderByExpressions(Metamodel metamodel) {
        if (this.orderByInfos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OrderByExpression> realExpressions = new ArrayList<OrderByExpression>(this.orderByInfos.size());
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderByInfo.getExpression().toString());
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
            } else {
                expr = orderByInfo.getExpression();
            }
            boolean nullable = ExpressionUtils.isNullable(metamodel, expr);
            boolean unique = ExpressionUtils.isUnique(metamodel, expr);
            realExpressions.add(new OrderByExpression(orderByInfo.ascending, orderByInfo.nullFirst, expr, nullable, unique));
        }
        return realExpressions;
    }

    boolean hasOrderBys() {
        return this.orderByInfos.size() > 0;
    }

    int getOrderByCount() {
        return this.orderByInfos.size();
    }

    boolean hasComplexOrderBys() {
        if (this.orderByInfos.isEmpty()) {
            return false;
        }
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo;
            OrderByInfo orderByInfo = infos.get(i);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderByInfo.getExpression().toString());
            if (aliasInfo == null || !(aliasInfo instanceof SelectInfo) || (selectInfo = (SelectInfo)aliasInfo).getExpression() instanceof PathExpression) continue;
            return true;
        }
        return false;
    }

    void orderBy(Expression expr, boolean ascending, boolean nullFirst) {
        this.orderByInfos.add(new OrderByInfo(expr, ascending, nullFirst));
        this.registerParameterExpressions(expr);
    }

    void acceptVisitor(Expression.Visitor v) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            orderByInfo.getExpression().accept(v);
        }
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v, X stopValue) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            if (!stopValue.equals(orderByInfo.getExpression().accept(v))) continue;
            return stopValue;
        }
        return null;
    }

    void applyTransformer(ExpressionTransformer transformer) {
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            orderByInfo.setExpression(transformer.transform(orderByInfo.getExpression(), ClauseType.ORDER_BY, true));
        }
    }

    void buildSelectClauses(StringBuilder sb, boolean allClauses) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        this.queryGenerator.setQueryBuffer(sb);
        boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpression().toString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                if (!allClauses && selectInfo.getExpression() instanceof PathExpression) continue;
                sb.append(", ");
                selectInfo.getExpression().accept((Expression.Visitor)this.queryGenerator);
                sb.append(" AS ").append(potentialSelectAlias);
                continue;
            }
            if (!allClauses) continue;
            sb.append(", ");
            orderByInfo.getExpression().accept((Expression.Visitor)this.queryGenerator);
        }
        this.queryGenerator.setConditionalContext(conditionalContext);
    }

    void buildGroupByClauses(Set<String> clauses) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
        StringBuilder sb = new StringBuilder();
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            Expression expr;
            OrderByInfo orderByInfo = infos.get(i);
            String potentialSelectAlias = orderByInfo.getExpression().toString();
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(potentialSelectAlias);
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                SelectInfo selectInfo = (SelectInfo)aliasInfo;
                expr = selectInfo.getExpression();
            } else {
                expr = orderByInfo.getExpression();
            }
            GroupByUsableDetectionVisitor groupByUsableDetectionVisitor = new GroupByUsableDetectionVisitor();
            if (Boolean.TRUE.equals(expr.accept((Expression.ResultVisitor)groupByUsableDetectionVisitor))) continue;
            sb.setLength(0);
            this.queryGenerator.setQueryBuffer(sb);
            expr.accept((Expression.Visitor)this.queryGenerator);
            clauses.add(sb.toString());
        }
        this.queryGenerator.setConditionalContext(conditionalContext);
    }

    void buildOrderBy(StringBuilder sb, boolean inverseOrder, boolean resolveSelectAliases) {
        if (this.orderByInfos.isEmpty()) {
            return;
        }
        this.queryGenerator.setQueryBuffer(sb);
        sb.append(" ORDER BY ");
        boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
        List<OrderByInfo> infos = this.orderByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            this.applyOrderBy(sb, infos.get(i), inverseOrder, resolveSelectAliases);
        }
        this.queryGenerator.setConditionalContext(conditionalContext);
    }

    private void applyOrderBy(StringBuilder sb, OrderByInfo orderBy, boolean inverseOrder, boolean resolveSelectAliases) {
        if (this.jpaProvider.supportsNullPrecedenceExpression()) {
            if (resolveSelectAliases) {
                AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderBy.getExpression().toString());
                if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                    ((SelectInfo)aliasInfo).getExpression().accept((Expression.Visitor)this.queryGenerator);
                } else {
                    orderBy.getExpression().accept((Expression.Visitor)this.queryGenerator);
                }
            } else {
                orderBy.getExpression().accept((Expression.Visitor)this.queryGenerator);
            }
            if (orderBy.ascending == inverseOrder) {
                sb.append(" DESC");
            } else {
                sb.append(" ASC");
            }
            if (orderBy.nullFirst == inverseOrder) {
                sb.append(" NULLS LAST");
            } else {
                sb.append(" NULLS FIRST");
            }
        } else {
            String expression;
            String resolvedExpression;
            StringBuilder expressionSb = new StringBuilder();
            this.queryGenerator.setQueryBuffer(expressionSb);
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(orderBy.getExpression().toString());
            if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
                ((SelectInfo)aliasInfo).getExpression().accept((Expression.Visitor)this.queryGenerator);
                resolvedExpression = expressionSb.toString();
            } else {
                resolvedExpression = null;
            }
            if (resolveSelectAliases && resolvedExpression != null) {
                expression = resolvedExpression;
            } else {
                expressionSb.setLength(0);
                orderBy.getExpression().accept((Expression.Visitor)this.queryGenerator);
                expression = expressionSb.toString();
            }
            String order = orderBy.ascending == inverseOrder ? "DESC" : "ASC";
            String nulls = orderBy.nullFirst == inverseOrder ? "LAST" : "FIRST";
            this.jpaProvider.renderNullPrecedence(sb, expression, resolvedExpression, order, nulls);
        }
    }

    private static class OrderByInfo
    extends NodeInfo {
        private boolean ascending;
        private boolean nullFirst;

        public OrderByInfo(Expression expression, boolean ascending, boolean nullFirst) {
            super(expression);
            this.ascending = ascending;
            this.nullFirst = nullFirst;
        }
    }
}

