/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.expression.CompositeExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import java.util.ArrayList;
import java.util.List;

public class OuterFunctionTransformer
implements ExpressionTransformer {
    private final JoinManager joinManager;

    public OuterFunctionTransformer(JoinManager joinManager) {
        this.joinManager = joinManager;
    }

    @Override
    public Expression transform(Expression original, ClauseType fromClause, boolean joinRequired) {
        if (original instanceof CompositeExpression) {
            CompositeExpression compExpr = (CompositeExpression)original;
            CompositeExpression transformed = new CompositeExpression(new ArrayList());
            List expressions = compExpr.getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                transformed.getExpressions().add(this.transform((Expression)expressions.get(i), fromClause, joinRequired));
            }
            return transformed;
        }
        if (original instanceof FunctionExpression && !ExpressionUtils.isOuterFunction((FunctionExpression)original)) {
            FunctionExpression func = (FunctionExpression)original;
            ArrayList<Expression> transformed = new ArrayList<Expression>();
            List expressions = func.getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                transformed.add(this.transform((Expression)expressions.get(i), fromClause, joinRequired));
            }
            func.setExpressions(transformed);
            return func;
        }
        if (!(original instanceof FunctionExpression)) {
            return original;
        }
        PathExpression path = (PathExpression)((FunctionExpression)original).getExpressions().get(0);
        if (this.joinManager.getParent() != null) {
            this.joinManager.getParent().implicitJoin((Expression)path, true, fromClause, false, true, joinRequired, false);
        }
        return original;
    }
}

