/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PagedList;
import java.util.ArrayList;
import java.util.Collection;

public class PagedListImpl<T>
extends ArrayList<T>
implements PagedList<T> {
    private static final long serialVersionUID = 1L;
    private final KeysetPage keyset;
    private final long totalSize;
    private final int page;
    private final int totalPages;
    private final int firstResult;
    private final int maxResults;

    public PagedListImpl(KeysetPage keyset, long totalSize, int firstResult, int maxResults) {
        this.keyset = keyset;
        this.totalSize = totalSize;
        this.page = (int)Math.floor((double)(firstResult == -1 ? 0 : firstResult) * 1.0 / (double)maxResults) + 1;
        this.totalPages = (int)Math.ceil((double)totalSize * 1.0 / (double)maxResults);
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    PagedListImpl(Collection<? extends T> collection, KeysetPage keyset, long totalSize, int firstResult, int maxResults) {
        super(collection);
        this.keyset = keyset;
        this.totalSize = totalSize;
        this.page = (int)Math.floor((double)(firstResult == -1 ? 0 : firstResult) * 1.0 / (double)maxResults) + 1;
        this.totalPages = (int)Math.ceil((double)totalSize * 1.0 / (double)maxResults);
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    public int getSize() {
        return this.size();
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getPage() {
        return this.page;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public KeysetPage getKeysetPage() {
        return this.keyset;
    }
}

