/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.IllegalSubqueryDetector;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.OrderByExpression;
import com.blazebit.persistence.impl.PagedListImpl;
import com.blazebit.persistence.impl.builder.object.DelegatingKeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.builder.object.KeysetExtractionObjectBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPageImpl;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import com.blazebit.persistence.impl.keyset.SimpleKeysetLink;
import com.blazebit.persistence.spi.QueryTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.metamodel.Metamodel;

public class PaginatedCriteriaBuilderImpl<T>
extends AbstractFullQueryBuilder<T, PaginatedCriteriaBuilder<T>, PaginatedCriteriaBuilderImpl<T>, PaginatedCriteriaBuilderImpl<T>, BaseFinalSetOperationBuilderImpl<T, ?, ?>>
implements PaginatedCriteriaBuilder<T> {
    private static final String ENTITY_PAGE_POSITION_PARAMETER_NAME = "_entityPagePositionParameter";
    private static final String PAGE_POSITION_ID_QUERY_ALIAS_PREFIX = "_page_position_";
    private boolean keysetExtraction;
    private final KeysetPage keysetPage;
    private boolean needsCheck = true;
    private final Object entityId;
    private int firstResult;
    private int firstRow;
    private final int pageSize;
    private boolean needsNewIdList;
    private final KeysetMode keysetMode;
    private String cachedCountQueryString;
    private String cachedIdQueryString;

    public PaginatedCriteriaBuilderImpl(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> baseBuilder, boolean keysetExtraction, KeysetPage keysetPage, Object entityId, int pageSize) {
        super(baseBuilder);
        if (this.firstRow < 0) {
            throw new IllegalArgumentException("firstRow may not be negative");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize may not be zero or negative");
        }
        this.keysetExtraction = keysetExtraction;
        this.keysetPage = keysetPage;
        this.firstResult = -1;
        this.firstRow = -1;
        this.entityId = entityId;
        this.pageSize = pageSize;
        this.keysetMode = KeysetMode.NONE;
        this.keysetManager.setKeysetLink(null);
    }

    public PaginatedCriteriaBuilderImpl(AbstractFullQueryBuilder<T, ? extends FullQueryBuilder<T, ?>, ?, ?, ?> baseBuilder, boolean keysetExtraction, KeysetPage keysetPage, int firstRow, int pageSize) {
        super(baseBuilder);
        if (firstRow < 0) {
            throw new IllegalArgumentException("firstRow may not be negative");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize may not be zero or negative");
        }
        this.keysetExtraction = keysetExtraction;
        this.keysetPage = keysetPage;
        this.firstResult = firstRow;
        this.firstRow = firstRow;
        this.entityId = null;
        this.pageSize = pageSize;
        this.keysetMode = KeysetPaginationHelper.getKeysetMode(keysetPage, firstRow, pageSize);
        if (this.keysetMode == KeysetMode.NONE) {
            this.keysetManager.setKeysetLink(null);
        } else if (this.keysetMode == KeysetMode.NEXT) {
            this.keysetManager.setKeysetLink(new SimpleKeysetLink(keysetPage.getHighest(), this.keysetMode));
        } else {
            this.keysetManager.setKeysetLink(new SimpleKeysetLink(keysetPage.getLowest(), this.keysetMode));
        }
    }

    public PaginatedCriteriaBuilder<T> withKeysetExtraction(boolean keysetExtraction) {
        this.keysetExtraction = keysetExtraction;
        return this;
    }

    public boolean isKeysetExtraction() {
        return this.keysetExtraction;
    }

    @Override
    public PagedList<T> getResultList() {
        long totalSize;
        this.prepareAndCheck();
        String countQueryString = this.getPageCountQueryString0();
        if (this.entityId == null) {
            TypedQuery countQuery = this.em.createQuery(countQueryString, Long.class);
            this.parameterizeQuery((Query)countQuery);
            totalSize = (Long)countQuery.getSingleResult();
        } else {
            TypedQuery countQuery = this.em.createQuery(countQueryString, Object[].class);
            this.parameterizeQuery((Query)countQuery);
            Object[] result = (Object[])countQuery.getSingleResult();
            totalSize = (Long)result[0];
            if (result[1] == null) {
                this.firstResult = -1;
                this.firstRow = 0;
            } else {
                int position = ((Long)result[1]).intValue() - 1;
                this.firstRow = position == 0 ? 0 : position - position % this.pageSize;
                this.firstResult = this.firstRow;
            }
        }
        if (totalSize == 0L) {
            return new PagedListImpl(null, totalSize, this.firstResult, this.pageSize);
        }
        if (!this.joinManager.hasCollections()) {
            return this.getResultListViaObjectQuery(totalSize);
        }
        return this.getResultListViaIdQuery(totalSize);
    }

    public String getPageCountQueryString() {
        this.prepareAndCheck();
        return this.getPageCountQueryString0();
    }

    private String getPageCountQueryString0() {
        if (this.cachedCountQueryString == null) {
            this.cachedCountQueryString = this.getPageCountQueryString1();
        }
        return this.cachedCountQueryString;
    }

    public String getPageIdQueryString() {
        this.prepareAndCheck();
        return this.getPageIdQueryString0();
    }

    private String getPageIdQueryString0() {
        if (this.cachedIdQueryString == null) {
            this.cachedIdQueryString = this.getPageIdQueryString1();
        }
        return this.cachedIdQueryString;
    }

    @Override
    public String getQueryString() {
        this.prepareAndCheck();
        return this.getQueryString0();
    }

    @Override
    protected String getQueryString0() {
        if (this.cachedQueryString == null) {
            this.cachedQueryString = !this.joinManager.hasCollections() ? this.getObjectQueryString1() : this.getQueryString1();
        }
        return this.cachedQueryString;
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.cachedCountQueryString = null;
        this.cachedIdQueryString = null;
    }

    @Override
    protected void prepareAndCheck() {
        if (!this.needsCheck) {
            return;
        }
        this.verifyBuilderEnded();
        if (!this.orderByManager.hasOrderBys()) {
            throw new IllegalStateException("Pagination requires at least one order by item!");
        }
        this.applyImplicitJoins();
        this.applyExpressionTransformers();
        Metamodel m = this.em.getMetamodel();
        List<OrderByExpression> orderByExpressions = this.orderByManager.getOrderByExpressions(m);
        if (!orderByExpressions.get(orderByExpressions.size() - 1).isUnique()) {
            throw new IllegalStateException("The last order by item must be unique!");
        }
        if (this.keysetManager.hasKeyset()) {
            this.keysetManager.initialize(orderByExpressions);
        }
        this.needsNewIdList = this.keysetExtraction || this.orderByManager.hasComplexOrderBys();
        this.needsCheck = false;
    }

    private PagedList<T> getResultListViaObjectQuery(long totalSize) {
        String queryString = this.getQueryString0();
        Class expectedResultType = this.keysetExtraction ? Object[].class : this.selectManager.getExpectedQueryResultType();
        TypedQuery query = this.em.createQuery(queryString, expectedResultType).setMaxResults(this.pageSize);
        if (this.keysetMode == KeysetMode.NONE) {
            query.setFirstResult(this.firstRow);
        }
        KeysetExtractionObjectBuilder objectBuilder = null;
        ObjectBuilder transformerObjectBuilder = this.selectManager.getSelectObjectBuilder();
        if (this.keysetExtraction) {
            int keysetSize = this.orderByManager.getOrderByCount();
            objectBuilder = transformerObjectBuilder == null ? new KeysetExtractionObjectBuilder(keysetSize) : new DelegatingKeysetExtractionObjectBuilder(transformerObjectBuilder, keysetSize);
            transformerObjectBuilder = objectBuilder;
        }
        if (transformerObjectBuilder != null) {
            for (QueryTransformer transformer : this.cbf.getQueryTransformers()) {
                query = transformer.transformQuery(query, transformerObjectBuilder);
            }
        }
        this.parameterizeQuery((Query)query);
        List result = query.getResultList();
        if (result.isEmpty()) {
            KeysetPage newKeysetPage = null;
            if (this.keysetMode == KeysetMode.NEXT) {
                newKeysetPage = this.keysetPage;
            }
            return new PagedListImpl(newKeysetPage, totalSize, this.firstResult, this.pageSize);
        }
        KeysetPageImpl newKeyset = null;
        if (this.keysetExtraction) {
            Serializable[] lowest = objectBuilder.getLowest();
            Serializable[] highest = objectBuilder.getHighest();
            newKeyset = new KeysetPageImpl(this.firstRow, this.pageSize, lowest, highest);
        }
        PagedListImpl pagedResultList = new PagedListImpl(result, newKeyset, totalSize, this.firstResult, this.pageSize);
        return pagedResultList;
    }

    private PagedList<T> getResultListViaIdQuery(long totalSize) {
        String idQueryString = this.getPageIdQueryString0();
        Query idQuery = this.em.createQuery(idQueryString).setMaxResults(this.pageSize);
        if (this.keysetMode == KeysetMode.NONE) {
            idQuery.setFirstResult(this.firstRow);
        }
        this.parameterizeQuery(idQuery);
        ArrayList<Object> ids = idQuery.getResultList();
        if (ids.isEmpty()) {
            KeysetPage newKeysetPage = null;
            if (this.keysetMode == KeysetMode.NEXT) {
                newKeysetPage = this.keysetPage;
            }
            return new PagedListImpl(newKeysetPage, totalSize, this.firstResult, this.pageSize);
        }
        Serializable[] lowest = null;
        Serializable[] highest = null;
        if (this.needsNewIdList) {
            if (this.keysetExtraction) {
                lowest = KeysetPaginationHelper.extractKey((Object[])ids.get(0), 1);
                highest = KeysetPaginationHelper.extractKey((Object[])ids.get(ids.size() - 1), 1);
            }
            ArrayList<Object> newIds = new ArrayList<Object>(ids.size());
            for (int i = 0; i < ids.size(); ++i) {
                newIds.add(((Object[])ids.get(i))[0]);
            }
            ids = newIds;
        }
        this.parameterManager.addParameterMapping("ids", ids);
        KeysetPageImpl newKeyset = null;
        if (this.keysetExtraction) {
            newKeyset = new KeysetPageImpl(this.firstRow, this.pageSize, lowest, highest);
        }
        List<T> queryResultList = this.getQueryResultList();
        PagedListImpl<T> pagedResultList = new PagedListImpl<T>(queryResultList, newKeyset, totalSize, this.firstResult, this.pageSize);
        return pagedResultList;
    }

    private List<T> getQueryResultList() {
        TypedQuery query = this.em.createQuery(this.getQueryString0(), this.selectManager.getExpectedQueryResultType());
        if (this.selectManager.getSelectObjectBuilder() != null) {
            query = this.transformQuery(query);
        }
        this.parameterizeQuery((Query)query);
        return query.getResultList();
    }

    private String getPageCountQueryString1() {
        StringBuilder sbSelectFrom = new StringBuilder();
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaUtils.getIdAttribute(this.em.getMetamodel().entity(rootNode.getPropertyClass())).getName();
        String rootAlias = rootNode.getAliasInfo().getAlias();
        String idClause = rootAlias + '.' + idName;
        sbSelectFrom.append("SELECT COUNT(DISTINCT ").append(idClause).append(')');
        if (this.entityId != null) {
            this.parameterManager.addParameterMapping(ENTITY_PAGE_POSITION_PARAMETER_NAME, this.entityId);
            sbSelectFrom.append(", ");
            sbSelectFrom.append(this.jpaProvider.getCustomFunctionInvocation("PAGE_POSITION", 2));
            sbSelectFrom.append('(');
            this.appendSimplePageIdQueryString(sbSelectFrom);
            sbSelectFrom.append("),");
            sbSelectFrom.append(':').append(ENTITY_PAGE_POSITION_PARAMETER_NAME);
            sbSelectFrom.append(")");
        }
        this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.ORDER_BY, ClauseType.SELECT), null);
        this.whereManager.buildClause(sbSelectFrom);
        return sbSelectFrom.toString();
    }

    private String appendSimplePageIdQueryString(StringBuilder sbSelectFrom) {
        this.queryGenerator.setAliasPrefix(PAGE_POSITION_ID_QUERY_ALIAS_PREFIX);
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaUtils.getIdAttribute(this.em.getMetamodel().entity(rootNode.getPropertyClass())).getName();
        String rootAlias = rootNode.getAliasInfo().getAlias();
        StringBuilder idClause = new StringBuilder(PAGE_POSITION_ID_QUERY_ALIAS_PREFIX).append(rootAlias).append('.').append(idName);
        sbSelectFrom.append("SELECT ").append((CharSequence)idClause);
        this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.SELECT), PAGE_POSITION_ID_QUERY_ALIAS_PREFIX);
        this.whereManager.buildClause(sbSelectFrom);
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        clauses.add(idClause.toString());
        this.orderByManager.buildGroupByClauses(clauses);
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        boolean inverseOrder = false;
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, true);
        this.queryGenerator.setAliasPrefix(null);
        return sbSelectFrom.toString();
    }

    private String getPageIdQueryString1() {
        StringBuilder sbSelectFrom = new StringBuilder();
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaUtils.getIdAttribute(this.em.getMetamodel().entity(rootNode.getPropertyClass())).getName();
        String rootAlias = rootNode.getAliasInfo().getAlias();
        StringBuilder idClause = new StringBuilder(rootAlias).append('.').append(idName);
        sbSelectFrom.append("SELECT ").append((CharSequence)idClause);
        if (this.needsNewIdList) {
            this.orderByManager.buildSelectClauses(sbSelectFrom, this.keysetExtraction);
        }
        this.joinManager.buildClause(sbSelectFrom, EnumSet.of(ClauseType.SELECT), null);
        if (this.keysetMode == KeysetMode.NONE) {
            this.whereManager.buildClause(sbSelectFrom);
        } else {
            sbSelectFrom.append(" WHERE ");
            this.keysetManager.buildKeysetPredicate(sbSelectFrom);
            if (this.whereManager.hasPredicates()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom);
            }
        }
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        clauses.add(idClause.toString());
        this.orderByManager.buildGroupByClauses(clauses);
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        boolean inverseOrder = this.keysetMode == KeysetMode.PREVIOUS;
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, !this.needsNewIdList);
        this.orderByManager.acceptVisitor((Expression.Visitor)new IllegalSubqueryDetector(this.aliasManager));
        return sbSelectFrom.toString();
    }

    @Override
    protected String getQueryString1() {
        StringBuilder sbSelectFrom = new StringBuilder();
        JoinNode rootNode = this.joinManager.getRootNodeOrFail("Paginated criteria builders do not support multiple from clause elements!");
        String idName = JpaUtils.getIdAttribute(this.em.getMetamodel().entity(rootNode.getPropertyClass())).getName();
        String rootAlias = rootNode.getAliasInfo().getAlias();
        this.selectManager.buildSelect(sbSelectFrom);
        this.joinManager.buildClause(sbSelectFrom, EnumSet.complementOf(EnumSet.of(ClauseType.SELECT, ClauseType.ORDER_BY)), null);
        sbSelectFrom.append(" WHERE ").append(rootAlias).append('.').append(idName).append(" IN :").append("ids").append("");
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        this.groupByManager.buildGroupByClauses(clauses);
        if (this.hasGroupBy) {
            this.selectManager.buildGroupByClauses(this.em.getMetamodel(), clauses);
            this.havingManager.buildGroupByClauses(clauses);
            this.orderByManager.buildGroupByClauses(clauses);
        }
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.havingManager.buildClause(sbSelectFrom);
        this.queryGenerator.setResolveSelectAliases(false);
        this.orderByManager.buildOrderBy(sbSelectFrom, false, false);
        this.queryGenerator.setResolveSelectAliases(true);
        return sbSelectFrom.toString();
    }

    private String getObjectQueryString1() {
        StringBuilder sbSelectFrom = new StringBuilder();
        this.selectManager.buildSelect(sbSelectFrom);
        if (this.keysetExtraction) {
            this.orderByManager.buildSelectClauses(sbSelectFrom, true);
        }
        this.joinManager.buildClause(sbSelectFrom, EnumSet.noneOf(ClauseType.class), null);
        if (this.keysetMode == KeysetMode.NONE) {
            this.whereManager.buildClause(sbSelectFrom);
        } else {
            sbSelectFrom.append(" WHERE ");
            this.keysetManager.buildKeysetPredicate(sbSelectFrom);
            if (this.whereManager.hasPredicates()) {
                sbSelectFrom.append(" AND ");
                this.whereManager.buildClausePredicate(sbSelectFrom);
            }
        }
        LinkedHashSet<String> clauses = new LinkedHashSet<String>();
        this.groupByManager.buildGroupByClauses(clauses);
        if (this.hasGroupBy) {
            this.selectManager.buildGroupByClauses(this.em.getMetamodel(), clauses);
            this.havingManager.buildGroupByClauses(clauses);
            this.orderByManager.buildGroupByClauses(clauses);
        }
        this.groupByManager.buildGroupBy(sbSelectFrom, clauses);
        this.havingManager.buildClause(sbSelectFrom);
        boolean inverseOrder = this.keysetMode == KeysetMode.PREVIOUS;
        this.orderByManager.buildOrderBy(sbSelectFrom, inverseOrder, false);
        this.orderByManager.acceptVisitor((Expression.Visitor)new IllegalSubqueryDetector(this.aliasManager));
        return sbSelectFrom.toString();
    }

    @Override
    public PaginatedCriteriaBuilder<T> distinct() {
        throw new IllegalStateException("Calling distinct() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public PaginatedCriteriaBuilder<T> groupBy(String ... paths) {
        throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public PaginatedCriteriaBuilder<T> groupBy(String expression) {
        throw new IllegalStateException("Calling groupBy() on a PaginatedCriteriaBuilder is not allowed.");
    }

    @Override
    public <Y> SelectObjectBuilder<PaginatedCriteriaBuilder<Y>> selectNew(Class<Y> clazz) {
        return super.selectNew(clazz);
    }

    public <Y> PaginatedCriteriaBuilder<Y> selectNew(ObjectBuilder<Y> builder) {
        return (PaginatedCriteriaBuilder)super.selectNew(builder);
    }
}

