/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.expression.ParameterExpression;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;

public class ParameterManager {
    private static final String prefix = "param_";
    private int counter;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private static final Object REGISTERED_PLACEHOLDER = new Object();

    public Parameter<?> getParameter(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (!this.containsParameter(parameterName)) {
            return null;
        }
        Object value = this.getParameterValue(parameterName);
        return new ParameterImpl(value == null ? null : value.getClass(), parameterName);
    }

    public Set<? extends Parameter<?>> getParameters() {
        HashSet result = new HashSet();
        for (Map.Entry<String, Object> paramEntry : this.parameters.entrySet()) {
            Class<?> paramClass = paramEntry.getValue() == null || paramEntry.getValue() == REGISTERED_PLACEHOLDER ? null : paramEntry.getValue().getClass();
            result.add(new ParameterImpl(paramClass, paramEntry.getKey()));
        }
        return result;
    }

    public boolean containsParameter(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        return this.parameters.containsKey(parameterName);
    }

    public boolean isParameterSet(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        return this.parameters.containsKey(parameterName) && this.parameters.get(parameterName) != REGISTERED_PLACEHOLDER;
    }

    public Object getParameterValue(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        Object o = this.parameters.get(parameterName);
        return o == REGISTERED_PLACEHOLDER ? null : o;
    }

    public ParameterExpression addParameterExpression(Object o) {
        String name = this.addParameter(o);
        return new ParameterExpression(name, o);
    }

    public String addParameter(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        String name = prefix + this.counter++;
        this.parameters.put(name, o);
        return name;
    }

    public void addParameterMapping(String parameterName, Object o) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        this.parameters.put(parameterName, o);
    }

    public void registerParameterName(String parameterName) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (!this.parameters.containsKey(parameterName)) {
            this.parameters.put(parameterName, REGISTERED_PLACEHOLDER);
        }
    }

    public void satisfyParameter(String parameterName, Object parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName");
        }
        if (!this.parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException(String.format("Parameter name \"%s\" does not exist", parameterName));
        }
        this.parameters.put(parameterName, parameterValue);
    }

    static class TemporalDateParameterWrapper {
        private final Date value;
        private final TemporalType type;

        public TemporalDateParameterWrapper(Date value, TemporalType type) {
            this.value = value;
            this.type = type;
        }

        public Date getValue() {
            return this.value;
        }

        public TemporalType getType() {
            return this.type;
        }
    }

    static class TemporalCalendarParameterWrapper {
        private final Calendar value;
        private final TemporalType type;

        public TemporalCalendarParameterWrapper(Calendar value, TemporalType type) {
            this.value = value;
            this.type = type;
        }

        public Calendar getValue() {
            return this.value;
        }

        public TemporalType getType() {
            return this.type;
        }
    }

    private class ParameterImpl<T>
    implements Parameter<T> {
        private final Class<T> paramClass;
        private final String paramName;

        public ParameterImpl(Class<T> paramClass, String paramName) {
            this.paramClass = paramClass;
            this.paramName = paramName;
        }

        public String getName() {
            return this.paramName;
        }

        public Integer getPosition() {
            return null;
        }

        public Class<T> getParameterType() {
            return this.paramClass;
        }
    }
}

