/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.CaseExpressionBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.RootPredicate;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.VisitorAdapter;
import com.blazebit.persistence.impl.predicate.BetweenPredicate;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.ExistsPredicate;
import com.blazebit.persistence.impl.predicate.GePredicate;
import com.blazebit.persistence.impl.predicate.GtPredicate;
import com.blazebit.persistence.impl.predicate.InPredicate;
import com.blazebit.persistence.impl.predicate.IsEmptyPredicate;
import com.blazebit.persistence.impl.predicate.IsNullPredicate;
import com.blazebit.persistence.impl.predicate.LePredicate;
import com.blazebit.persistence.impl.predicate.LikePredicate;
import com.blazebit.persistence.impl.predicate.LtPredicate;
import com.blazebit.persistence.impl.predicate.MemberOfPredicate;
import com.blazebit.persistence.impl.predicate.NotPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;

public abstract class PredicateManager<T>
extends AbstractManager {
    protected final SubqueryInitiatorFactory subqueryInitFactory;
    protected final RootPredicate rootPredicate;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<T>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<T>>();
    private SubqueryBuilderListenerImpl<T> rightSubqueryPredicateBuilderListener;
    private SubqueryBuilderListenerImpl<RestrictionBuilder<T>> superExprLeftSubqueryPredicateBuilderListener;
    private CaseExpressionBuilderListener caseExpressionBuilderListener;
    protected final ExpressionFactory expressionFactory;

    PredicateManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory) {
        super(queryGenerator, parameterManager);
        this.rootPredicate = new RootPredicate(parameterManager);
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
    }

    RestrictionBuilder<T> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, Expression expr) {
        return (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    CaseWhenStarterBuilder<RestrictionBuilder<T>> restrictCase(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener((RestrictionBuilderImpl)restrictionBuilder);
        return (CaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new CaseWhenBuilderImpl<RestrictionBuilder>(restrictionBuilder, this.caseExpressionBuilderListener, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    SimpleCaseWhenStarterBuilder<RestrictionBuilder<T>> restrictSimpleCase(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, Expression caseOperand) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener((RestrictionBuilderImpl)restrictionBuilder);
        return (SimpleCaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new SimpleCaseWhenBuilderImpl<RestrictionBuilder>(restrictionBuilder, this.caseExpressionBuilderListener, this.expressionFactory, caseOperand));
    }

    SubqueryInitiator<RestrictionBuilder<T>> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener);
    }

    SubqueryInitiator<RestrictionBuilder<T>> restrict(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder, String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<RestrictionBuilder<T>>(subqueryAlias, expr);
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.superExprLeftSubqueryPredicateBuilderListener);
    }

    SubqueryInitiator<T> restrictExists(T result) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(result, this.rightSubqueryPredicateBuilderListener);
    }

    SubqueryInitiator<T> restrictNotExists(T result) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new NotPredicate((Predicate)new ExistsPredicate())));
        return this.subqueryInitFactory.createSubqueryInitiator(result, this.rightSubqueryPredicateBuilderListener);
    }

    void applyTransformer(ExpressionTransformer transformer) {
        this.rootPredicate.getPredicate().accept((Expression.Visitor)new TransformationVisitor(transformer, this.getClauseType()));
    }

    void verifyBuilderEnded() {
        this.rootPredicate.verifyBuilderEnded();
        this.leftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        if (this.rightSubqueryPredicateBuilderListener != null) {
            this.rightSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.superExprLeftSubqueryPredicateBuilderListener != null) {
            this.superExprLeftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.caseExpressionBuilderListener != null) {
            this.caseExpressionBuilderListener.verifyBuilderEnded();
        }
    }

    void acceptVisitor(Expression.Visitor v) {
        this.rootPredicate.getPredicate().accept(v);
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v) {
        return (X)this.rootPredicate.getPredicate().accept(v);
    }

    boolean hasPredicates() {
        return this.rootPredicate.getPredicate().getChildren().size() > 0;
    }

    void buildClause(StringBuilder sb) {
        if (!this.hasPredicates()) {
            return;
        }
        this.queryGenerator.setQueryBuffer(sb);
        sb.append(' ').append(this.getClauseName()).append(' ');
        this.applyPredicate(this.queryGenerator);
    }

    void buildClausePredicate(StringBuilder sb) {
        this.queryGenerator.setQueryBuffer(sb);
        this.applyPredicate(this.queryGenerator);
    }

    protected abstract String getClauseName();

    protected abstract ClauseType getClauseType();

    void applyPredicate(ResolvingQueryGenerator queryGenerator) {
        boolean conditionalContext = queryGenerator.setConditionalContext(true);
        this.rootPredicate.getPredicate().accept((Expression.Visitor)queryGenerator);
        queryGenerator.setConditionalContext(conditionalContext);
    }

    static class TransformationVisitor
    extends VisitorAdapter {
        private final ExpressionTransformer transformer;
        private final ClauseType fromClause;
        private boolean joinRequired;

        public TransformationVisitor(ExpressionTransformer transformer, ClauseType fromClause) {
            this.transformer = transformer;
            this.fromClause = fromClause;
            this.joinRequired = true;
        }

        public void visit(BetweenPredicate predicate) {
            predicate.setStart(this.transformer.transform(predicate.getStart(), this.fromClause, this.joinRequired));
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setEnd(this.transformer.transform(predicate.getEnd(), this.fromClause, this.joinRequired));
        }

        public void visit(GePredicate predicate) {
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
        }

        public void visit(GtPredicate predicate) {
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
        }

        public void visit(LikePredicate predicate) {
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
        }

        public void visit(EqPredicate predicate) {
            boolean original = this.joinRequired;
            this.joinRequired = false;
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
            this.joinRequired = original;
        }

        public void visit(LePredicate predicate) {
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
        }

        public void visit(LtPredicate predicate) {
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
        }

        public void visit(InPredicate predicate) {
            boolean original = this.joinRequired;
            this.joinRequired = false;
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
            this.joinRequired = original;
        }

        public void visit(ExistsPredicate predicate) {
            predicate.setExpression(this.transformer.transform(predicate.getExpression(), this.fromClause, this.joinRequired));
        }

        public void visit(MemberOfPredicate predicate) {
            boolean original = this.joinRequired;
            this.joinRequired = false;
            predicate.setLeft(this.transformer.transform(predicate.getLeft(), this.fromClause, this.joinRequired));
            predicate.setRight(this.transformer.transform(predicate.getRight(), this.fromClause, this.joinRequired));
            this.joinRequired = original;
        }

        public void visit(IsEmptyPredicate predicate) {
            boolean original = this.joinRequired;
            this.joinRequired = false;
            predicate.setExpression(this.transformer.transform(predicate.getExpression(), this.fromClause, this.joinRequired));
            this.joinRequired = original;
        }

        public void visit(IsNullPredicate predicate) {
            boolean original = this.joinRequired;
            this.joinRequired = false;
            predicate.setExpression(this.transformer.transform(predicate.getExpression(), this.fromClause, this.joinRequired));
            this.joinRequired = original;
        }
    }
}

