/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.BaseFinalSetOperationBuilderImpl;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SetOperationManager;
import com.blazebit.persistence.impl.SimpleQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.expression.AggregateExpression;
import com.blazebit.persistence.impl.expression.ArrayExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FooExpression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.ParameterExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.jpaprovider.HibernateJpaProvider;
import com.blazebit.persistence.impl.jpaprovider.JpaProvider;
import com.blazebit.persistence.spi.OrderByElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ResolvingQueryGenerator
extends SimpleQueryGenerator {
    private boolean resolveSelectAliases = true;
    private final AliasManager aliasManager;
    private final JpaProvider jpaProvider;
    protected String aliasPrefix;
    private final Set<String> registeredFunctions;

    public ResolvingQueryGenerator(AliasManager aliasManager, JpaProvider jpaProvider, Set<String> registeredFunctions) {
        this.aliasManager = aliasManager;
        this.jpaProvider = jpaProvider;
        this.registeredFunctions = registeredFunctions;
    }

    public void visit(FunctionExpression expression) {
        if (ExpressionUtils.isOuterFunction(expression)) {
            ((Expression)expression.getExpressions().get(0)).accept((Expression.Visitor)this);
        } else if (ExpressionUtils.isFunctionFunctionExpression(expression)) {
            String functionName = ExpressionUtils.unwrapStringLiteral(((Expression)expression.getExpressions().get(0)).toString());
            this.renderFunctionFunction(functionName, expression.getExpressions());
        } else if (this.isCountStarFunction(expression)) {
            this.renderCountStar();
        } else {
            super.visit(expression);
        }
    }

    protected void renderCountStar() {
        if (this.jpaProvider instanceof HibernateJpaProvider) {
            this.sb.append("COUNT(*)");
        } else {
            this.renderFunctionFunction("COUNT_STAR", Collections.<Expression>emptyList());
        }
    }

    public void visit(SubqueryExpression expression) {
        boolean isSimple;
        this.sb.append('(');
        SubqueryInternalBuilder subquery = (SubqueryInternalBuilder)expression.getSubquery();
        boolean hasFirstResult = subquery.getFirstResult() != 0;
        boolean hasMaxResults = subquery.getMaxResults() != Integer.MAX_VALUE;
        boolean hasLimit = hasFirstResult || hasMaxResults;
        boolean hasSetOperations = subquery instanceof BaseFinalSetOperationBuilder;
        boolean bl = isSimple = !hasLimit && !hasSetOperations;
        if (isSimple) {
            this.sb.append(subquery.getQueryString());
        } else if (hasSetOperations) {
            this.asExpression((AbstractCommonQueryBuilder)((Object)subquery)).accept((Expression.Visitor)this);
        } else {
            ArrayList<Expression> arguments = new ArrayList<Expression>(3);
            arguments.add((Expression)new FooExpression((CharSequence)"'LIMIT'"));
            arguments.add(this.asExpression((AbstractCommonQueryBuilder)((Object)subquery)));
            if (!hasMaxResults) {
                throw new IllegalArgumentException("First result without max results is not supported!");
            }
            arguments.add((Expression)new FooExpression((CharSequence)Integer.toString(subquery.getMaxResults())));
            if (hasFirstResult) {
                arguments.add((Expression)new FooExpression((CharSequence)Integer.toString(subquery.getFirstResult())));
            }
            this.renderFunctionFunction("LIMIT", arguments);
        }
        this.sb.append(')');
    }

    protected Expression asExpression(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder) {
        if (queryBuilder instanceof BaseFinalSetOperationBuilderImpl) {
            BaseFinalSetOperationBuilderImpl operationBuilder = (BaseFinalSetOperationBuilderImpl)queryBuilder;
            SetOperationManager operationManager = operationBuilder.setOperationManager;
            if (operationManager.getOperator() == null || !operationManager.hasSetOperations()) {
                return this.asExpression(operationManager.getStartQueryBuilder());
            }
            ArrayList<Object> setOperationArgs = new ArrayList<Object>(operationManager.getSetOperations().size() + 2);
            StringBuilder nameSb = new StringBuilder();
            nameSb.append('\'');
            nameSb.append("SET_");
            nameSb.append(operationManager.getOperator().name());
            nameSb.append('\'');
            setOperationArgs.add(new FooExpression(nameSb));
            setOperationArgs.add(this.asExpression(operationManager.getStartQueryBuilder()));
            List<AbstractCommonQueryBuilder<?, ?, ?, ?, ?>> setOperands = operationManager.getSetOperations();
            int operandsSize = setOperands.size();
            for (int i = 0; i < operandsSize; ++i) {
                setOperationArgs.add(this.asExpression(setOperands.get(i)));
            }
            List<OrderByElement> orderByElements = operationBuilder.getOrderByElements();
            if (orderByElements.size() > 0) {
                setOperationArgs.add(new FooExpression((CharSequence)"'ORDER_BY'"));
                int orderByElementsSize = orderByElements.size();
                for (int i = 0; i < orderByElementsSize; ++i) {
                    StringBuilder argSb = new StringBuilder(20);
                    argSb.append('\'');
                    argSb.append(orderByElements.get(i).toString());
                    argSb.append('\'');
                    setOperationArgs.add(new FooExpression(argSb));
                }
            }
            if (operationBuilder.hasLimit()) {
                if (operationBuilder.maxResults != Integer.MAX_VALUE) {
                    setOperationArgs.add(new FooExpression((CharSequence)"'LIMIT'"));
                    setOperationArgs.add(new FooExpression((CharSequence)Integer.toString(operationBuilder.maxResults)));
                }
                if (operationBuilder.firstResult != 0) {
                    setOperationArgs.add(new FooExpression((CharSequence)"'OFFSET'"));
                    setOperationArgs.add(new FooExpression((CharSequence)Integer.toString(operationBuilder.firstResult)));
                }
            }
            FunctionExpression functionExpr = new FunctionExpression("FUNCTION", setOperationArgs);
            return functionExpr;
        }
        String queryString = queryBuilder.getQueryString();
        StringBuilder subquerySb = new StringBuilder(queryString.length() + 2);
        subquerySb.append('(');
        subquerySb.append(queryString);
        subquerySb.append(')');
        return new FooExpression((CharSequence)subquerySb.toString());
    }

    protected void renderFunctionFunction(String functionName, List<Expression> arguments) {
        if (this.registeredFunctions.contains(functionName.toLowerCase())) {
            this.sb.append(this.jpaProvider.getCustomFunctionInvocation(functionName, arguments.size()));
            if (arguments.size() > 1) {
                arguments.get(1).accept((Expression.Visitor)this);
                for (int i = 2; i < arguments.size(); ++i) {
                    this.sb.append(",");
                    arguments.get(i).accept((Expression.Visitor)this);
                }
            }
            this.sb.append(')');
        } else if (this.jpaProvider.supportsJpa21()) {
            this.sb.append("FUNCTION('");
            this.sb.append(functionName);
            this.sb.append('\'');
            for (int i = 1; i < arguments.size(); ++i) {
                this.sb.append(',');
                arguments.get(i).accept((Expression.Visitor)this);
            }
            this.sb.append(')');
        } else {
            throw new IllegalArgumentException("Unknown function [" + functionName + "] is used!");
        }
    }

    private boolean isCountStarFunction(FunctionExpression expression) {
        return expression instanceof AggregateExpression && expression.getExpressions().isEmpty() && "COUNT".equalsIgnoreCase(expression.getFunctionName());
    }

    public void visit(PathExpression expression) {
        JoinNode baseNode;
        AliasInfo aliasInfo;
        if (this.resolveSelectAliases && expression.getBaseNode() == null && (aliasInfo = this.aliasManager.getAliasInfo(expression.toString())) != null && aliasInfo instanceof SelectInfo) {
            SelectInfo selectAliasInfo = (SelectInfo)aliasInfo;
            if (((SelectInfo)aliasInfo).getExpression() instanceof PathExpression) {
                selectAliasInfo.getExpression().accept((Expression.Visitor)this);
                return;
            }
        }
        if (expression.getBaseNode() == null) {
            super.visit(expression);
        } else if (expression.getField() == null) {
            boolean valueFunction;
            boolean bl = valueFunction = this.needsValueFunction(expression) && !expression.isUsedInCollectionFunction() && this.jpaProvider.getCollectionValueFunction() != null;
            if (valueFunction) {
                this.sb.append(this.jpaProvider.getCollectionValueFunction());
                this.sb.append('(');
            }
            if (this.aliasPrefix != null) {
                this.sb.append(this.aliasPrefix);
            }
            baseNode = (JoinNode)expression.getBaseNode();
            this.sb.append(baseNode.getAliasInfo().getAlias());
            if (valueFunction) {
                this.sb.append(')');
            }
        } else {
            boolean valueFunction;
            boolean bl = valueFunction = this.needsValueFunction(expression) && this.jpaProvider.getCollectionValueFunction() != null;
            if (valueFunction) {
                this.sb.append(this.jpaProvider.getCollectionValueFunction());
                this.sb.append('(');
            }
            if (this.aliasPrefix != null) {
                this.sb.append(this.aliasPrefix);
            }
            baseNode = (JoinNode)expression.getBaseNode();
            this.sb.append(baseNode.getAliasInfo().getAlias());
            if (valueFunction) {
                this.sb.append(')');
            }
            this.sb.append(".").append(expression.getField());
        }
    }

    private boolean needsValueFunction(PathExpression expression) {
        JoinNode baseNode = (JoinNode)expression.getBaseNode();
        return !expression.isCollectionKeyPath() && baseNode.getParentTreeNode() != null && baseNode.getParentTreeNode().isMap();
    }

    protected String getBooleanConditionalExpression(boolean value) {
        return this.jpaProvider.getBooleanConditionalExpression(value);
    }

    protected String getBooleanExpression(boolean value) {
        return this.jpaProvider.getBooleanExpression(value);
    }

    protected String escapeCharacter(char character) {
        return this.jpaProvider.escapeCharacter(character);
    }

    public void visit(ParameterExpression expression) {
        boolean needsBrackets;
        if (expression.getName() == null) {
            throw new IllegalStateException("Unsatisfied parameter " + expression.getName());
        }
        String paramName = expression.getName();
        boolean bl = needsBrackets = this.jpaProvider.needsBracketsForListParamter() && expression.getValue() instanceof List && ((List)expression.getValue()).size() > 1;
        if (needsBrackets) {
            this.sb.append('(');
        }
        this.sb.append(":");
        this.sb.append(paramName);
        if (needsBrackets) {
            this.sb.append(')');
        }
    }

    public boolean isResolveSelectAliases() {
        return this.resolveSelectAliases;
    }

    public void setResolveSelectAliases(boolean replaceSelectAliases) {
        this.resolveSelectAliases = replaceSelectAliases;
    }

    public String getAliasPrefix() {
        return this.aliasPrefix;
    }

    public void setAliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
    }

    public void visit(ArrayExpression expression) {
    }
}

