/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.AbstractFullQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EntitySelectResolveVisitor;
import com.blazebit.persistence.impl.ExpressionTransformer;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.GroupByUsableDetectionVisitor;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoTransformer;
import com.blazebit.persistence.impl.SelectObjectBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.object.ClassObjectBuilder;
import com.blazebit.persistence.impl.builder.object.ConstructorObjectBuilder;
import com.blazebit.persistence.impl.builder.object.SelectObjectBuilderImpl;
import com.blazebit.persistence.impl.builder.object.TupleObjectBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.PathElementExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.PropertyExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.jpaprovider.JpaProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.metamodel.Metamodel;

public class SelectManager<T>
extends AbstractManager {
    private final List<SelectInfo> selectInfos = new ArrayList<SelectInfo>();
    private boolean distinct = false;
    private SelectObjectBuilderImpl<?> selectObjectBuilder;
    private ObjectBuilder<T> objectBuilder;
    private SubqueryBuilderListenerImpl<?> subqueryBuilderListener;
    private final Map<String, Integer> selectAliasToPositionMap = new HashMap<String, Integer>();
    private final SelectObjectBuilderEndedListenerImpl selectObjectBuilderEndedListener = new SelectObjectBuilderEndedListenerImpl();
    private CaseExpressionBuilderListener caseExpressionBuilderListener;
    private final JoinManager joinManager;
    private final AliasManager aliasManager;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final JpaProvider jpaProvider;

    public SelectManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, JoinManager joinManager, AliasManager aliasManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, JpaProvider jpaProvider, Class<?> resultClazz) {
        super(queryGenerator, parameterManager);
        this.joinManager = joinManager;
        this.aliasManager = aliasManager;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.jpaProvider = jpaProvider;
        if (resultClazz.equals(Tuple.class)) {
            this.objectBuilder = new TupleObjectBuilder(this.selectInfos, this.selectAliasToPositionMap);
        }
    }

    void verifyBuilderEnded() {
        if (this.subqueryBuilderListener != null) {
            this.subqueryBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.caseExpressionBuilderListener != null) {
            this.caseExpressionBuilderListener.verifyBuilderEnded();
        }
        this.selectObjectBuilderEndedListener.verifyBuilderEnded();
    }

    ObjectBuilder<T> getSelectObjectBuilder() {
        return this.objectBuilder;
    }

    public List<SelectInfo> getSelectInfos() {
        return this.selectInfos;
    }

    public boolean containsSizeSelect() {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            if (!ExpressionUtils.containsSizeExpression(selectInfo.getExpression())) continue;
            return true;
        }
        return false;
    }

    void acceptVisitor(Expression.Visitor v) {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            selectInfo.getExpression().accept(v);
        }
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v, X stopValue) {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            if (!stopValue.equals(selectInfo.getExpression().accept(v))) continue;
            return stopValue;
        }
        return null;
    }

    void buildGroupByClauses(Metamodel m, Set<String> clauses) {
        boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<PathExpression> componentPaths = new LinkedHashSet<PathExpression>();
        EntitySelectResolveVisitor resolveVisitor = new EntitySelectResolveVisitor(m, componentPaths);
        if (this.selectInfos.isEmpty()) {
            List<JoinNode> roots = this.joinManager.getRoots();
            if (roots.size() > 1) {
                throw new IllegalArgumentException("Empty select not allowed when having multiple roots!");
            }
            JoinNode rootNode = roots.get(0);
            String rootAlias = rootNode.getAliasInfo().getAlias();
            List<PathElementExpression> path = Arrays.asList(new PropertyExpression(rootAlias));
            resolveVisitor.visit(new PathExpression(path, (Object)rootNode, null, false, false));
            for (PathExpression pathExpr : componentPaths) {
                sb.setLength(0);
                this.queryGenerator.setQueryBuffer(sb);
                pathExpr.accept((Expression.Visitor)this.queryGenerator);
                clauses.add(sb.toString());
            }
        } else {
            List<SelectInfo> infos = this.selectInfos;
            int size = this.selectInfos.size();
            for (int i = 0; i < size; ++i) {
                SelectInfo selectInfo = infos.get(i);
                selectInfo.getExpression().accept((Expression.Visitor)resolveVisitor);
                if (componentPaths.size() > 0) {
                    for (PathExpression pathExpr : componentPaths) {
                        sb.setLength(0);
                        this.queryGenerator.setQueryBuffer(sb);
                        pathExpr.accept((Expression.Visitor)this.queryGenerator);
                        clauses.add(sb.toString());
                    }
                    continue;
                }
                GroupByUsableDetectionVisitor groupByUsableDetectionVisitor = new GroupByUsableDetectionVisitor();
                if (Boolean.TRUE.equals(selectInfo.getExpression().accept((Expression.ResultVisitor)groupByUsableDetectionVisitor))) continue;
                sb.setLength(0);
                this.queryGenerator.setQueryBuffer(sb);
                selectInfo.getExpression().accept((Expression.Visitor)this.queryGenerator);
                clauses.add(sb.toString());
            }
        }
        this.queryGenerator.setConditionalContext(conditionalContext);
    }

    void buildSelect(StringBuilder sb) {
        sb.append("SELECT ");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        if (size == 0) {
            List<JoinNode> roots = this.joinManager.getRoots();
            if (roots.size() > 1) {
                throw new IllegalArgumentException("Empty select not allowed when having multiple roots!");
            }
            sb.append(roots.get(0).getAliasInfo().getAlias());
        } else {
            this.queryGenerator.setQueryBuffer(sb);
            boolean conditionalContext = this.queryGenerator.setConditionalContext(false);
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                this.applySelect(this.queryGenerator, sb, infos.get(i));
            }
            this.queryGenerator.setConditionalContext(conditionalContext);
        }
    }

    void applyTransformer(ExpressionTransformer transformer) {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            Expression transformed = transformer.transform(selectInfo.getExpression(), ClauseType.SELECT, true);
            selectInfo.setExpression(transformed);
        }
    }

    void applySelectInfoTransformer(SelectInfoTransformer selectInfoTransformer) {
        List<SelectInfo> infos = this.selectInfos;
        int size = this.selectInfos.size();
        for (int i = 0; i < size; ++i) {
            SelectInfo selectInfo = infos.get(i);
            selectInfoTransformer.transform(selectInfo);
        }
    }

    <X> SubqueryInitiator<X> selectSubquery(X builder, String selectAlias) {
        this.verifyBuilderEnded();
        this.subqueryBuilderListener = new SelectSubqueryBuilderListener(selectAlias);
        SubqueryInitiator<X> initiator = this.subqueryInitFactory.createSubqueryInitiator(builder, this.subqueryBuilderListener);
        this.subqueryBuilderListener.onInitiatorStarted(initiator);
        return initiator;
    }

    <X> SubqueryInitiator<X> selectSubquery(X builder, String subqueryAlias, Expression expression, String selectAlias) {
        this.verifyBuilderEnded();
        this.subqueryBuilderListener = new SuperExpressionSelectSubqueryBuilderListener(subqueryAlias, expression, selectAlias);
        SubqueryInitiator<X> initiator = this.subqueryInitFactory.createSubqueryInitiator(builder, this.subqueryBuilderListener);
        this.subqueryBuilderListener.onInitiatorStarted(initiator);
        return initiator;
    }

    <X> CaseWhenStarterBuilder<X> selectCase(X builder, String selectAlias) {
        this.verifyBuilderEnded();
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(selectAlias);
        return (CaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new CaseWhenBuilderImpl<X>(builder, this.caseExpressionBuilderListener, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    <X> SimpleCaseWhenStarterBuilder<X> selectSimpleCase(X builder, String selectAlias, Expression caseOperandExpression) {
        this.verifyBuilderEnded();
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(selectAlias);
        return (SimpleCaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new SimpleCaseWhenBuilderImpl<X>(builder, this.caseExpressionBuilderListener, this.expressionFactory, caseOperandExpression));
    }

    Class<?> getExpectedQueryResultType() {
        if (this.selectInfos.size() > 1) {
            return Object[].class;
        }
        return this.jpaProvider.getDefaultQueryResultType();
    }

    void select(Expression expr, String selectAlias) {
        SelectInfo selectInfo = new SelectInfo(expr, selectAlias, this.aliasManager);
        if (selectAlias != null) {
            this.aliasManager.registerAliasInfo(selectInfo);
            this.selectAliasToPositionMap.put(selectAlias, this.selectAliasToPositionMap.size());
        }
        this.selectInfos.add(selectInfo);
        this.registerParameterExpressions(expr);
    }

    <Y, X extends AbstractFullQueryBuilder<?, ?, ?, ?, ?>> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(X builder, Class<Y> clazz) {
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        if (!this.selectInfos.isEmpty()) {
            throw new IllegalStateException("No mixture of select and selectNew is allowed");
        }
        this.selectObjectBuilder = this.selectObjectBuilderEndedListener.startBuilder(new SelectObjectBuilderImpl<X>(builder, this.selectObjectBuilderEndedListener, this.subqueryInitFactory, this.expressionFactory));
        this.objectBuilder = new ClassObjectBuilder<Y>(clazz);
        return this.selectObjectBuilder;
    }

    <Y, X extends AbstractFullQueryBuilder<?, ?, ?, ?, ?>> SelectObjectBuilder<? extends FullQueryBuilder<Y, ?>> selectNew(X builder, Constructor<Y> constructor) {
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        if (!this.selectInfos.isEmpty()) {
            throw new IllegalStateException("No mixture of select and selectNew is allowed");
        }
        this.selectObjectBuilder = this.selectObjectBuilderEndedListener.startBuilder(new SelectObjectBuilderImpl<X>(builder, this.selectObjectBuilderEndedListener, this.subqueryInitFactory, this.expressionFactory));
        this.objectBuilder = new ConstructorObjectBuilder<Y>(constructor);
        return this.selectObjectBuilder;
    }

    <X extends FullQueryBuilder<?, X>> void selectNew(X builder, ObjectBuilder<?> objectBuilder) {
        if (this.selectObjectBuilder != null) {
            throw new IllegalStateException("Only one selectNew is allowed");
        }
        if (!this.selectInfos.isEmpty()) {
            throw new IllegalStateException("No mixture of select and selectNew is allowed");
        }
        objectBuilder.applySelects(builder);
        this.objectBuilder = objectBuilder;
    }

    void distinct() {
        this.distinct = true;
    }

    boolean isDistinct() {
        return this.distinct;
    }

    private void applySelect(ResolvingQueryGenerator queryGenerator, StringBuilder sb, SelectInfo select) {
        select.getExpression().accept((Expression.Visitor)queryGenerator);
        if (select.alias != null) {
            sb.append(" AS ").append(select.alias);
        }
    }

    private class SelectObjectBuilderEndedListenerImpl
    implements SelectObjectBuilderEndedListener {
        private SelectObjectBuilder<?> currentBuilder;

        private SelectObjectBuilderEndedListenerImpl() {
        }

        protected void verifyBuilderEnded() {
            if (this.currentBuilder != null) {
                throw new IllegalStateException("A builder was not ended properly.");
            }
        }

        protected <X extends SelectObjectBuilder<?>> X startBuilder(X builder) {
            if (this.currentBuilder != null) {
                throw new IllegalStateException("There was an attempt to start a builder but a previous builder was not ended.");
            }
            this.currentBuilder = builder;
            return builder;
        }

        @Override
        public void onBuilderEnded(Collection<Map.Entry<Expression, String>> expressions) {
            if (this.currentBuilder == null) {
                throw new IllegalStateException("There was an attempt to end a builder that was not started or already closed.");
            }
            this.currentBuilder = null;
            for (Map.Entry<Expression, String> e : expressions) {
                SelectManager.this.select(e.getKey(), e.getValue());
            }
        }
    }

    private class CaseExpressionBuilderListener
    extends ExpressionBuilderEndedListenerImpl {
        private final String selectAlias;

        public CaseExpressionBuilderListener(String selectAlias) {
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(ExpressionBuilder builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select(builder.getExpression(), this.selectAlias);
        }
    }

    private class SuperExpressionSelectSubqueryBuilderListener<X>
    extends SuperExpressionSubqueryBuilderListener<X> {
        private final String selectAlias;

        public SuperExpressionSelectSubqueryBuilderListener(String subqueryAlias, Expression superExpression, String selectAlias) {
            super(subqueryAlias, superExpression);
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select(this.superExpression, this.selectAlias);
        }
    }

    private class SelectSubqueryBuilderListener<X>
    extends SubqueryBuilderListenerImpl<X> {
        private final String selectAlias;

        public SelectSubqueryBuilderListener(String selectAlias) {
            this.selectAlias = selectAlias;
        }

        @Override
        public void onBuilderEnded(SubqueryInternalBuilder<X> builder) {
            super.onBuilderEnded(builder);
            SelectManager.this.select((Expression)new SubqueryExpression(builder), this.selectAlias);
        }
    }
}

