/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.GroupByManager;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.OrderByManager;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoTransformer;
import com.blazebit.persistence.impl.SizeTransformationVisitor;
import com.blazebit.persistence.impl.expression.AggregateExpression;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.PropertyExpression;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.metamodel.Metamodel;

public class SizeSelectToCountTransformer
implements SelectInfoTransformer {
    private final JoinManager joinManager;
    private final GroupByManager groupByManager;
    private final OrderByManager orderByManager;
    private final Metamodel metamodel;
    private final DeepSizeSelectToCountTransformer deepTransformer = new DeepSizeSelectToCountTransformer();

    public SizeSelectToCountTransformer(JoinManager joinManager, GroupByManager groupByManager, OrderByManager orderByManager, Metamodel metamodel) {
        this.joinManager = joinManager;
        this.groupByManager = groupByManager;
        this.orderByManager = orderByManager;
        this.metamodel = metamodel;
    }

    @Override
    public void transform(SelectInfo info) {
        this.deepTransformer.setOrderBySelectClause(this.orderByManager.getOrderBySelectAliases().contains(info.getAlias()));
        if (ExpressionUtils.isSizeFunction(info.getExpression())) {
            info.setExpression((Expression)info.getExpression().accept((Expression.ResultVisitor)this.deepTransformer));
        } else {
            info.getExpression().accept((Expression.ResultVisitor)this.deepTransformer);
        }
    }

    private class DeepSizeSelectToCountTransformer
    extends SizeTransformationVisitor {
        private boolean orderBySelectClause;

        private DeepSizeSelectToCountTransformer() {
        }

        public void setOrderBySelectClause(boolean orderBySelectClause) {
            this.orderBySelectClause = orderBySelectClause;
        }

        public Expression visit(PathExpression expression) {
            if (this.orderBySelectClause) {
                ((JoinNode)expression.getBaseNode()).getClauseDependencies().add(ClauseType.ORDER_BY);
            }
            return expression;
        }

        public Expression visit(FunctionExpression expression) {
            if (ExpressionUtils.isSizeFunction(expression)) {
                PathExpression sizeArg = (PathExpression)expression.getExpressions().get(0);
                sizeArg.setUsedInCollectionFunction(false);
                AggregateExpression countExpr = new AggregateExpression(false, "COUNT", expression.getExpressions());
                SizeSelectToCountTransformer.this.joinManager.implicitJoin((Expression)sizeArg, true, ClauseType.SELECT, false, false, true);
                ArrayList<PropertyExpression> pathElementExpr = new ArrayList<PropertyExpression>();
                List<JoinNode> roots = SizeSelectToCountTransformer.this.joinManager.getRoots();
                if (roots.size() > 1) {
                    throw new IllegalArgumentException("Can't transform size function to count when having multiple roots!");
                }
                String rootAlias = roots.get(0).getAliasInfo().getAlias();
                String rootId = JpaUtils.getIdAttribute(SizeSelectToCountTransformer.this.metamodel.entity(roots.get(0).getPropertyClass())).getName();
                pathElementExpr.add(new PropertyExpression(rootAlias));
                pathElementExpr.add(new PropertyExpression(rootId));
                SizeSelectToCountTransformer.this.groupByManager.groupBy((Expression)new PathExpression(pathElementExpr));
                super.visit(expression);
                return countExpr;
            }
            return expression;
        }
    }
}

