/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SelectInfoTransformer;
import com.blazebit.persistence.impl.SizeTransformationVisitor;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.FunctionExpression;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.Subquery;
import com.blazebit.persistence.impl.expression.SubqueryExpression;

public class SizeSelectToSubqueryTransformer
implements SelectInfoTransformer {
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final AliasManager aliasManager;
    private final DeepSizeSelectToSubqueryTransformer deepTransformer = new DeepSizeSelectToSubqueryTransformer();

    public SizeSelectToSubqueryTransformer(SubqueryInitiatorFactory subqueryInitFactory, AliasManager aliasManager) {
        this.subqueryInitFactory = subqueryInitFactory;
        this.aliasManager = aliasManager;
    }

    @Override
    public void transform(SelectInfo info) {
        if (ExpressionUtils.isSizeFunction(info.getExpression())) {
            info.setExpression((Expression)info.getExpression().accept((Expression.ResultVisitor)this.deepTransformer));
        } else {
            info.getExpression().accept((Expression.ResultVisitor)this.deepTransformer);
        }
    }

    private class DeepSizeSelectToSubqueryTransformer
    extends SizeTransformationVisitor {
        private DeepSizeSelectToSubqueryTransformer() {
        }

        public Expression visit(PathExpression expression) {
            return expression;
        }

        public Expression visit(FunctionExpression expression) {
            if (ExpressionUtils.isSizeFunction(expression)) {
                String collectionPropertyClassName;
                String collectionPropertyName;
                PathExpression sizeArg = (PathExpression)expression.getExpressions().get(0);
                Class<?> collectionPropertyClass = ((JoinNode)sizeArg.getBaseNode()).getPropertyClass();
                String baseAlias = ((JoinNode)sizeArg.getBaseNode()).getAliasInfo().getAlias();
                String collectionPropertyAlias = collectionPropertyName = sizeArg.getField() != null ? sizeArg.getField() : baseAlias;
                String collectionPropertyClassAlias = collectionPropertyClassName = collectionPropertyClass.getSimpleName().toLowerCase();
                if (SizeSelectToSubqueryTransformer.this.aliasManager.getAliasInfo(collectionPropertyClassName) != null) {
                    collectionPropertyClassAlias = SizeSelectToSubqueryTransformer.this.aliasManager.generatePostfixedAlias(collectionPropertyClassName);
                }
                if (SizeSelectToSubqueryTransformer.this.aliasManager.getAliasInfo(collectionPropertyName) != null) {
                    collectionPropertyAlias = SizeSelectToSubqueryTransformer.this.aliasManager.generatePostfixedAlias(collectionPropertyName);
                }
                Subquery countSubquery = (Subquery)((SubqueryBuilder)((SubqueryBuilder)SizeSelectToSubqueryTransformer.this.subqueryInitFactory.createSubqueryInitiator(null, new SubqueryBuilderListenerImpl()).from(collectionPropertyClass, collectionPropertyClassAlias).select("COUNT(" + collectionPropertyAlias + ")")).leftJoin(collectionPropertyClassAlias + '.' + collectionPropertyName, collectionPropertyAlias)).where(collectionPropertyClassAlias).eqExpression(baseAlias);
                return new SubqueryExpression(countSubquery);
            }
            return expression;
        }
    }
}

