/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.SubqueryBuilderListener;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;

public class SubqueryBuilderListenerImpl<T>
implements SubqueryBuilderListener<T> {
    private SubqueryInitiator<?> currentSubqueryInitiator;
    private SubqueryInternalBuilder<T> currentSubqueryBuilder;

    @Override
    public void onReplaceBuilder(SubqueryInternalBuilder<T> oldBuilder, SubqueryInternalBuilder<T> newBuilder) {
        if (this.currentSubqueryBuilder == null) {
            throw new BuilderChainingException("There was an attempt to replace a builder that was not started or already closed.");
        }
        if (this.currentSubqueryBuilder != oldBuilder) {
            throw new BuilderChainingException("There was an attempt to replace a builder that was not started or already closed.");
        }
        this.currentSubqueryBuilder = newBuilder;
    }

    public void verifySubqueryBuilderEnded() {
        if (this.currentSubqueryInitiator != null) {
            throw new BuilderChainingException("An initiator was not ended properly.");
        }
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        if (this.currentSubqueryBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentSubqueryBuilder = null;
    }

    @Override
    public void onBuilderStarted(SubqueryInternalBuilder<T> builder) {
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentSubqueryInitiator = null;
        this.currentSubqueryBuilder = builder;
    }

    @Override
    public void onInitiatorStarted(SubqueryInitiator<?> initiator) {
        if (this.currentSubqueryInitiator != null) {
            throw new BuilderChainingException("There was an attempt to start an initiator but a previous initiator was not ended.");
        }
        if (this.currentSubqueryBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentSubqueryInitiator = initiator;
    }
}

