/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.CaseWhenThenBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.PredicateAndExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenAndThenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.CaseWhenOrThenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import com.blazebit.persistence.impl.predicate.ExistsPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;
import java.util.ArrayList;
import java.util.List;

public class CaseWhenBuilderImpl<T>
extends PredicateAndExpressionBuilderEndedListener
implements CaseWhenBuilder<T>,
CaseWhenThenBuilder<CaseWhenBuilder<T>>,
ExpressionBuilder {
    private final T result;
    private final List<WhenClauseExpression> whenClauses;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private Predicate whenPredicate;
    private GeneralCaseExpression expression;
    private Expression thenExpression;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>>();
    private final ExpressionBuilderEndedListener listener;

    public CaseWhenBuilderImpl(T result, ExpressionBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager) {
        this.result = result;
        this.whenClauses = new ArrayList<WhenClauseExpression>();
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.listener = listener;
    }

    public RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> when(String expression) {
        this.verifyBuilderEnded();
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        return (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubquery() {
        this.verifyBuilderEnded();
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> whenSubquery(String subqueryAlias, String expression) {
        this.verifyBuilderEnded();
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener);
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> whenExists() {
        this.verifyBuilderEnded();
        SubqueryBuilderListenerImpl rightHandside = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightHandside);
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> whenNotExists() {
        this.verifyBuilderEnded();
        SubqueryBuilderListenerImpl rightHandside = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightHandside);
    }

    public CaseWhenBuilder<T> thenExpression(String expression) {
        if (this.thenExpression != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.thenExpression = this.expressionFactory.createScalarExpression(expression);
        this.whenClauses.add(new WhenClauseExpression((Expression)this.whenPredicate, this.thenExpression));
        return this;
    }

    public CaseWhenBuilder<T> then(Object value) {
        if (this.thenExpression != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.thenExpression = this.parameterManager.addParameterExpression(value);
        this.whenClauses.add(new WhenClauseExpression((Expression)this.whenPredicate, this.thenExpression));
        return this;
    }

    public CaseWhenAndThenBuilder<CaseWhenBuilder<T>> whenAnd() {
        this.verifyBuilderEnded();
        return this.startBuilder(new CaseWhenAndThenBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public CaseWhenOrThenBuilder<CaseWhenBuilder<T>> whenOr() {
        this.verifyBuilderEnded();
        return this.startBuilder(new CaseWhenOrThenBuilderImpl<CaseWhenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T otherwiseExpression(String elseExpression) {
        this.verifyBuilderEnded();
        if (this.whenClauses.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        if (this.expression != null) {
            throw new IllegalStateException("Method otherwise/otherwiseExpression called multiple times");
        }
        this.expression = new GeneralCaseExpression(this.whenClauses, this.expressionFactory.createScalarExpression(elseExpression));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T otherwise(Object value) {
        this.verifyBuilderEnded();
        if (this.whenClauses.isEmpty()) {
            throw new IllegalStateException("No when clauses specified");
        }
        if (this.expression != null) {
            throw new IllegalStateException("Method otherwise/otherwiseExpression called multiple times");
        }
        this.expression = new GeneralCaseExpression(this.whenClauses, (Expression)this.parameterManager.addParameterExpression(value));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public void onBuilderEnded(PredicateBuilder o) {
        super.onBuilderEnded(o);
        this.whenPredicate = o.getPredicate();
        this.thenExpression = null;
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        super.onBuilderEnded(builder);
        this.whenClauses.add((WhenClauseExpression)builder.getExpression());
    }

    @Override
    public void verifyBuilderEnded() {
        super.verifyBuilderEnded();
        this.leftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }
}

