/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.expression;

import com.blazebit.persistence.CaseWhenAndBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenAndBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.WhenClauseExpression;
import com.blazebit.persistence.impl.predicate.ExistsPredicate;
import com.blazebit.persistence.impl.predicate.OrPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;

public class CaseWhenOrThenBuilderImpl<T extends CaseWhenBuilder<?>>
extends PredicateBuilderEndedListenerImpl
implements CaseWhenOrThenBuilder<T>,
ExpressionBuilder {
    private final T result;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final OrPredicate predicate = new OrPredicate();
    private final ExpressionBuilderEndedListener listener;
    private final SubqueryBuilderListenerImpl<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<RestrictionBuilder<CaseWhenOrThenBuilder<T>>>();
    private WhenClauseExpression whenClause;

    public CaseWhenOrThenBuilderImpl(T result, ExpressionBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager) {
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.listener = listener;
    }

    public RestrictionBuilder<CaseWhenOrThenBuilder<T>> or(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        return (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubquery() {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenOrThenBuilder<T>>> orSubquery(String subqueryAlias, String expression) {
        SuperExpressionLeftHandsideSubqueryPredicateBuilder superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, this.expressionFactory.createSimpleExpression(expression));
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.startBuilder(new RestrictionBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, superExprLeftSubqueryPredicateBuilderListener);
    }

    public SubqueryInitiator<CaseWhenOrThenBuilder<T>> orExists() {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightSubqueryPredicateBuilderListener);
    }

    public SubqueryInitiator<CaseWhenOrThenBuilder<T>> orNotExists() {
        SubqueryBuilderListenerImpl rightSubqueryPredicateBuilderListener = this.startBuilder(new RightHandsideSubqueryPredicateBuilder(this, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(this, rightSubqueryPredicateBuilderListener);
    }

    public CaseWhenAndBuilder<CaseWhenOrThenBuilder<T>> and() {
        return this.startBuilder(new CaseWhenAndBuilderImpl<CaseWhenOrThenBuilderImpl>(this, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T thenExpression(String expression) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No or clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, this.expressionFactory.createScalarExpression(expression));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public T then(Object value) {
        this.verifyBuilderEnded();
        if (this.predicate.getChildren().isEmpty()) {
            throw new IllegalStateException("No or clauses specified!");
        }
        if (this.whenClause != null) {
            throw new IllegalStateException("Method then/thenExpression called multiple times");
        }
        this.whenClause = new WhenClauseExpression((Expression)this.predicate, (Expression)this.parameterManager.addParameterExpression(value));
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    @Override
    public void onBuilderEnded(PredicateBuilder builder) {
        super.onBuilderEnded(builder);
        this.predicate.getChildren().add(builder.getPredicate());
    }

    @Override
    public Expression getExpression() {
        return this.whenClause;
    }
}

