/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import java.io.Serializable;
import java.util.List;

public class KeysetExtractionObjectBuilder<T>
implements ObjectBuilder<T> {
    private final int keysetSize;
    private Object[] first;
    private Object[] last;

    public KeysetExtractionObjectBuilder(int keysetSize) {
        this.keysetSize = keysetSize;
    }

    public T build(Object[] tuple) {
        Object[] newTuple = new Object[tuple.length - this.keysetSize];
        System.arraycopy(tuple, 0, newTuple, 0, newTuple.length);
        if (this.first == null) {
            this.first = tuple;
            this.last = tuple;
        } else {
            this.last = tuple;
        }
        return (T)newTuple;
    }

    public Serializable[] getLowest() {
        if (this.first == null) {
            return null;
        }
        return KeysetPaginationHelper.extractKey(this.first, this.first.length - this.keysetSize);
    }

    public Serializable[] getHighest() {
        if (this.last == null) {
            return null;
        }
        return KeysetPaginationHelper.extractKey(this.last, this.last.length - this.keysetSize);
    }

    public List<T> buildList(List<T> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
    }
}

