/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.SelectObjectBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import java.util.AbstractMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SelectObjectBuilderImpl<T extends FullQueryBuilder<?, T>>
extends SubqueryBuilderListenerImpl<SelectObjectBuilder<T>>
implements SelectObjectBuilder<T> {
    private final T result;
    private final SortedMap<Integer, Map.Entry<Expression, String>> expressions = new TreeMap<Integer, Map.Entry<Expression, String>>();
    private final SelectObjectBuilderEndedListener listener;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private String subqueryAlias;

    public SelectObjectBuilderImpl(T result, SelectObjectBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory) {
        this.result = result;
        this.listener = listener;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
    }

    public SelectObjectBuilder<T> with(String expression) {
        return this.with(expression, null);
    }

    public SelectObjectBuilder<T> with(String expression, String alias) {
        if (this.expressions.containsKey(this.expressions.size())) {
            throw new IllegalStateException("Argument for position " + this.expressions.size() + " already specified");
        }
        Expression exp = this.expressionFactory.createSimpleExpression(expression);
        this.expressions.put(this.expressions.size(), new AbstractMap.SimpleEntry<Expression, String>(exp, alias));
        return this;
    }

    public SelectObjectBuilder<T> with(int position, String expression) {
        return this.with(position, expression, null);
    }

    public SelectObjectBuilder<T> with(int position, String expression, String alias) {
        if (this.expressions.containsKey(position)) {
            throw new IllegalStateException("Argument for position " + position + " already specified");
        }
        Expression exp = this.expressionFactory.createSimpleExpression(expression);
        this.expressions.put(position, new AbstractMap.SimpleEntry<Expression, String>(exp, alias));
        return this;
    }

    public T end() {
        this.listener.onBuilderEnded(this.expressions.values());
        return this.result;
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery() {
        return this.withSubquery(null);
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(String alias) {
        this.subqueryAlias = alias;
        return this.subqueryInitFactory.createSubqueryInitiator(this, this);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<SelectObjectBuilder<T>> builder) {
        super.onBuilderEnded(builder);
        this.expressions.put(this.expressions.size(), new AbstractMap.SimpleEntry<SubqueryExpression, String>(new SubqueryExpression(builder), this.subqueryAlias));
    }
}

