/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.CaseWhenThenBuilder;
import com.blazebit.persistence.LeafOngoingSetOperationSubqueryBuilder;
import com.blazebit.persistence.QuantifiableBinaryPredicateBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenBuilder;
import com.blazebit.persistence.StartOngoingSetOperationSubqueryBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryAndExpressionBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.impl.predicate.NotPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;
import com.blazebit.persistence.impl.predicate.PredicateQuantifier;
import com.blazebit.persistence.impl.predicate.QuantifiableBinaryExpressionPredicate;

public abstract class AbstractQuantifiablePredicateBuilder<T>
extends SubqueryAndExpressionBuilderListener<T>
implements QuantifiableBinaryPredicateBuilder<T>,
PredicateBuilder {
    private final T result;
    private final PredicateBuilderEndedListener listener;
    private final boolean wrapNot;
    protected final Expression leftExpression;
    protected final SubqueryInitiatorFactory subqueryInitFactory;
    private Predicate predicate;
    protected final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private SubqueryInitiator<T> subqueryInitiator;

    public AbstractQuantifiablePredicateBuilder(T result, PredicateBuilderEndedListener listener, Expression leftExpression, boolean wrapNot, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager) {
        this.result = result;
        this.listener = listener;
        this.wrapNot = wrapNot;
        this.leftExpression = leftExpression;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
    }

    protected abstract QuantifiableBinaryExpressionPredicate createPredicate(Expression var1, Expression var2, PredicateQuantifier var3);

    protected T chain(Predicate predicate) {
        this.verifyBuilderEnded();
        this.predicate = this.wrapNot ? new NotPredicate(predicate) : predicate;
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    protected void chainSubbuilder(Predicate predicate) {
        this.verifyBuilderEnded();
        this.predicate = this.wrapNot ? new NotPredicate(predicate) : predicate;
    }

    public T value(Object value) {
        return this.chain((Predicate)this.createPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value), PredicateQuantifier.ONE));
    }

    public T expression(String expression) {
        return this.chain((Predicate)this.createPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression), PredicateQuantifier.ONE));
    }

    public RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhen(String expression) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).when(expression);
    }

    public CaseWhenAndThenBuilder<CaseWhenBuilder<T>> caseWhenAnd() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenAnd();
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhenExists() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenExists();
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhenNotExists() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenNotExists();
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubquery() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenSubquery();
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubquery(String subqueryAlias, String expression) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenSubquery(subqueryAlias, expression);
    }

    public CaseWhenOrThenBuilder<CaseWhenBuilder<T>> caseWhenOr() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenOr();
    }

    public SimpleCaseWhenBuilder<T> simpleCase(String caseOperand) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new SimpleCaseWhenBuilderImpl<T>(this.result, this, this.expressionFactory, this.expressionFactory.createCaseOperandExpression(caseOperand)));
    }

    public SubqueryInitiator<T> all() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ALL));
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this);
    }

    public SubqueryInitiator<T> any() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ANY));
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this);
    }

    public SubqueryBuilder<T> from(Class<?> clazz) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(clazz);
    }

    public SubqueryBuilder<T> from(Class<?> clazz, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(clazz, alias);
    }

    public StartOngoingSetOperationSubqueryBuilder<T, LeafOngoingSetOperationSubqueryBuilder<T>> startSet() {
        return this.getSubqueryInitiator().startSet();
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        Predicate pred = this.predicate instanceof NotPredicate ? ((NotPredicate)this.predicate).getPredicate() : this.predicate;
        if (!(pred instanceof BinaryExpressionPredicate)) {
            throw new IllegalStateException("SubqueryBuilder ended but predicate type was unexpected");
        }
        ((BinaryExpressionPredicate)pred).setRight((Expression)new SubqueryExpression(builder));
        this.listener.onBuilderEnded(this);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    protected SubqueryInitiator<T> getSubqueryInitiator() {
        if (this.subqueryInitiator == null) {
            this.subqueryInitiator = this.subqueryInitFactory.createSubqueryInitiator(this.result, this);
        }
        return this.subqueryInitiator;
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        super.onBuilderEnded(builder);
        if (!(this.predicate instanceof BinaryExpressionPredicate)) {
            throw new IllegalStateException("ExpressionBuilder ended but predicate type was unexpected");
        }
        ((BinaryExpressionPredicate)this.predicate).setRight(builder.getExpression());
        this.listener.onBuilderEnded(this);
    }
}

