/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.BetweenBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.predicate.BetweenPredicate;

public class BetweenBuilderImpl<T>
extends SubqueryBuilderListenerImpl<T>
implements BetweenBuilder<T>,
LeftHandsideSubqueryPredicateBuilder {
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final PredicateBuilderEndedListener listener;
    private final Expression left;
    private final boolean negated;
    private Expression start;
    private final T result;
    private BetweenPredicate predicate;
    private SubqueryInitiator<?> subqueryStartMarker;

    public BetweenBuilderImpl(T result, Expression left, Expression start, ExpressionFactory expressionFactory, ParameterManager parameterManager, PredicateBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory) {
        this(result, left, start, expressionFactory, parameterManager, listener, subqueryInitFactory, false);
    }

    public BetweenBuilderImpl(T result, Expression left, Expression start, ExpressionFactory expressionFactory, ParameterManager parameterManager, PredicateBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, boolean negated) {
        this.result = result;
        this.left = left;
        this.start = start;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.listener = listener;
        this.subqueryInitFactory = subqueryInitFactory;
        this.negated = negated;
    }

    public T and(Object end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        return this.chain(new BetweenPredicate(this.left, this.start, (Expression)this.parameterManager.addParameterExpression(end), this.negated));
    }

    public T andExpression(String end) {
        return this.chain(new BetweenPredicate(this.left, this.start, this.expressionFactory.createArithmeticExpression(end), this.negated));
    }

    public SubqueryInitiator<T> andSubqery() {
        this.verifySubqueryBuilderEnded();
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this.result, this));
    }

    public SubqueryInitiator<T> andSubqery(String subqueryAlias, String expression) {
        this.verifySubqueryBuilderEnded();
        SuperExpressionSubqueryBuilderListener superExpressionSubqueryListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, this.expressionFactory.createArithmeticExpression(expression)){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                BetweenBuilderImpl.this.predicate = new BetweenPredicate(BetweenBuilderImpl.this.left, BetweenBuilderImpl.this.start, this.superExpression, BetweenBuilderImpl.this.negated);
                BetweenBuilderImpl.this.listener.onBuilderEnded(BetweenBuilderImpl.this);
            }
        };
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this.result, superExpressionSubqueryListener));
    }

    public BetweenPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void setLeftExpression(Expression start) {
        this.start = start;
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        this.subqueryStartMarker = null;
        this.predicate = new BetweenPredicate(this.left, this.start, (Expression)new SubqueryExpression(builder), this.negated);
        this.listener.onBuilderEnded(this);
    }

    @Override
    public void verifySubqueryBuilderEnded() {
        if (this.subqueryStartMarker != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
        super.verifySubqueryBuilderEnded();
    }

    public <X> SubqueryInitiator<X> startSubqueryInitiator(SubqueryInitiator<X> subqueryInitiator) {
        this.subqueryStartMarker = subqueryInitiator;
        return subqueryInitiator;
    }

    private T chain(BetweenPredicate predicate) {
        this.verifySubqueryBuilderEnded();
        this.predicate = predicate;
        this.listener.onBuilderEnded(this);
        return this.result;
    }
}

