/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.CaseWhenThenBuilder;
import com.blazebit.persistence.EscapeBuilder;
import com.blazebit.persistence.LikeBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryAndExpressionBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.EscapeBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.predicate.LikePredicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;

public class LikeBuilderImpl<T>
extends SubqueryAndExpressionBuilderListener<T>
implements LikeBuilder<T>,
PredicateBuilder {
    private final Expression leftExpression;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final T result;
    private final PredicateBuilderEndedListener listener;
    private final EscapeBuilderImpl.EscapeBuilderImplEndedListener escapeBuilderEndedListener = new EscapeBuilderImpl.EscapeBuilderImplEndedListener(){

        @Override
        public void onBuilderEnded(EscapeBuilderImpl<?> builder) {
            super.onBuilderEnded(builder);
            LikeBuilderImpl.this.likePredicate = new LikePredicate(LikeBuilderImpl.this.leftExpression, LikeBuilderImpl.this.patternExpression, LikeBuilderImpl.this.caseSensitive, builder.getEscapeCharacter(), LikeBuilderImpl.this.negated);
            LikeBuilderImpl.this.listener.onBuilderEnded(LikeBuilderImpl.this);
        }
    };
    private boolean negated;
    private boolean caseSensitive;
    private LikePredicate likePredicate;
    private Expression patternExpression;

    public LikeBuilderImpl(T result, PredicateBuilderEndedListener listener, Expression leftExpression, ExpressionFactory expressionFactory, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, boolean negated, boolean caseSensitive) {
        this.result = result;
        this.listener = listener;
        this.leftExpression = leftExpression;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.subqueryInitFactory = subqueryInitFactory;
        this.negated = negated;
        this.caseSensitive = caseSensitive;
    }

    public EscapeBuilder<T> value(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.patternExpression = this.parameterManager.addParameterExpression(value);
        return this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
    }

    public EscapeBuilder<T> expression(String expression) {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        this.patternExpression = this.expressionFactory.createStringExpression(expression);
        return this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
    }

    public RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhen(String expression) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).when(expression);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubquery() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenSubquery();
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>>> caseWhenSubquery(String subqueryAlias, String expression) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenSubquery(subqueryAlias, expression);
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhenExists() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenExists();
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>>> caseWhenNotExists() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenNotExists();
    }

    public CaseWhenAndThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>> caseWhenAnd() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenAnd();
    }

    public CaseWhenOrThenBuilder<CaseWhenBuilder<EscapeBuilder<T>>> caseWhenOr() {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new CaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager)).whenOr();
    }

    public SimpleCaseWhenBuilder<EscapeBuilder<T>> simpleCase(String caseOperand) {
        EscapeBuilderImpl<T> escapeBuilder = this.escapeBuilderEndedListener.startBuilder(new EscapeBuilderImpl<T>(this.escapeBuilderEndedListener, this.result));
        return this.startBuilder(new SimpleCaseWhenBuilderImpl<EscapeBuilderImpl<T>>(escapeBuilder, this, this.expressionFactory, this.expressionFactory.createCaseOperandExpression(caseOperand)));
    }

    public LikePredicate getPredicate() {
        return this.likePredicate;
    }

    @Override
    protected void verifyBuilderEnded() {
        super.verifyBuilderEnded();
        this.escapeBuilderEndedListener.verifyBuilderEnded();
    }
}

