/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.BetweenBuilder;
import com.blazebit.persistence.LikeBuilder;
import com.blazebit.persistence.QuantifiableBinaryPredicateBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.PredicateAndSubqueryBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.BetweenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.EqPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.GePredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.GtPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.LePredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.LikeBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.LtPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.ExpressionFactory;
import com.blazebit.persistence.impl.expression.PathExpression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.expression.SyntaxErrorException;
import com.blazebit.persistence.impl.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.impl.predicate.EqPredicate;
import com.blazebit.persistence.impl.predicate.GePredicate;
import com.blazebit.persistence.impl.predicate.GtPredicate;
import com.blazebit.persistence.impl.predicate.InPredicate;
import com.blazebit.persistence.impl.predicate.IsEmptyPredicate;
import com.blazebit.persistence.impl.predicate.IsNullPredicate;
import com.blazebit.persistence.impl.predicate.LePredicate;
import com.blazebit.persistence.impl.predicate.LtPredicate;
import com.blazebit.persistence.impl.predicate.MemberOfPredicate;
import com.blazebit.persistence.impl.predicate.NotPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;
import com.blazebit.persistence.internal.RestrictionBuilderExperimental;
import java.util.Arrays;
import java.util.List;

public class RestrictionBuilderImpl<T>
extends PredicateAndSubqueryBuilderEndedListener<T>
implements RestrictionBuilderExperimental<T>,
LeftHandsideSubqueryPredicateBuilder {
    private final T result;
    private final PredicateBuilderEndedListener listener;
    private Expression leftExpression;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private Predicate predicate;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final SubqueryBuilderListenerImpl<BetweenBuilder<T>> betweenStartSubqueryBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener<BetweenBuilder<T>>();
    private SubqueryBuilderListenerImpl<T> rightSuperExprSubqueryBuilderListener;
    private SubqueryBuilderListenerImpl<BetweenBuilder<T>> leftSuperExprSubqueryPredicateBuilderListener;
    private SuperExpressionRightHandsideSubqueryPredicateBuilder rightSuperExprSubqueryPredicateBuilderListener;

    public RestrictionBuilderImpl(T result, PredicateBuilderEndedListener listener, Expression leftExpression, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager) {
        this.leftExpression = leftExpression;
        this.listener = listener;
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
    }

    public RestrictionBuilderImpl(T result, PredicateBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager) {
        this.listener = listener;
        this.result = result;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
    }

    @Override
    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    private T chain(Predicate predicate) {
        this.verifyBuilderEnded();
        this.predicate = predicate;
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public BetweenBuilder<T> between(Object start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, (Expression)this.parameterManager.addParameterExpression(start), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory));
    }

    public BetweenBuilder<T> betweenExpression(String start) {
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, this.expressionFactory.createArithmeticExpression(start), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory));
    }

    public SubqueryInitiator<BetweenBuilder<T>> betweenSubquery() {
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.betweenStartSubqueryBuilderListener);
    }

    public SubqueryInitiator<BetweenBuilder<T>> betweenSubquery(String subqueryAlias, String expression) {
        this.leftSuperExprSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<BetweenBuilder<T>>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression));
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.leftSuperExprSubqueryPredicateBuilderListener);
    }

    public BetweenBuilder<T> notBetween(Object start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, (Expression)this.parameterManager.addParameterExpression(start), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, true));
    }

    public BetweenBuilder<T> notBetweenExpression(String start) {
        return this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, this.expressionFactory.createArithmeticExpression(start), this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, true));
    }

    public SubqueryInitiator<BetweenBuilder<T>> notBetweenSubquery() {
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, true));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.betweenStartSubqueryBuilderListener);
    }

    public SubqueryInitiator<BetweenBuilder<T>> notBetweenSubquery(String subqueryAlias, String expression) {
        this.leftSuperExprSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder<BetweenBuilder<T>>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression));
        BetweenBuilder betweenBuilder = this.startBuilder(new BetweenBuilderImpl<T>(this.result, this.leftExpression, null, this.expressionFactory, this.parameterManager, this, this.subqueryInitFactory, true));
        return this.subqueryInitFactory.createSubqueryInitiator(betweenBuilder, this.leftSuperExprSubqueryPredicateBuilderListener);
    }

    public QuantifiableBinaryPredicateBuilder<T> eq() {
        return this.startBuilder(new EqPredicateBuilder<T>(this.result, this, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T eq(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new EqPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value)));
    }

    public SubqueryInitiator<T> eq(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new EqPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, false, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T eqExpression(String expression) {
        return this.chain((Predicate)new EqPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression)));
    }

    public QuantifiableBinaryPredicateBuilder<T> notEq() {
        return this.startBuilder(new EqPredicateBuilder<T>(this.result, this, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T notEq(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new EqPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value), true));
    }

    public T notEqExpression(String expression) {
        return this.chain((Predicate)new EqPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression), true));
    }

    public SubqueryInitiator<T> notEq(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new EqPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, true, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public QuantifiableBinaryPredicateBuilder<T> gt() {
        return this.startBuilder(new GtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T gt(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new GtPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value)));
    }

    public T gtExpression(String expression) {
        return this.chain((Predicate)new GtPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression)));
    }

    public SubqueryInitiator<T> gt(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new GtPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public QuantifiableBinaryPredicateBuilder<T> ge() {
        return this.startBuilder(new GePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T ge(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new GePredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value)));
    }

    public T geExpression(String expression) {
        return this.chain((Predicate)new GePredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression)));
    }

    public SubqueryInitiator<T> ge(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new GePredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public QuantifiableBinaryPredicateBuilder<T> lt() {
        return this.startBuilder(new LtPredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T lt(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new LtPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value)));
    }

    public T ltExpression(String expression) {
        return this.chain((Predicate)new LtPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression)));
    }

    public SubqueryInitiator<T> lt(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new LtPredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public QuantifiableBinaryPredicateBuilder<T> le() {
        return this.startBuilder(new LePredicateBuilder<T>(this.result, this, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T le(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.chain((Predicate)new LePredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value)));
    }

    public T leExpression(String expression) {
        return this.chain((Predicate)new LePredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression)));
    }

    public SubqueryInitiator<T> le(String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression);
        this.rightSuperExprSubqueryPredicateBuilderListener = new SuperExpressionRightHandsideSubqueryPredicateBuilder(subqueryAlias, expr, this);
        return (SubqueryInitiator)this.startBuilder(new LePredicateBuilder<T>(this.result, this.rightSuperExprSubqueryPredicateBuilderListener, this.leftExpression, this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public T inExpressions(String ... parameterOrLiteralExpressions) {
        if (parameterOrLiteralExpressions == null) {
            throw new NullPointerException("parameterOrLiteralExpressions");
        }
        if (parameterOrLiteralExpressions.length == 0) {
            throw new IllegalArgumentException("empty parameterOrLiteralExpressions");
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, this.expressionFactory.createInPredicateExpression(parameterOrLiteralExpressions)));
    }

    public T in(List<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(values)));
    }

    public T in(Object ... values) {
        return this.in(Arrays.asList(values));
    }

    public T notInExpressions(String ... parameterOrLiteralExpressions) {
        if (parameterOrLiteralExpressions == null) {
            throw new NullPointerException("parameterOrLiteralExpressions");
        }
        if (parameterOrLiteralExpressions.length == 0) {
            throw new IllegalArgumentException("empty parameterOrLiteralExpressions");
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, this.expressionFactory.createInPredicateExpression(parameterOrLiteralExpressions), true));
    }

    public T notIn(List<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        return this.chain((Predicate)new InPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(values), true));
    }

    public T notIn(Object ... values) {
        return this.notIn(Arrays.asList(values));
    }

    public T isNull() {
        return this.chain((Predicate)new IsNullPredicate(this.leftExpression));
    }

    public T isNotNull() {
        return this.chain((Predicate)new IsNullPredicate(this.leftExpression, true));
    }

    public T isEmpty() {
        return this.chain((Predicate)new IsEmptyPredicate(this.makeCollectionValued(this.leftExpression)));
    }

    public T isNotEmpty() {
        return this.chain((Predicate)new IsEmptyPredicate(this.makeCollectionValued(this.leftExpression), true));
    }

    public T isMemberOf(String expression) {
        return this.chain((Predicate)new MemberOfPredicate(this.leftExpression, this.makeCollectionValued(this.expressionFactory.createSimpleExpression(expression))));
    }

    public T isNotMemberOf(String expression) {
        return this.chain((Predicate)new MemberOfPredicate(this.leftExpression, this.makeCollectionValued(this.expressionFactory.createSimpleExpression(expression)), true));
    }

    public LikeBuilder<T> like(boolean caseSensitive) {
        return this.startBuilder(new LikeBuilderImpl<T>(this.result, this, this.leftExpression, this.expressionFactory, this.parameterManager, this.subqueryInitFactory, false, caseSensitive));
    }

    public LikeBuilder<T> like() {
        return this.like(true);
    }

    public LikeBuilder<T> notLike(boolean caseSensitive) {
        return this.startBuilder(new LikeBuilderImpl<T>(this.result, this, this.leftExpression, this.expressionFactory, this.parameterManager, this.subqueryInitFactory, true, caseSensitive));
    }

    public LikeBuilder<T> notLike() {
        return this.notLike(true);
    }

    public SubqueryInitiator<T> in() {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(this.leftExpression, null);
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this);
    }

    public SubqueryInitiator<T> in(String subqueryAlias, String expression) {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(this.leftExpression, null);
        this.rightSuperExprSubqueryBuilderListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, this.expressionFactory.createArithmeticExpression(expression)){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                RestrictionBuilderImpl.this.onSubqueryBuilderEnded(this.superExpression);
                RestrictionBuilderImpl.this.listener.onBuilderEnded(RestrictionBuilderImpl.this);
            }
        };
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this.rightSuperExprSubqueryBuilderListener);
    }

    public SubqueryInitiator<T> notIn(String subqueryAlias, String expression) {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(this.leftExpression, null, true);
        this.rightSuperExprSubqueryBuilderListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, this.expressionFactory.createArithmeticExpression(expression)){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                RestrictionBuilderImpl.this.onSubqueryBuilderEnded(this.superExpression);
                RestrictionBuilderImpl.this.listener.onBuilderEnded(RestrictionBuilderImpl.this);
            }
        };
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this.rightSuperExprSubqueryBuilderListener);
    }

    public SubqueryInitiator<T> notIn() {
        this.verifyBuilderEnded();
        this.predicate = new InPredicate(this.leftExpression, null, true);
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this);
    }

    public RestrictionBuilderExperimental<T> nonPortable() {
        return this;
    }

    @Override
    protected <X extends PredicateBuilder> X startBuilder(X builder) {
        this.betweenStartSubqueryBuilderListener.verifySubqueryBuilderEnded();
        return super.startBuilder(builder);
    }

    @Override
    public void onBuilderEnded(PredicateBuilder builder) {
        super.onBuilderEnded(builder);
        this.predicate = builder.getPredicate();
        this.listener.onBuilderEnded(this);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        this.onSubqueryBuilderEnded((Expression)new SubqueryExpression(builder));
        this.listener.onBuilderEnded(this);
    }

    private void onSubqueryBuilderEnded(Expression rightHandsideExpression) {
        if (!(this.predicate instanceof InPredicate)) {
            throw new IllegalStateException("SubqueryBuilder ended but predicate was not an IN predicate");
        }
        ((InPredicate)this.predicate).setRight(rightHandsideExpression);
    }

    @Override
    protected void verifyBuilderEnded() {
        super.verifyBuilderEnded();
        this.betweenStartSubqueryBuilderListener.verifySubqueryBuilderEnded();
        if (this.rightSuperExprSubqueryBuilderListener != null) {
            this.rightSuperExprSubqueryBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.leftSuperExprSubqueryPredicateBuilderListener != null) {
            this.leftSuperExprSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
    }

    private Expression makeCollectionValued(Expression expr) {
        if (!(expr instanceof PathExpression)) {
            throw new SyntaxErrorException("Function expects collection valued path and cannot be applied to expression [" + expr + "]");
        }
        ((PathExpression)expr).setUsedInCollectionFunction(true);
        return expr;
    }

    private class SuperExpressionRightHandsideSubqueryPredicateBuilder
    implements PredicateBuilderEndedListener {
        private final PredicateBuilderEndedListener listener;
        private final String subqueryAlias;
        private final Expression superExpression;

        public SuperExpressionRightHandsideSubqueryPredicateBuilder(String subqueryAlias, Expression superExpression, PredicateBuilderEndedListener listener) {
            this.listener = listener;
            this.subqueryAlias = subqueryAlias;
            this.superExpression = superExpression;
        }

        @Override
        public void onBuilderEnded(PredicateBuilder builder) {
            Predicate pred = builder.getPredicate();
            BinaryExpressionPredicate binaryPred = pred instanceof NotPredicate ? (BinaryExpressionPredicate)((NotPredicate)pred).getPredicate() : (BinaryExpressionPredicate)builder.getPredicate();
            SubqueryExpression subqueryExpr = (SubqueryExpression)binaryPred.getRight();
            ExpressionUtils.replaceSubexpression(this.superExpression, this.subqueryAlias, (Expression)subqueryExpr);
            binaryPred.setRight(this.superExpression);
            this.listener.onBuilderEnded(builder);
        }
    }
}

