/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.impl.expression.Expression;
import com.blazebit.persistence.impl.expression.SubqueryExpression;
import com.blazebit.persistence.impl.predicate.NotPredicate;
import com.blazebit.persistence.impl.predicate.Predicate;
import com.blazebit.persistence.impl.predicate.PredicateBuilder;
import com.blazebit.persistence.impl.predicate.UnaryExpressionPredicate;

public class RightHandsideSubqueryPredicateBuilder<T>
extends SubqueryBuilderListenerImpl<T>
implements PredicateBuilder {
    private final Predicate predicate;
    private final PredicateBuilderEndedListener listener;

    public RightHandsideSubqueryPredicateBuilder(PredicateBuilderEndedListener listener, Predicate predicate) {
        this.predicate = predicate;
        this.listener = listener;
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        Predicate pred = this.predicate instanceof NotPredicate ? ((NotPredicate)this.predicate).getPredicate() : this.predicate;
        if (!(pred instanceof UnaryExpressionPredicate)) {
            throw new IllegalStateException("SubqueryBuilder ended but predicate type was unexpected");
        }
        ((UnaryExpressionPredicate)pred).setExpression((Expression)new SubqueryExpression(builder));
        this.listener.onBuilderEnded(this);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }
}

