/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.OrderByElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DB2DbmsDialect
extends DefaultDbmsDialect {
    @Override
    public String getWithClause(boolean recursive) {
        return "with";
    }

    @Override
    public boolean supportsReturningColumns() {
        return true;
    }

    @Override
    public boolean supportsModificationQueryInWithClause() {
        return true;
    }

    @Override
    public boolean usesExecuteUpdateWhenWithClauseInModificationQuery() {
        return false;
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean needsReturningWrapper;
        boolean requiresOld;
        boolean bl = requiresOld = includedModificationStates != null && includedModificationStates.containsKey(DbmsModificationState.OLD);
        if (requiresOld) {
            LinkedHashMap<String, String> dbmsModificationStateQueries = new LinkedHashMap<String, String>();
            StringBuilder sb = new StringBuilder(sqlSb.length() + 30);
            if (statementType == DbmsStatementType.INSERT) {
                StringBuilder newValuesSb = new StringBuilder();
                String newValuesTableName = "new_" + includedModificationStates.get(DbmsModificationState.OLD);
                newValuesSb.append("select * from final table (");
                newValuesSb.append((CharSequence)sqlSb);
                newValuesSb.append(")");
                dbmsModificationStateQueries.put("new_" + includedModificationStates.get(DbmsModificationState.OLD), newValuesSb.toString());
                String needle = "into";
                int startIndex = DB2DbmsDialect.indexOfIgnoreCase(sqlSb, needle) + needle.length() + 1;
                int endIndex = sqlSb.indexOf(" ", startIndex);
                endIndex = DB2DbmsDialect.indexOfOrEnd(sqlSb, '(', startIndex, endIndex);
                String table = sqlSb.substring(startIndex, endIndex);
                sb.append("select * from ");
                sb.append(table);
                sb.append("\nexcept\n");
                sb.append("select * from ");
                sb.append(newValuesTableName);
            } else {
                sb.append("select * from old table (");
                sb.append((CharSequence)sqlSb);
                sb.append(")");
            }
            sqlSb.setLength(0);
            if (isSubquery) {
                sqlSb.append('(');
            }
            sqlSb.append("select ");
            for (int i = 0; i < returningColumns.length; ++i) {
                if (i != 0) {
                    sqlSb.append(',');
                }
                sqlSb.append(returningColumns[i]);
            }
            sqlSb.append(" from ");
            sqlSb.append(includedModificationStates.get(DbmsModificationState.OLD));
            dbmsModificationStateQueries.put(includedModificationStates.get(DbmsModificationState.OLD), sb.toString());
            if (isSubquery) {
                sqlSb.append(')');
            }
            return dbmsModificationStateQueries;
        }
        boolean bl2 = needsReturningWrapper = isEmbedded && (returningColumns != null || statementType != DbmsStatementType.SELECT);
        if (needsReturningWrapper || withClause != null && statementType != DbmsStatementType.SELECT) {
            if (isSubquery) {
                sqlSb.insert(0, '(');
            }
            if (limit != null) {
                this.appendLimit(sqlSb, isSubquery, limit, offset);
            }
            String[] columns = returningColumns == null ? new String[]{"count(*)"} : returningColumns;
            if (needsReturningWrapper) {
                this.applyQueryReturning(sqlSb, statementType, withClause, columns);
            } else {
                this.applyQueryReturning(sqlSb, statementType, withClause, columns);
            }
            if (isSubquery) {
                sqlSb.append(')');
            }
            return null;
        }
        if (isSubquery) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(DB2DbmsDialect.indexOfIgnoreCase(sqlSb, "select"), withClause);
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (isSubquery) {
            sqlSb.append(')');
        }
        return null;
    }

    @Override
    public void appendLimit(StringBuilder sqlSb, boolean isSubquery, String limit, String offset) {
        if (offset == null) {
            sqlSb.append(" fetch first ").append(limit).append(" rows only");
        } else {
            sqlSb.append(" limit ").append(limit).append(" offset ").append(offset);
        }
    }

    @Override
    protected void appendSetOperands(StringBuilder sqlSb, String operator, boolean isSubquery, List<String> operands, boolean hasOuterClause) {
        if (!hasOuterClause) {
            super.appendSetOperands(sqlSb, operator, isSubquery, operands, hasOuterClause);
        } else {
            sqlSb.append("select * from (");
            super.appendSetOperands(sqlSb, operator, isSubquery, operands, hasOuterClause);
            sqlSb.append(')');
        }
    }

    @Override
    protected void appendOrderByElement(StringBuilder sqlSb, OrderByElement element) {
        if (element.isNullsFirst() && !element.isAscending() || !element.isNullsFirst() && element.isAscending()) {
            super.appendOrderByElement(sqlSb, element);
        } else {
            this.appendEmulatedOrderByElementWithNulls(sqlSb, element);
        }
    }

    private void applyQueryReturning(StringBuilder sqlSb, DbmsStatementType statementType, StringBuilder withClause, String[] returningColumns) {
        int initial = withClause != null ? withClause.length() : 0;
        StringBuilder sb = new StringBuilder(initial + 25 + returningColumns.length * 20);
        if (withClause != null) {
            sb.append((CharSequence)withClause);
        }
        sb.append("select ");
        for (int i = 0; i < returningColumns.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(returningColumns[i]);
            sb.append(" as ret_col_");
            sb.append(i);
        }
        sb.append(" from ");
        if (statementType == DbmsStatementType.DELETE) {
            sb.append("old");
        } else {
            sb.append("final");
        }
        sb.append(" table (");
        sqlSb.insert(0, sb);
        sqlSb.append(')');
    }

    private static int indexOfOrEnd(StringBuilder sb, char needle, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (sb.charAt(startIndex) == needle) {
                return startIndex;
            }
            ++startIndex;
        }
        return endIndex;
    }
}

