/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultDbmsDialect
implements DbmsDialect {
    public boolean supportsWithClause() {
        return true;
    }

    public boolean supportsNonRecursiveWithClause() {
        return true;
    }

    public String getWithClause(boolean recursive) {
        if (recursive) {
            return "with recursive";
        }
        return "with";
    }

    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        if (isSubquery) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(0, withClause);
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (isSubquery && !this.supportsReturningColumns() && returningColumns != null) {
            throw new IllegalArgumentException("Returning columns in a subquery is not possible for this dbms!");
        }
        if (isSubquery) {
            sqlSb.append(')');
        }
        return null;
    }

    public void appendSet(StringBuilder sqlSb, SetOperationType setType, boolean isSubquery, List<String> operands, List<? extends OrderByElement> orderByElements, String limit, String offset) {
        if (isSubquery) {
            sqlSb.insert(0, '(');
        }
        if (operands.size() > 0) {
            String operator = this.getOperator(setType);
            boolean hasLimit = limit != null;
            boolean hasOrderBy = orderByElements.size() > 0;
            boolean hasOuterClause = hasLimit || hasOrderBy;
            this.appendSetOperands(sqlSb, operator, isSubquery, operands, hasOuterClause);
            this.appendOrderBy(sqlSb, orderByElements);
            if (limit != null) {
                this.appendLimit(sqlSb, isSubquery, limit, offset);
            }
        }
        if (isSubquery) {
            sqlSb.append(')');
        }
    }

    protected void appendSetOperands(StringBuilder sqlSb, String operator, boolean isSubquery, List<String> operands, boolean hasOuterClause) {
        boolean first = true;
        for (String operand : operands) {
            if (first) {
                first = false;
            } else {
                sqlSb.append("\n");
                sqlSb.append(operator);
                sqlSb.append("\n");
            }
            sqlSb.append(operand);
        }
    }

    protected void appendOrderBy(StringBuilder sqlSb, List<? extends OrderByElement> orderByElements) {
        if (orderByElements.isEmpty()) {
            return;
        }
        sqlSb.append(" order by ");
        boolean first = true;
        for (OrderByElement orderByElement : orderByElements) {
            if (first) {
                first = false;
            } else {
                sqlSb.append(',');
            }
            this.appendOrderByElement(sqlSb, orderByElement);
        }
    }

    protected void appendOrderByElement(StringBuilder sqlSb, OrderByElement element) {
        sqlSb.append(element.getPosition());
        if (element.isAscending()) {
            sqlSb.append(" asc");
        } else {
            sqlSb.append(" desc");
        }
        if (element.isNullsFirst()) {
            sqlSb.append(" nulls first");
        } else {
            sqlSb.append(" nulls last");
        }
    }

    protected void appendEmulatedOrderByElementWithNulls(StringBuilder sqlSb, OrderByElement element) {
        sqlSb.append("case when ");
        sqlSb.append(element.getPosition());
        sqlSb.append(" is null then ");
        sqlSb.append(element.isNullsFirst() ? 0 : 1);
        sqlSb.append(" else ");
        sqlSb.append(element.isNullsFirst() ? 1 : 0);
        sqlSb.append(" end, ");
        sqlSb.append(element.getPosition());
        sqlSb.append(element.isAscending() ? " asc" : " desc");
    }

    protected String getOperator(SetOperationType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT ALL";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT ALL";
            }
        }
        return null;
    }

    public boolean supportsUnion(boolean all) {
        return true;
    }

    public boolean supportsIntersect(boolean all) {
        return !all;
    }

    public boolean supportsExcept(boolean all) {
        return !all;
    }

    public boolean supportsWithClauseInModificationQuery() {
        return true;
    }

    public boolean supportsModificationQueryInWithClause() {
        return false;
    }

    public boolean usesExecuteUpdateWhenWithClauseInModificationQuery() {
        return true;
    }

    public boolean supportsReturningGeneratedKeys() {
        return true;
    }

    public boolean supportsReturningAllGeneratedKeys() {
        return true;
    }

    public boolean supportsReturningColumns() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public void appendLimit(StringBuilder sqlSb, boolean isSubquery, String limit, String offset) {
        if (offset == null) {
            sqlSb.append(" limit ").append(limit);
        } else {
            sqlSb.append(" limit ").append(limit).append(" offset ").append(offset);
        }
    }

    protected static String[] getSelectColumnAliases(String querySql) {
        int fromIndex = querySql.indexOf("from");
        int selectIndex = querySql.indexOf("select");
        String[] selectItems = DefaultDbmsDialect.splitSelectItems(querySql.subSequence(selectIndex + "select".length() + 1, fromIndex));
        String[] selectColumnAliases = new String[selectItems.length];
        for (int i = 0; i < selectItems.length; ++i) {
            String selectItemWithAlias = selectItems[i].substring(selectItems[i].lastIndexOf(46) + 1);
            selectColumnAliases[i] = selectItemWithAlias.substring(selectItemWithAlias.lastIndexOf(32) + 1);
        }
        return selectColumnAliases;
    }

    private static String[] splitSelectItems(CharSequence itemsString) {
        ArrayList<String> selectItems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int parenthesis = 0;
        boolean text = false;
        int i = 0;
        int length = itemsString.length();
        while (i < length) {
            char c = itemsString.charAt(i);
            if (text) {
                if (c == '(') {
                    ++parenthesis;
                } else if (c == ')') {
                    --parenthesis;
                } else if (parenthesis == 0 && c == ',') {
                    selectItems.add(DefaultDbmsDialect.trim(sb));
                    sb.setLength(0);
                    text = false;
                    ++i;
                    continue;
                }
                sb.append(c);
            } else if (!Character.isWhitespace(c)) {
                sb.append(c);
                text = true;
            }
            ++i;
        }
        if (text) {
            selectItems.add(DefaultDbmsDialect.trim(sb));
        }
        return selectItems.toArray(new String[selectItems.size()]);
    }

    private static String trim(StringBuilder sb) {
        int i;
        for (i = sb.length() - 1; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return sb.substring(0, i + 1);
    }

    protected static int indexOfIgnoreCase(StringBuilder haystack, String needle) {
        int endLimit = haystack.length() - needle.length() + 1;
        for (int i = 0; i < endLimit; ++i) {
            if (!DefaultDbmsDialect.regionMatchesIgnoreCase(haystack, i, needle, 0, needle.length())) continue;
            return i;
        }
        return -1;
    }

    protected static boolean regionMatchesIgnoreCase(StringBuilder haystack, int thisStart, String substring, int start, int length) {
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = haystack.charAt(index1++)) == (c2 = substring.charAt(index2++)) || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

