/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import java.util.List;
import java.util.Map;

public class H2DbmsDialect
extends DefaultDbmsDialect {
    @Override
    public boolean supportsReturningAllGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsWithClause() {
        return true;
    }

    @Override
    public boolean supportsNonRecursiveWithClause() {
        return false;
    }

    @Override
    public String getWithClause(boolean recursive) {
        return "with recursive";
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        if (isSubquery) {
            sqlSb.insert(0, '(');
        }
        if (isSubquery && returningColumns != null) {
            throw new IllegalArgumentException("Returning columns in a subquery is not possible for this dbms!");
        }
        if (withClause != null) {
            sqlSb.insert(H2DbmsDialect.indexOfIgnoreCase(sqlSb, "select"), withClause);
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (isSubquery) {
            sqlSb.append(')');
        }
        return null;
    }

    @Override
    protected void appendSetOperands(StringBuilder sqlSb, String operator, boolean isSubquery, List<String> operands, boolean hasOuterClause) {
        if (!hasOuterClause) {
            super.appendSetOperands(sqlSb, operator, isSubquery, operands, hasOuterClause);
        } else {
            sqlSb.append("select * from (");
            super.appendSetOperands(sqlSb, operator, isSubquery, operands, hasOuterClause);
            sqlSb.append(')');
        }
    }

    @Override
    public boolean supportsWithClauseInModificationQuery() {
        return false;
    }
}

