/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.function.CyclicUnsignedCounter;
import com.blazebit.persistence.spi.OrderByElement;

public class MySQLDbmsDialect
extends DefaultDbmsDialect {
    private static final ThreadLocal<CyclicUnsignedCounter> threadLocalCounter = new ThreadLocal<CyclicUnsignedCounter>(){

        @Override
        protected CyclicUnsignedCounter initialValue() {
            return new CyclicUnsignedCounter(-1);
        }
    };

    @Override
    public boolean supportsWithClause() {
        return false;
    }

    @Override
    public boolean supportsNonRecursiveWithClause() {
        return false;
    }

    @Override
    public String getWithClause(boolean recursive) {
        throw new UnsupportedOperationException("With clause is not supported!");
    }

    @Override
    public boolean supportsUnion(boolean all) {
        return true;
    }

    @Override
    public boolean supportsIntersect(boolean all) {
        return false;
    }

    @Override
    public boolean supportsExcept(boolean all) {
        return false;
    }

    @Override
    public void appendLimit(StringBuilder sqlSb, boolean isSubquery, String limit, String offset) {
        if (isSubquery) {
            sqlSb.insert(1, "SELECT * FROM (");
        }
        if (offset == null) {
            sqlSb.append(" limit ").append(limit);
        } else {
            sqlSb.append(" limit ").append(offset).append(',').append(limit);
        }
        if (isSubquery) {
            String limitSubqueryAlias = "_tmp_" + threadLocalCounter.get().incrementAndGet();
            sqlSb.append(") as ").append(limitSubqueryAlias);
        }
    }

    @Override
    protected void appendOrderByElement(StringBuilder sqlSb, OrderByElement element) {
        this.appendEmulatedOrderByElementWithNulls(sqlSb, element);
    }
}

