/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PostgreSQLDbmsDialect
extends DefaultDbmsDialect {
    @Override
    public boolean supportsModificationQueryInWithClause() {
        return true;
    }

    @Override
    public boolean supportsReturningColumns() {
        return true;
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean requiresNew;
        boolean bl = requiresNew = includedModificationStates != null && includedModificationStates.containsKey(DbmsModificationState.NEW);
        if (requiresNew) {
            StringBuilder sb = new StringBuilder(sqlSb.length() + returningColumns.length * 30);
            sb.append((CharSequence)sqlSb);
            sb.append(" returning *");
            sqlSb.setLength(0);
            if (isSubquery) {
                sqlSb.append('(');
            }
            if (statementType == DbmsStatementType.DELETE) {
                PostgreSQLDbmsDialect.appendSelectColumnsFromTable(statementType, sb, sqlSb, returningColumns);
                sqlSb.append("\nexcept\n");
                PostgreSQLDbmsDialect.appendSelectColumnsFromCte(sqlSb, returningColumns, includedModificationStates);
            } else {
                PostgreSQLDbmsDialect.appendSelectColumnsFromCte(sqlSb, returningColumns, includedModificationStates);
                sqlSb.append("\nunion\n");
                PostgreSQLDbmsDialect.appendSelectColumnsFromTable(statementType, sb, sqlSb, returningColumns);
            }
            if (isSubquery) {
                sqlSb.append(')');
            }
            return Collections.singletonMap(includedModificationStates.get(DbmsModificationState.NEW), sb.toString());
        }
        if (isSubquery) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(0, withClause);
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (isEmbedded && returningColumns != null) {
            sqlSb.append(" returning ");
            for (int i = 0; i < returningColumns.length; ++i) {
                if (i != 0) {
                    sqlSb.append(",");
                }
                sqlSb.append(returningColumns[i]);
            }
        }
        if (isSubquery) {
            sqlSb.append(')');
        }
        return null;
    }

    @Override
    protected void appendSetOperands(StringBuilder sqlSb, String operator, boolean isSubquery, List<String> operands, boolean hasOuterClause) {
        boolean first = true;
        for (String operand : operands) {
            if (first) {
                first = false;
            } else {
                sqlSb.append("\n");
                sqlSb.append(operator);
                sqlSb.append("\n");
            }
            if (hasOuterClause && !operand.startsWith("(")) {
                sqlSb.append('(');
                sqlSb.append(operand);
                sqlSb.append(')');
                continue;
            }
            sqlSb.append(operand);
        }
    }

    private static void appendSelectColumnsFromCte(StringBuilder sqlSb, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        sqlSb.append("select ");
        for (int i = 0; i < returningColumns.length; ++i) {
            if (i != 0) {
                sqlSb.append(",");
            }
            sqlSb.append(returningColumns[i]);
        }
        sqlSb.append(" from ");
        sqlSb.append(includedModificationStates.get(DbmsModificationState.NEW));
    }

    private static void appendSelectColumnsFromTable(DbmsStatementType statementType, StringBuilder sb, StringBuilder sqlSb, String[] returningColumns) {
        String table;
        int endIndex;
        int startIndex;
        String needle;
        if (statementType == DbmsStatementType.DELETE) {
            needle = "from";
            startIndex = PostgreSQLDbmsDialect.indexOfIgnoreCase(sb, needle) + needle.length() + 1;
            endIndex = sb.indexOf(" ", startIndex);
            table = sb.substring(startIndex, endIndex);
        } else if (statementType == DbmsStatementType.UPDATE) {
            needle = "update";
            startIndex = PostgreSQLDbmsDialect.indexOfIgnoreCase(sb, needle) + needle.length() + 1;
            endIndex = sb.indexOf(" ", startIndex);
            table = sb.substring(startIndex, endIndex);
        } else if (statementType == DbmsStatementType.INSERT) {
            needle = "into";
            startIndex = PostgreSQLDbmsDialect.indexOfIgnoreCase(sb, needle) + needle.length() + 1;
            endIndex = sb.indexOf(" ", startIndex);
            endIndex = PostgreSQLDbmsDialect.indexOfOrEnd(sb, '(', startIndex, endIndex);
            table = sb.substring(startIndex, endIndex);
        } else {
            throw new IllegalArgumentException("Unsupported statement type: " + statementType);
        }
        sqlSb.append(" select ");
        for (int i = 0; i < returningColumns.length; ++i) {
            if (i != 0) {
                sqlSb.append(",");
            }
            sqlSb.append(returningColumns[i]);
        }
        sqlSb.append(" from ");
        sqlSb.append(table);
    }

    private static int indexOfOrEnd(StringBuilder sb, char needle, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (sb.charAt(startIndex) == needle) {
                return startIndex;
            }
            ++startIndex;
        }
        return endIndex;
    }
}

