/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.groupconcat;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.TemplateRenderer;

public abstract class AbstractGroupConcatFunction
implements JpqlFunction {
    protected final TemplateRenderer renderer;

    public AbstractGroupConcatFunction(String template) {
        this.renderer = new TemplateRenderer(template);
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return String.class;
    }

    protected GroupConcat getGroupConcat(FunctionRenderContext context) {
        if (context.getArgumentsSize() == 0) {
            throw new RuntimeException("The group concat function needs at least one argument! args=" + context);
        }
        boolean distinct = false;
        int startIndex = 0;
        int argsSize = context.getArgumentsSize();
        String maybeDistinct = context.getArgument(0);
        if ("distinct".equalsIgnoreCase(maybeDistinct)) {
            distinct = true;
            ++startIndex;
        }
        if (startIndex >= argsSize) {
            throw new RuntimeException("The group concat function needs at least one expression to concatenate! args=" + context);
        }
        String expression = context.getArgument(startIndex);
        String separator = null;
        StringBuilder orderSb = new StringBuilder();
        boolean orderBy = false;
        for (int i = startIndex + 1; i < argsSize; ++i) {
            String argument = context.getArgument(i);
            if ("SEPARATOR".equalsIgnoreCase(argument)) {
                orderBy = false;
                continue;
            }
            if ("ORDER BY".equalsIgnoreCase(argument)) {
                orderBy = true;
                continue;
            }
            if (orderBy) {
                if (AbstractGroupConcatFunction.isOrderType(argument)) {
                    orderSb.append(' ');
                    orderSb.append(argument);
                    continue;
                }
                if (orderSb.length() > 0) {
                    orderSb.append(',');
                }
                orderSb.append(argument);
                continue;
            }
            if (separator != null) {
                throw new RuntimeException("Multple separators given in arguments for group concat! args=" + context);
            }
            separator = argument;
        }
        if (separator == null) {
            separator = ",";
        }
        return new GroupConcat(distinct, expression, orderSb.toString(), separator);
    }

    private static boolean isOrderType(String s) {
        String type = s.trim().toUpperCase();
        return "ASC".equals(type) || "DESC".equals(type) || "ASC NULLS FIRST".equals(type) || "ASC NULLS LAST".equals(type) || "DESC NULLS FIRST".equals(type) || "DESC NULLS LAST".equals(type);
    }

    protected static final class GroupConcat {
        private final boolean distinct;
        private final String expression;
        private final String orderByExpression;
        private final String separator;

        public GroupConcat(boolean distinct, String expression, String orderByExpression, String separator) {
            this.distinct = distinct;
            this.expression = expression;
            this.orderByExpression = orderByExpression;
            this.separator = separator;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getOrderByExpression() {
            return this.orderByExpression;
        }

        public String getSeparator() {
            return this.separator;
        }
    }
}

